/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectDataService
extends AbstractProjectDataService<JavaProjectData, Project> {
    @NotNull
    public Key<JavaProjectData> getTargetDataKey() {
        Key<JavaProjectData> key2 = JavaProjectData.KEY;
        if (key2 == null) {
            JavaProjectDataService.$$$reportNull$$$0(0);
        }
        return key2;
    }

    public void importData(@NotNull Collection<DataNode<JavaProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            JavaProjectDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JavaProjectDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            JavaProjectDataService.$$$reportNull$$$0(3);
        }
        if (toImport.isEmpty() || projectData == null) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<JavaProjectData> javaProjectDataNode = toImport.iterator().next();
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(javaProjectDataNode, (Key)ProjectKeys.PROJECT);
        assert (projectDataNode != null);
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)((ProjectData)projectDataNode.getData()))) {
            return;
        }
        JavaProjectData javaProjectData = (JavaProjectData)((Object)javaProjectDataNode.getData());
        JavaSdkVersion version = javaProjectData.getJdkVersion();
        JavaSdk javaSdk = JavaSdk.getInstance();
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        Sdk sdk = rootManager.getProjectSdk();
        if (sdk != null) {
            JavaSdkVersion currentVersion = javaSdk.getVersion(sdk);
            if (currentVersion == null || !currentVersion.isAtLeast(version)) {
                JavaProjectDataService.updateSdk(project, version);
            }
        } else {
            JavaProjectDataService.updateSdk(project, version);
        }
        this.setLanguageLevel(javaProjectData.getLanguageLevel(), project);
    }

    private static void updateSdk(final @NotNull Project project, final @NotNull JavaSdkVersion version) {
        Sdk sdk;
        if (project == null) {
            JavaProjectDataService.$$$reportNull$$$0(4);
        }
        if (version == null) {
            JavaProjectDataService.$$$reportNull$$$0(5);
        }
        if ((sdk = JavaSdkVersionUtil.findJdkByVersion((JavaSdkVersion)version)) == null) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                ProjectRootManager.getInstance((Project)project).setProjectSdk(sdk);
                LanguageLevel level = version.getMaxLanguageLevel();
                LanguageLevelProjectExtension languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project);
                if (level.compareTo((Enum)languageLevelExtension.getLanguageLevel()) < 0) {
                    languageLevelExtension.setLanguageLevel(level);
                }
            }
        });
    }

    public void setLanguageLevel(final @NotNull LanguageLevel languageLevel, @NotNull Project project) {
        LanguageLevelProjectExtension languageLevelExtension;
        if (languageLevel == null) {
            JavaProjectDataService.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JavaProjectDataService.$$$reportNull$$$0(7);
        }
        if ((languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project)).getLanguageLevel().isAtLeast(languageLevel)) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                languageLevelExtension.setLanguageLevel(languageLevel);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalSystem/JavaProjectDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalSystem/JavaProjectDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateSdk";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

