/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedSymbol;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiModifier;
import com.intellij.ui.ClickListener;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class VisibilityModifierChooser
extends JLabel
implements UserActivityProviderComponent {
    @PsiModifier.ModifierConstant
    private static final String[] MODIFIERS = new String[]{"private", "packageLocal", "protected", "public"};
    private final Supplier<Boolean> myCanBeEnabled;
    private final Set<ChangeListener> myListeners;
    private String myCurrentModifier;

    public VisibilityModifierChooser(@NotNull Supplier<Boolean> canBeEnabled, @NotNull String modifier, @NotNull Consumer<? super String> modifierChangedConsumer) {
        if (canBeEnabled == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(0);
        }
        if (modifier == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(1);
        }
        if (modifierChangedConsumer == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(2);
        }
        this(canBeEnabled, modifier, modifierChangedConsumer, MODIFIERS);
    }

    public VisibilityModifierChooser(@NotNull Supplier<Boolean> canBeEnabled, @NotNull String modifier, final @NotNull Consumer<? super String> modifierChangedConsumer, final @NotNull String[] modifiers) {
        if (canBeEnabled == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(3);
        }
        if (modifier == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(4);
        }
        if (modifierChangedConsumer == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(5);
        }
        if (modifiers == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(6);
        }
        this.myListeners = new HashSet<ChangeListener>();
        this.myCanBeEnabled = canBeEnabled;
        this.setIcon(AllIcons.General.ArrowDown);
        this.setDisabledIcon(AllIcons.General.ArrowDown);
        this.setIconTextGap(0);
        this.setHorizontalTextPosition(2);
        this.myCurrentModifier = modifier;
        this.setText(VisibilityModifierChooser.getPresentableText(this.myCurrentModifier));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!VisibilityModifierChooser.this.isEnabled()) {
                    return true;
                }
                Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
                for (int i = 0; i < modifiers.length; ++i) {
                    sliderLabels.put(i + 1, new JLabel(VisibilityModifierChooser.getPresentableText(modifiers[i])));
                }
                JSlider slider = new JSlider(1, 1, modifiers.length, 1);
                slider.addChangeListener(val -> {
                    String modifier = modifiers[slider.getValue() - 1];
                    if (VisibilityModifierChooser.this.myCurrentModifier != modifier) {
                        VisibilityModifierChooser.this.myCurrentModifier = modifier;
                        modifierChangedConsumer.consume((Object)modifier);
                        VisibilityModifierChooser.this.setText(VisibilityModifierChooser.getPresentableText(modifier));
                        VisibilityModifierChooser.this.fireStateChanged();
                    }
                });
                slider.setLabelTable(sliderLabels);
                slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
                slider.setPreferredSize((Dimension)JBUI.size((int)150, (int)(modifiers.length * 25)));
                slider.setPaintLabels(true);
                slider.setSnapToTicks(true);
                slider.setValue(ArrayUtil.find((Object[])modifiers, (Object)VisibilityModifierChooser.this.myCurrentModifier) + 1);
                JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)slider, null).setTitle("Effective Visibility").setCancelOnClickOutside(true).setMovable(true).createPopup();
                popup.show(new RelativePoint((Component)VisibilityModifierChooser.this, new Point(VisibilityModifierChooser.this.getWidth(), 0)));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/unusedSymbol/VisibilityModifierChooser$1", "onClick"));
            }
        }.installOn((Component)this);
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private static String getPresentableText(String modifier) {
        return StringUtil.capitalize((String)VisibilityUtil.toPresentableText((String)modifier));
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(this.isEnabled() ? JBUI.CurrentTheme.Link.linkColor() : fg);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled && this.myCanBeEnabled.get() != false);
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(7);
        }
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            VisibilityModifierChooser.$$$reportNull$$$0(8);
        }
        this.myListeners.remove(changeListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeEnabled";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierChangedConsumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/unusedSymbol/VisibilityModifierChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChangeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

