/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaLangReflectHandleInvocationChecker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaLangReflectVarHandleInvocationChecker {
    private static final Logger LOG = Logger.getInstance(JavaLangReflectVarHandleInvocationChecker.class);
    static final String ARRAY_ELEMENT_VAR_HANDLE = "arrayElementVarHandle";
    static final String JAVA_LANG_INVOKE_VAR_HANDLE = "java.lang.invoke.VarHandle";
    static final String JAVA_LANG_INVOKE_METHOD_HANDLES = "java.lang.invoke.MethodHandles";
    private static final String GET = "get";
    private static final String GET_VOLATILE = "getVolatile";
    private static final String GET_OPAQUE = "getOpaque";
    private static final String GET_ACQUIRE = "getAcquire";
    private static final String SET = "set";
    private static final String SET_VOLATILE = "setVolatile";
    private static final String SET_OPAQUE = "setOpaque";
    private static final String SET_RELEASE = "setRelease";
    private static final String GET_AND_SET = "getAndSet";
    private static final String GET_AND_SET_ACQUIRE = "getAndSetAcquire";
    private static final String GET_AND_SET_RELEASE = "getAndSetRelease";
    private static final String GET_AND_ADD = "getAndAdd";
    private static final String GET_AND_ADD_ACQUIRE = "getAndAddAcquire";
    private static final String GET_AND_ADD_RELEASE = "getAndAddRelease";
    private static final String GET_AND_BITWISE_OR = "getAndBitwiseOr";
    private static final String GET_AND_BITWISE_OR_ACQUIRE = "getAndBitwiseOrAcquire";
    private static final String GET_AND_BITWISE_OR_RELEASE = "getAndBitwiseOrRelease";
    private static final String GET_AND_BITWISE_AND = "getAndBitwiseAnd";
    private static final String GET_AND_BITWISE_AND_ACQUIRE = "getAndBitwiseAndAcquire";
    private static final String GET_AND_BITWISE_AND_RELEASE = "getAndBitwiseAndRelease";
    private static final String GET_AND_BITWISE_XOR = "getAndBitwiseXor";
    private static final String GET_AND_BITWISE_XOR_ACQUIRE = "getAndBitwiseXorAcquire";
    private static final String GET_AND_BITWISE_XOR_RELEASE = "getAndBitwiseXorRelease";
    private static final String COMPARE_AND_SET = "compareAndSet";
    private static final String COMPARE_AND_EXCHANGE = "compareAndExchange";
    private static final String COMPARE_AND_EXCHANGE_ACQUIRE = "compareAndExchangeAcquire";
    private static final String COMPARE_AND_EXCHANGE_RELEASE = "compareAndExchangeRelease";
    private static final String WEAK_COMPARE_AND_SET = "weakCompareAndSet";
    private static final String WEAK_COMPARE_AND_SET_ACQUIRE = "weakCompareAndSetAcquire";
    private static final String WEAK_COMPARE_AND_SET_PLAIN = "weakCompareAndSetPlain";
    private static final String WEAK_COMPARE_AND_SET_RELEASE = "weakCompareAndSetRelease";
    private static final ObjectIntHashMap<String> VAR_HANDLE_ARGUMENT_COUNTS = new ObjectIntHashMap();
    private static final Set<String> WITH_RETURN_VALUE_NAMES;

    JavaLangReflectVarHandleInvocationChecker() {
    }

    static boolean checkVarHandleAccess(PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            JavaLangReflectVarHandleInvocationChecker.$$$reportNull$$$0(0);
        }
        if (JavaLangReflectVarHandleInvocationChecker.isVarHandleAccessMethod(methodCall)) {
            PsiExpression qualifierDefinition = JavaReflectionReferenceUtil.findDefinition(methodCall.getMethodExpression().getQualifierExpression());
            if (qualifierDefinition instanceof PsiMethodCallExpression) {
                JavaReflectionReferenceUtil.ReflectiveType arrayType;
                PsiMethodCallExpression handleFactoryCall = (PsiMethodCallExpression)qualifierDefinition;
                PsiExpression[] factoryArguments = handleFactoryCall.getArgumentList().getExpressions();
                if (JavaReflectionReferenceUtil.isCallToMethod(handleFactoryCall, "java.lang.invoke.MethodHandles.Lookup", "findVarHandle")) {
                    if (factoryArguments.length == 3) {
                        JavaLangReflectHandleInvocationChecker.checkCallReceiver(methodCall, JavaReflectionReferenceUtil.getReflectiveType(factoryArguments[0]), holder);
                        JavaLangReflectVarHandleInvocationChecker.checkVarHandleAccessSignature(methodCall, JavaReflectionReferenceUtil.getReflectiveType(factoryArguments[2]), 1, holder);
                    }
                } else if (JavaReflectionReferenceUtil.isCallToMethod(handleFactoryCall, "java.lang.invoke.MethodHandles.Lookup", "findStaticVarHandle")) {
                    if (factoryArguments.length == 3) {
                        JavaLangReflectVarHandleInvocationChecker.checkVarHandleAccessSignature(methodCall, JavaReflectionReferenceUtil.getReflectiveType(factoryArguments[2]), 0, holder);
                    }
                } else if (JavaReflectionReferenceUtil.isCallToMethod(handleFactoryCall, JAVA_LANG_INVOKE_METHOD_HANDLES, ARRAY_ELEMENT_VAR_HANDLE) && factoryArguments.length == 1 && (arrayType = JavaReflectionReferenceUtil.getReflectiveType(factoryArguments[0])) != null) {
                    JavaLangReflectHandleInvocationChecker.checkCallReceiver(methodCall, arrayType, holder);
                    JavaReflectionReferenceUtil.ReflectiveType valueType = arrayType.getArrayComponentType();
                    if (valueType != null) {
                        JavaLangReflectVarHandleInvocationChecker.checkVarHandleAccessSignature(methodCall, valueType, 2, holder);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static void checkVarHandleAccessSignature(@NotNull PsiMethodCallExpression accessCall, @Nullable JavaReflectionReferenceUtil.ReflectiveType valueType, int coordinateArguments, @NotNull ProblemsHolder holder) {
        int requiredArgumentCount;
        PsiExpressionList accessArgumentList;
        PsiExpression[] accessArguments;
        if (accessCall == null) {
            JavaLangReflectVarHandleInvocationChecker.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JavaLangReflectVarHandleInvocationChecker.$$$reportNull$$$0(2);
        }
        if (valueType == null) {
            return;
        }
        if (JavaLangReflectVarHandleInvocationChecker.isWithReturnValue(accessCall)) {
            JavaLangReflectHandleInvocationChecker.checkReturnType(accessCall, valueType, false, holder);
        }
        if (!JavaLangReflectHandleInvocationChecker.checkArgumentCount(accessArguments = (accessArgumentList = accessCall.getArgumentList()).getExpressions(), requiredArgumentCount = JavaLangReflectVarHandleInvocationChecker.getVarHandleArgumentCount(accessCall, coordinateArguments), 0, (PsiElement)accessArgumentList, holder)) {
            return;
        }
        LOG.assertTrue(accessArguments.length == requiredArgumentCount);
        for (int i = coordinateArguments; i < requiredArgumentCount; ++i) {
            JavaLangReflectHandleInvocationChecker.checkArgumentType(accessArguments[i], valueType, accessArgumentList, false, holder);
        }
    }

    private static boolean isVarHandleAccessMethod(PsiMethodCallExpression methodCall) {
        String methodName = methodCall.getMethodExpression().getReferenceName();
        if (VAR_HANDLE_ARGUMENT_COUNTS.containsKey((Object)methodName)) {
            PsiMethod method = methodCall.resolveMethod();
            return method != null && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), JAVA_LANG_INVOKE_VAR_HANDLE);
        }
        return false;
    }

    private static int getVarHandleArgumentCount(@NotNull PsiMethodCallExpression accessCall, int coordinateArguments) {
        String name;
        int count;
        if (accessCall == null) {
            JavaLangReflectVarHandleInvocationChecker.$$$reportNull$$$0(3);
        }
        return (count = VAR_HANDLE_ARGUMENT_COUNTS.get((Object)(name = accessCall.getMethodExpression().getReferenceName()))) >= 0 ? count + coordinateArguments : -1;
    }

    private static boolean isWithReturnValue(@NotNull PsiMethodCallExpression accessCall) {
        if (accessCall == null) {
            JavaLangReflectVarHandleInvocationChecker.$$$reportNull$$$0(4);
        }
        String name = accessCall.getMethodExpression().getReferenceName();
        return WITH_RETURN_VALUE_NAMES.contains(name);
    }

    static {
        for (String name : Arrays.asList(GET, GET_VOLATILE, GET_OPAQUE, GET_ACQUIRE)) {
            VAR_HANDLE_ARGUMENT_COUNTS.put((Object)name, 0);
        }
        for (String name : Arrays.asList(SET, SET_VOLATILE, SET_OPAQUE, SET_RELEASE, GET_AND_SET, GET_AND_SET_ACQUIRE, GET_AND_SET_RELEASE, GET_AND_ADD, GET_AND_ADD_ACQUIRE, GET_AND_ADD_RELEASE, GET_AND_BITWISE_OR, GET_AND_BITWISE_OR_ACQUIRE, GET_AND_BITWISE_OR_RELEASE, GET_AND_BITWISE_AND, GET_AND_BITWISE_AND_ACQUIRE, GET_AND_BITWISE_AND_RELEASE, GET_AND_BITWISE_XOR, GET_AND_BITWISE_XOR_ACQUIRE, GET_AND_BITWISE_XOR_RELEASE)) {
            VAR_HANDLE_ARGUMENT_COUNTS.put((Object)name, 1);
        }
        for (String name : Arrays.asList(COMPARE_AND_SET, COMPARE_AND_EXCHANGE, COMPARE_AND_EXCHANGE_ACQUIRE, COMPARE_AND_EXCHANGE_RELEASE, WEAK_COMPARE_AND_SET, WEAK_COMPARE_AND_SET_ACQUIRE, WEAK_COMPARE_AND_SET_PLAIN, WEAK_COMPARE_AND_SET_RELEASE)) {
            VAR_HANDLE_ARGUMENT_COUNTS.put((Object)name, 2);
        }
        WITH_RETURN_VALUE_NAMES = ContainerUtil.set((Object[])new String[]{GET, GET_VOLATILE, GET_OPAQUE, GET_ACQUIRE, GET_AND_SET, GET_AND_SET_ACQUIRE, GET_AND_SET_RELEASE, GET_AND_ADD, GET_AND_ADD_ACQUIRE, GET_AND_ADD_RELEASE, GET_AND_BITWISE_OR, GET_AND_BITWISE_OR_ACQUIRE, GET_AND_BITWISE_OR_RELEASE, GET_AND_BITWISE_AND, GET_AND_BITWISE_AND_ACQUIRE, GET_AND_BITWISE_AND_RELEASE, GET_AND_BITWISE_XOR, GET_AND_BITWISE_XOR_ACQUIRE, GET_AND_BITWISE_XOR_RELEASE, COMPARE_AND_EXCHANGE, COMPARE_AND_EXCHANGE_ACQUIRE, COMPARE_AND_EXCHANGE_RELEASE});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaLangReflectVarHandleInvocationChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVarHandleAccess";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVarHandleAccessSignature";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getVarHandleArgumentCount";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isWithReturnValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

