/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.codeInspection.duplicateExpressions.NoSideEffectExpressionEquivalenceChecker;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExpressionHashingStrategy
implements TObjectHashingStrategy<PsiExpression> {
    private static final EquivalenceChecker EQUIVALENCE_CHECKER = new NoSideEffectExpressionEquivalenceChecker();

    ExpressionHashingStrategy() {
    }

    public boolean equals(PsiExpression e1, PsiExpression e2) {
        return EQUIVALENCE_CHECKER.expressionsAreEquivalent(e1, e2);
    }

    public int computeHashCode(PsiExpression e) {
        if (e == null) {
            return 0;
        }
        if (e instanceof PsiParenthesizedExpression) {
            return this.computeHashCode(((PsiParenthesizedExpression)e).getExpression());
        }
        if (e instanceof PsiUnaryExpression) {
            PsiUnaryExpression unary = (PsiUnaryExpression)e;
            return this.computeHashCode(unary.getOperationTokenType(), unary.getOperand());
        }
        if (e instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)e;
            return this.computeHashCode(polyadic.getOperationTokenType(), polyadic.getOperands());
        }
        if (e instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)e;
            return this.computeHashCode(JavaTokenType.QUEST, conditional.getCondition(), conditional.getThenExpression(), conditional.getElseExpression());
        }
        if (e instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)e;
            PsiReferenceExpression ref = call.getMethodExpression();
            return this.computeHashCode(ref.getReferenceName(), ref.getQualifierExpression(), call.getArgumentList().getExpressions());
        }
        if (e instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)e;
            return this.computeHashCode(ref.getReferenceName(), ref.getQualifierExpression(), new PsiExpression[0]);
        }
        if (e instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)e;
            return this.computeHashCode(ExpressionHashingStrategy.getTypeName(instanceOf.getCheckType()), instanceOf.getOperand(), new PsiExpression[0]);
        }
        if (e instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression access = (PsiArrayAccessExpression)e;
            return this.computeHashCode(JavaTokenType.LBRACKET, access.getArrayExpression(), access.getIndexExpression());
        }
        if (e instanceof PsiClassObjectAccessExpression) {
            String name = ExpressionHashingStrategy.getTypeName(((PsiClassObjectAccessExpression)e).getOperand());
            return name != null ? name.hashCode() : 0;
        }
        if (e instanceof PsiLambdaExpression) {
            PsiExpression bodyExpr = LambdaUtil.extractSingleExpressionFromBody((PsiElement)((PsiLambdaExpression)e).getBody());
            return this.computeHashCode(JavaTokenType.ARROW, bodyExpr) * 31 + ((PsiLambdaExpression)e).getParameterList().getParametersCount();
        }
        if (e instanceof PsiLiteralExpression) {
            Object value2 = ((PsiLiteralExpression)e).getValue();
            return value2 != null ? value2.hashCode() : 0;
        }
        return 0;
    }

    private int computeHashCode(@NotNull IElementType tokenType, PsiExpression ... operands2) {
        if (tokenType == null) {
            ExpressionHashingStrategy.$$$reportNull$$$0(0);
        }
        if (operands2 == null) {
            ExpressionHashingStrategy.$$$reportNull$$$0(1);
        }
        int hash = tokenType.hashCode();
        for (PsiExpression operand2 : operands2) {
            hash = hash * 31 + this.computeHashCode(operand2);
        }
        return hash;
    }

    private int computeHashCode(@Nullable String name, @Nullable PsiExpression expression2, PsiExpression ... operands2) {
        if (operands2 == null) {
            ExpressionHashingStrategy.$$$reportNull$$$0(2);
        }
        int hash = name != null ? name.hashCode() : 0;
        hash = hash * 31 + this.computeHashCode(expression2);
        for (PsiExpression operand2 : operands2) {
            hash = hash * 31 + this.computeHashCode(operand2);
        }
        return hash;
    }

    @Contract(value="null -> null")
    private static String getTypeName(@Nullable PsiTypeElement element) {
        PsiJavaCodeReferenceElement reference;
        if (element != null && (reference = element.getInnermostComponentReferenceElement()) != null) {
            return reference.getReferenceName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tokenType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "operands";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/duplicateExpressions/ExpressionHashingStrategy";
        objectArray[2] = "computeHashCode";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

