/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageVisitorBase;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecationElementVisitor
extends ApiUsageVisitorBase {
    private final ProblemsHolder myHolder;
    private final boolean myIgnoreInsideDeprecated;
    private final boolean myIgnoreAbstractDeprecatedOverrides;
    private final boolean myIgnoreImportStatements;
    private final boolean myIgnoreMethodsOfDeprecated;
    private final boolean myIgnoreInSameOutermostClass;
    private final boolean myForRemoval;
    private final ProblemHighlightType myHighlightType;

    DeprecationElementVisitor(@NotNull ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, boolean forRemoval, @Nullable HighlightSeverity severity) {
        if (holder == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
        this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
        this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
        this.myIgnoreImportStatements = ignoreImportStatements;
        this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
        this.myIgnoreInSameOutermostClass = ignoreInSameOutermostClass;
        this.myForRemoval = forRemoval;
        this.myHighlightType = forRemoval && severity == HighlightSeverity.ERROR ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
    }

    @Override
    public void processReference(@NotNull PsiReference reference) {
        if (reference == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(1);
        }
        if (reference instanceof ResolvingHint && !((ResolvingHint)reference).canResolveTo(PsiModifierListOwner.class)) {
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved != null) {
            PsiElement elementToHighlight = DeprecationElementVisitor.getElementToHighlight(reference);
            DeprecationInspectionBase.checkDeprecated(resolved, elementToHighlight, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
        }
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiReference reference) {
        PsiElement referenceNameElement2;
        if (reference == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(2);
        }
        if (reference instanceof PsiJavaCodeReferenceElement && (referenceNameElement2 = ((PsiJavaCodeReferenceElement)reference).getReferenceNameElement()) != null) {
            PsiElement psiElement = referenceNameElement2;
            if (psiElement == null) {
                DeprecationElementVisitor.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        PsiElement psiElement = reference.getElement();
        if (psiElement == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Override
    public void processConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass, @NotNull PsiMethod constructor) {
        if (instantiatedClass == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(5);
        }
        if (constructor == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(6);
        }
        DeprecationInspectionBase.checkDeprecated((PsiElement)constructor, (PsiElement)instantiatedClass, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, true, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
    }

    @Override
    public void processDefaultConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass) {
        PsiElement createdClass;
        if (instantiatedClass == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(7);
        }
        if ((createdClass = instantiatedClass.resolve()) instanceof PsiClass && DeprecationElementVisitor.hasEmptyDeprecatedConstructor((PsiClass)createdClass, this.myForRemoval)) {
            this.registerDefaultConstructorProblem((PsiClass)createdClass, (PsiElement)instantiatedClass);
        }
    }

    @Override
    public void processMethodOverriding(@NotNull PsiMethod method, @NotNull PsiMethod overriddenMethod) {
        PsiClass aClass;
        if (method == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(8);
        }
        if (overriddenMethod == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(9);
        }
        if ((aClass = overriddenMethod.getContainingClass()) == null) {
            return;
        }
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        if (this.myIgnoreAbstractDeprecatedOverrides && !aClass.isDeprecated() && overriddenMethod.hasModifierProperty("abstract")) {
            return;
        }
        if (overriddenMethod.isDeprecated() && this.myForRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)overriddenMethod)) {
            String description = JavaErrorMessages.message(this.myForRemoval ? "overrides.marked.for.removal.method" : "overrides.deprecated.method", DeprecationInspectionBase.getPresentableName((PsiElement)aClass));
            this.myHolder.registerProblem((PsiElement)nameIdentifier, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
        }
    }

    @Override
    public void processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassConstructor(@NotNull PsiClass superClass, @NotNull PsiMethod subclassConstructor) {
        PsiIdentifier nameIdentifier;
        if (superClass == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(10);
        }
        if (subclassConstructor == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(11);
        }
        if (DeprecationElementVisitor.hasEmptyDeprecatedConstructor(superClass, this.myForRemoval) && (nameIdentifier = subclassConstructor.getNameIdentifier()) != null) {
            this.registerDefaultConstructorProblem(superClass, (PsiElement)nameIdentifier);
        }
    }

    @Override
    public void processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassDeclaration(@NotNull PsiClass subclass, @NotNull PsiClass superClass) {
        if (subclass == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(12);
        }
        if (superClass == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(13);
        }
        if (DeprecationElementVisitor.hasEmptyDeprecatedConstructor(superClass, this.myForRemoval)) {
            PsiIdentifier elementToHighlight;
            PsiExpressionList argumentList;
            boolean isAnonymous = subclass instanceof PsiAnonymousClass;
            if (isAnonymous && (argumentList = ((PsiAnonymousClass)subclass).getArgumentList()) != null && !argumentList.isEmpty()) {
                return;
            }
            Object object = elementToHighlight = isAnonymous ? ((PsiAnonymousClass)subclass).getBaseClassReference() : subclass.getNameIdentifier();
            if (elementToHighlight != null) {
                this.registerDefaultConstructorProblem(superClass, (PsiElement)elementToHighlight);
            }
        }
    }

    private static boolean hasEmptyDeprecatedConstructor(@NotNull PsiClass aClass, boolean forRemoval) {
        PsiMethod[] constructors;
        if (aClass == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(14);
        }
        if ((constructors = aClass.getConstructors()).length == 0) {
            List externalDeprecated = ExternalAnnotationsManager.getInstance((Project)aClass.getProject()).findDefaultConstructorExternalAnnotations(aClass, "java.lang.Deprecated");
            return externalDeprecated != null && !externalDeprecated.isEmpty() && ContainerUtil.exists((Iterable)externalDeprecated, annotation -> DeprecationInspectionBase.isForRemovalAttributeSet(annotation) == forRemoval);
        }
        return Arrays.stream(constructors).anyMatch(constructor -> constructor.getParameterList().isEmpty() && constructor.isDeprecated() && forRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)constructor));
    }

    private void registerDefaultConstructorProblem(@NotNull PsiClass constructorOwner, @NotNull PsiElement elementToHighlight) {
        if (constructorOwner == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(15);
        }
        if (elementToHighlight == null) {
            DeprecationElementVisitor.$$$reportNull$$$0(16);
        }
        String description = JavaErrorMessages.message(this.myForRemoval ? "marked.for.removal.default.constructor" : "deprecated.default.constructor", constructorOwner.getQualifiedName());
        this.myHolder.registerProblem(elementToHighlight, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deprecation/DeprecationElementVisitor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiatedClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenMethod";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subclassConstructor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subclass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorOwner";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deprecation/DeprecationElementVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processConstructorInvocation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultConstructorInvocation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processMethodOverriding";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassConstructor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassDeclaration";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasEmptyDeprecatedConstructor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerDefaultConstructorProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

