/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DeleteSwitchLabelFix
implements LocalQuickFix {
    private final String myName;
    private final boolean myBranch;

    public DeleteSwitchLabelFix(@NotNull PsiExpression label) {
        if (label == null) {
            DeleteSwitchLabelFix.$$$reportNull$$$0(0);
        }
        this.myName = label.getText();
        PsiSwitchLabelStatementBase labelStatement = Objects.requireNonNull(PsiImplUtil.getSwitchLabel(label));
        PsiExpressionList values = labelStatement.getCaseValues();
        boolean multiple = values != null && values.getExpressionCount() > 1;
        this.myBranch = !multiple && DeleteSwitchLabelFix.shouldRemoveBranch(labelStatement);
    }

    private static boolean shouldRemoveBranch(PsiSwitchLabelStatementBase label) {
        if (label instanceof PsiSwitchLabeledRuleStatement) {
            return true;
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiStatement.class);
        if (nextStatement instanceof PsiSwitchLabelStatement) {
            return false;
        }
        PsiStatement prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)label, PsiStatement.class);
        return prevStatement == null || !ControlFlowUtils.statementMayCompleteNormally(prevStatement);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.myBranch ? "Remove switch branch '" + this.myName + "'" : "Remove switch label '" + this.myName + "'";
        if (string == null) {
            DeleteSwitchLabelFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Remove switch label" == null) {
            DeleteSwitchLabelFix.$$$reportNull$$$0(2);
        }
        return "Remove switch label";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression expression2;
        if (project == null) {
            DeleteSwitchLabelFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            DeleteSwitchLabelFix.$$$reportNull$$$0(4);
        }
        if ((expression2 = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class)) == null) {
            return;
        }
        PsiSwitchLabelStatementBase label = PsiImplUtil.getSwitchLabel(expression2);
        if (label == null) {
            return;
        }
        PsiExpressionList values = label.getCaseValues();
        if (values != null && values.getExpressionCount() == 1) {
            DeleteSwitchLabelFix.deleteLabel(label);
        } else {
            new CommentTracker().deleteAndRestoreComments((PsiElement)expression2);
        }
    }

    public static void deleteLabel(PsiSwitchLabelStatementBase label) {
        if (DeleteSwitchLabelFix.shouldRemoveBranch(label)) {
            PsiStatement next;
            PsiSwitchLabelStatementBase stopAt;
            PsiCodeBlock scope = (PsiCodeBlock)ObjectUtils.tryCast((Object)label.getParent(), PsiCodeBlock.class);
            if (scope == null) {
                return;
            }
            PsiSwitchLabelStatementBase nextLabel = (PsiSwitchLabelStatementBase)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiSwitchLabelStatementBase.class);
            Object object = stopAt = nextLabel == null ? scope.getRBrace() : nextLabel;
            while ((next = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextLabel, PsiStatement.class)) instanceof PsiSwitchLabelStatement) {
                nextLabel = (PsiSwitchLabelStatement)next;
            }
            int end = nextLabel == null ? -1 : nextLabel.getTextOffset();
            ArrayList<PsiElement> toDelete = new ArrayList<PsiElement>();
            ArrayList<PsiDeclarationStatement> declarations = new ArrayList<PsiDeclarationStatement>();
            for (PsiElement e = label.getNextSibling(); e != stopAt; e = e.getNextSibling()) {
                PsiDeclarationStatement declaration2;
                Object[] elements;
                boolean declarationIsReused;
                if (e instanceof PsiDeclarationStatement && nextLabel != null && (declarationIsReused = Stream.of(elements = (declaration2 = (PsiDeclarationStatement)e).getDeclaredElements()).anyMatch(element -> ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)scope)).anyMatch(ref -> ref.getElement().getTextOffset() > end)))) {
                    StreamEx.of((Object[])elements).select(PsiVariable.class).map(PsiVariable::getInitializer).nonNull().into(toDelete);
                    declarations.add(declaration2);
                    continue;
                }
                toDelete.add(e);
            }
            CommentTracker ct = new CommentTracker();
            toDelete.stream().filter(PsiElement::isValid).forEach(ct::delete);
            for (PsiDeclarationStatement declaration3 : declarations) {
                scope.addAfter((PsiElement)declaration3, (PsiElement)nextLabel);
                declaration3.delete();
            }
            ct.insertCommentsBefore((PsiElement)label);
        }
        new CommentTracker().deleteAndRestoreComments((PsiElement)label);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/DeleteSwitchLabelFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/DeleteSwitchLabelFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

