/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.SortedIntSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EqClass
extends SortedIntSet {
    private final DfaValueFactory myFactory;
    static final Comparator<DfaVariableValue> CANONICAL_VARIABLE_COMPARATOR = Comparator.nullsFirst((v1, v2) -> {
        int result = CANONICAL_VARIABLE_COMPARATOR.compare(v1.getQualifier(), v2.getQualifier());
        if (result != 0) {
            return result;
        }
        return Integer.compare(v1.getID(), v2.getID());
    });

    EqClass(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    EqClass(@NotNull EqClass toCopy) {
        if (toCopy == null) {
            EqClass.$$$reportNull$$$0(0);
        }
        super(toCopy.toNativeArray());
        this.myFactory = toCopy.myFactory;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            int value2 = this.get(i);
            DfaValue dfaValue = this.myFactory.getValue(value2);
            buf.append(dfaValue);
        }
        buf.append(")");
        return buf.toString();
    }

    List<DfaVariableValue> getVariables(boolean unwrap) {
        ArrayList vars = ContainerUtil.newArrayList();
        this.forEach(id -> {
            DfaValue value2 = this.myFactory.getValue(id);
            if (value2 instanceof DfaVariableValue) {
                vars.add((DfaVariableValue)value2);
            } else if (unwrap && value2 instanceof DfaBoxedValue) {
                vars.add(((DfaBoxedValue)value2).getWrappedValue());
            }
            return true;
        });
        return vars;
    }

    @Nullable
    DfaVariableValue getCanonicalVariable() {
        if (this.size() == 1) {
            return (DfaVariableValue)ObjectUtils.tryCast((Object)this.myFactory.getValue(this.get(0)), DfaVariableValue.class);
        }
        return IntStreamEx.range((int)this.size()).mapToObj(idx -> this.myFactory.getValue(this.get(idx))).select(DfaVariableValue.class).min(CANONICAL_VARIABLE_COMPARATOR).orElse(null);
    }

    List<DfaValue> getMemberValues() {
        ArrayList<DfaValue> result = new ArrayList<DfaValue>(this.size());
        this.forEach(id -> {
            DfaValue value2 = this.myFactory.getValue(id);
            result.add(value2);
            return true;
        });
        return result;
    }

    @Nullable
    DfaConstValue findConstant() {
        Ref result = new Ref();
        this.forEach(id -> {
            DfaValue value2 = this.myFactory.getValue(id);
            if (value2 instanceof DfaConstValue) {
                result.set((Object)((DfaConstValue)value2));
                return false;
            }
            return true;
        });
        return (DfaConstValue)result.get();
    }

    boolean containsConstantsOnly() {
        int size = this.size();
        return size <= 1 && (size == 0 || this.myFactory.getValue(this.get(0)) instanceof DfaConstValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCopy", "com/intellij/codeInspection/dataFlow/EqClass", "<init>"));
    }
}

