/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.SingleSourceRootMoveDestination;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MoveToPackageFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.MoveToPackageFix");
    private final String myTargetPackage;

    public MoveToPackageFix(String targetPackage) {
        this.myTargetPackage = targetPackage;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("move.class.to.package.text", this.myTargetPackage);
        if (string == null) {
            MoveToPackageFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.to.package.family", new Object[0]);
        if (string == null) {
            MoveToPackageFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(PsiFile myFile) {
        return myFile != null && myFile.isValid() && myFile.getManager().isInProject((PsiElement)myFile) && myFile instanceof PsiJavaFile && ((PsiJavaFile)myFile).getClasses().length != 0 && this.myTargetPackage != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            MoveToPackageFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            MoveToPackageFix.$$$reportNull$$$0(3);
        }
        if ((element = descriptor.getPsiElement()) == null) {
            return;
        }
        PsiFile myFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(myFile)) {
            return;
        }
        try {
            String error;
            PsiDirectory directory = null;
            try {
                directory = MoveClassesOrPackagesUtil.chooseDestinationPackage(project, this.myTargetPackage, myFile.getContainingDirectory());
                if (directory == null) {
                    return;
                }
                error = RefactoringMessageUtil.checkCanCreateFile(directory, myFile.getName());
            }
            catch (IncorrectOperationException e) {
                error = e.getLocalizedMessage();
            }
            if (error != null) {
                Messages.showMessageDialog((Project)project, (String)error, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            new MoveClassesOrPackagesProcessor(project, (PsiElement[])((PsiJavaFile)myFile).getClasses(), new SingleSourceRootMoveDestination(PackageWrapper.create((PsiPackage)JavaDirectoryService.getInstance().getPackage(directory)), directory), false, false, null).run();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/MoveToPackageFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/MoveToPackageFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

