/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.apiUsage.ApiUsageVisitorBase;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastContextKt;

public abstract class AnnotatedElementVisitorBase
extends ApiUsageVisitorBase {
    private final boolean myIgnoreInsideImports;
    private final List<String> myAnnotations;

    public AnnotatedElementVisitorBase(boolean ignoreInsideImports, @NotNull List<String> annotations2) {
        if (annotations2 == null) {
            AnnotatedElementVisitorBase.$$$reportNull$$$0(0);
        }
        this.myIgnoreInsideImports = ignoreInsideImports;
        this.myAnnotations = annotations2;
    }

    public abstract void processAnnotatedTarget(@NotNull PsiReference var1, @NotNull PsiModifierListOwner var2, @NotNull List<PsiAnnotation> var3);

    @Override
    public boolean shouldProcessReferences(@NotNull PsiElement element) {
        if (element == null) {
            AnnotatedElementVisitorBase.$$$reportNull$$$0(1);
        }
        return !this.myIgnoreInsideImports || !AnnotatedElementVisitorBase.isInsideImportStatement(element);
    }

    private static boolean isInsideImportStatement(@NotNull PsiElement element) {
        if (element == null) {
            AnnotatedElementVisitorBase.$$$reportNull$$$0(2);
        }
        return UastContextKt.getUastParentOfType((PsiElement)element, UImportStatement.class) != null;
    }

    @Override
    public void processReference(@NotNull PsiReference reference) {
        List annotations2;
        PsiModifierListOwner annotationsOwner;
        if (reference == null) {
            AnnotatedElementVisitorBase.$$$reportNull$$$0(3);
        }
        if ((annotationsOwner = AnnotatedElementVisitorBase.resolveModifierListOwner(reference)) != null && !(annotations2 = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)annotationsOwner, this.myAnnotations, (boolean)false)).isEmpty()) {
            this.processAnnotatedTarget(reference, annotationsOwner, annotations2);
        }
    }

    @Override
    public void processConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass, @NotNull PsiMethod constructor) {
        List annotations2;
        if (instantiatedClass == null) {
            AnnotatedElementVisitorBase.$$$reportNull$$$0(4);
        }
        if (constructor == null) {
            AnnotatedElementVisitorBase.$$$reportNull$$$0(5);
        }
        if (!(annotations2 = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)constructor, this.myAnnotations, (boolean)false)).isEmpty()) {
            this.processAnnotatedTarget((PsiReference)instantiatedClass, (PsiModifierListOwner)constructor, annotations2);
        }
    }

    @Nullable
    private static PsiModifierListOwner resolveModifierListOwner(@NotNull PsiReference reference) {
        if (reference == null) {
            AnnotatedElementVisitorBase.$$$reportNull$$$0(6);
        }
        if (reference instanceof ResolvingHint && !((ResolvingHint)reference).canResolveTo(PsiModifierListOwner.class)) {
            return null;
        }
        PsiElement resolvedElement = reference.resolve();
        if (resolvedElement instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)resolvedElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiatedClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/AnnotatedElementVisitorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcessReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideImportStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processConstructorInvocation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveModifierListOwner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

