/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefineParamsDefaultValueAction
extends PsiElementBaseIntentionAction
implements Iconable,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(DefineParamsDefaultValueAction.class);

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Generate overloaded method with default parameter values" == null) {
            DefineParamsDefaultValueAction.$$$reportNull$$$0(0);
        }
        return "Generate overloaded method with default parameter values";
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.RefactoringBulb;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            DefineParamsDefaultValueAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            DefineParamsDefaultValueAction.$$$reportNull$$$0(2);
        }
        if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiCodeBlock.class});
        if (!(parent instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)parent;
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.isEmpty()) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || containingClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)method)) {
            return false;
        }
        this.setText("Generate overloaded " + (method.isConstructor() ? "constructor" : "method") + " with default parameter values");
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiParameter[] parameters2;
        if (project == null) {
            DefineParamsDefaultValueAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DefineParamsDefaultValueAction.$$$reportNull$$$0(4);
        }
        if ((parameters2 = this.getParams(element)) == null || parameters2.length == 0) {
            return;
        }
        PsiMethod method = (PsiMethod)parameters2[0].getDeclarationScope();
        PsiMethod methodPrototype = DefineParamsDefaultValueAction.generateMethodPrototype(method, parameters2);
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiMethod existingMethod = containingClass.findMethodBySignature(methodPrototype, false);
        if (existingMethod != null) {
            editor.getCaretModel().moveToOffset(existingMethod.getTextOffset());
            HintManager.getInstance().showErrorHint(editor, (existingMethod.isConstructor() ? "Constructor" : "Method") + " with the chosen signature already exists");
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        Runnable runnable = () -> {
            PsiMethod prototype = (PsiMethod)containingClass.addBefore((PsiElement)methodPrototype, (PsiElement)method);
            RefactoringUtil.fixJavadocsForParams(prototype, new HashSet<PsiParameter>(Arrays.asList(prototype.getParameterList().getParameters())));
            PsiCodeBlock body2 = prototype.getBody();
            String callArgs = "(" + StringUtil.join((Object[])method.getParameterList().getParameters(), psiParameter -> {
                if (ArrayUtil.find((Object[])parameters2, (Object)psiParameter) > -1) {
                    return "IntelliJIDEARulezzz";
                }
                return psiParameter.getName();
            }, (String)",") + ");";
            String methodCall = method.getReturnType() == null ? "this" : (!PsiType.VOID.equals((Object)method.getReturnType()) ? "return " + method.getName() : method.getName());
            LOG.assertTrue(body2 != null);
            body2.add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(methodCall + callArgs, (PsiElement)method));
            body2 = (PsiCodeBlock)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)body2);
            PsiStatement stmt = body2.getStatements()[0];
            Object expr = stmt instanceof PsiReturnStatement ? ((PsiReturnStatement)stmt).getReturnValue() : (stmt instanceof PsiExpressionStatement ? ((PsiExpressionStatement)stmt).getExpression() : null);
            if (expr instanceof PsiMethodCallExpression) {
                PsiExpression[] args = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions();
                PsiExpression[] toDefaults = (PsiExpression[])ContainerUtil.map2Array((Object[])parameters2, PsiExpression.class, parameter2 -> args[method.getParameterList().getParameterIndex(parameter2)]);
                DefineParamsDefaultValueAction.startTemplate(project, editor, toDefaults, prototype);
            }
        };
        if (this.startInWriteAction()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
    }

    public static void startTemplate(@NotNull Project project, Editor editor, PsiExpression[] argsToBeDelegated, PsiMethod delegateMethod) {
        if (project == null) {
            DefineParamsDefaultValueAction.$$$reportNull$$$0(5);
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)delegateMethod);
        RangeMarker rangeMarker = editor.getDocument().createRangeMarker(delegateMethod.getTextRange());
        for (PsiExpression exprToBeDefault : argsToBeDelegated) {
            builder.replaceElement((PsiElement)exprToBeDefault, (Expression)new TextExpression(""));
        }
        Template template = builder.buildTemplate();
        editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        rangeMarker.dispose();
        CreateFromUsageBaseFix.startTemplate(editor, template, project);
    }

    @Nullable
    protected PsiParameter[] getParams(PsiElement element) {
        List elements;
        int idx;
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        assert (method != null);
        Object[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length == 1) {
            return parameters2;
        }
        ClassMember[] members = new ParameterClassMember[parameters2.length];
        for (int i = 0; i < members.length; ++i) {
            members[i] = new ParameterClassMember(parameters2[i]);
        }
        PsiParameter selectedParam = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        int n = idx = selectedParam != null ? ArrayUtil.find((Object[])parameters2, (Object)selectedParam) : -1;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiParameter[] psiParameterArray;
            if (idx >= 0) {
                PsiParameter[] psiParameterArray2 = new PsiParameter[1];
                psiParameterArray = psiParameterArray2;
                psiParameterArray2[0] = selectedParam;
            } else {
                psiParameterArray = null;
            }
            return psiParameterArray;
        }
        MemberChooser chooser = new MemberChooser(members, false, true, element.getProject());
        if (idx >= 0) {
            chooser.selectElements(new ClassMember[]{members[idx]});
        } else {
            chooser.selectElements(members);
        }
        chooser.setTitle("Choose Default Value Parameters");
        chooser.setCopyJavadocVisible(false);
        if (chooser.showAndGet() && (elements = chooser.getSelectedElements()) != null) {
            PsiParameter[] params = new PsiParameter[elements.size()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = ((ParameterClassMember)elements.get(i)).getParameter();
            }
            return params;
        }
        return null;
    }

    private static PsiMethod generateMethodPrototype(PsiMethod method, PsiParameter ... params) {
        PsiMethod prototype = (PsiMethod)method.copy();
        PsiCodeBlock body2 = prototype.getBody();
        PsiCodeBlock emptyBody = JavaPsiFacade.getElementFactory((Project)method.getProject()).createMethodFromText("void foo(){}", (PsiElement)prototype).getBody();
        assert (emptyBody != null);
        if (body2 != null) {
            body2.replace((PsiElement)emptyBody);
        } else {
            prototype.getModifierList().setModifierProperty("abstract", false);
            prototype.addBefore((PsiElement)emptyBody, null);
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && aClass.isInterface() && !method.hasModifierProperty("static")) {
            prototype.getModifierList().setModifierProperty("default", true);
        }
        PsiParameterList parameterList = method.getParameterList();
        Arrays.sort(params, (p1, p2) -> {
            int parameterIndex2;
            int parameterIndex1 = parameterList.getParameterIndex(p1);
            return parameterIndex1 > (parameterIndex2 = parameterList.getParameterIndex(p2)) ? -1 : 1;
        });
        for (PsiParameter param : params) {
            int parameterIndex = parameterList.getParameterIndex(param);
            prototype.getParameterList().getParameters()[parameterIndex].delete();
        }
        return prototype;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

