/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressAllForClassFix
extends SuppressFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.actions.AddNoInspectionAllForClassFix");

    public SuppressAllForClassFix() {
        super("ALL");
    }

    @Override
    @Nullable
    public PsiJavaDocumentedElement getContainer(PsiElement element) {
        PsiJavaDocumentedElement container = super.getContainer(element);
        if (container == null) {
            return null;
        }
        while (container != null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)container, PsiClass.class);
            if (parentClass == null && container instanceof PsiClass) {
                return container;
            }
            container = parentClass;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SuppressAllForClassFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.all.for.class", (Object[])new Object[0]);
        if (string == null) {
            SuppressAllForClassFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaDocumentedElement container;
        if (project == null) {
            SuppressAllForClassFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SuppressAllForClassFix.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((container = this.getContainer(element)) != null);
        if (container instanceof PsiModifierListOwner && this.use15Suppressions(container)) {
            PsiAnnotation annotation;
            PsiModifierList modifierList = ((PsiModifierListOwner)container).getModifierList();
            if (modifierList != null && (annotation = modifierList.findAnnotation("java.lang.SuppressWarnings")) != null) {
                String annoText = "@java.lang.SuppressWarnings(\"ALL\")";
                Runnable runnable = () -> annotation.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(annoText, (PsiElement)container));
                WriteCommandAction.runWriteCommandAction((Project)project, null, null, (Runnable)runnable, (PsiFile[])new PsiFile[]{annotation.getContainingFile()});
                return;
            }
        } else {
            PsiDocTag noInspectionTag;
            PsiDocComment docComment = container.getDocComment();
            if (docComment != null && (noInspectionTag = docComment.findTagByName("noinspection")) != null) {
                String tagText = "@noinspection ALL";
                Runnable runnable = () -> noInspectionTag.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText(tagText));
                WriteCommandAction.runWriteCommandAction((Project)project, null, null, (Runnable)runnable, (PsiFile[])new PsiFile[]{noInspectionTag.getContainingFile()});
                return;
            }
        }
        super.invoke(project, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

