/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ProjectIconsAccessor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.values.UCallResultValue;
import org.jetbrains.uast.values.UConstant;
import org.jetbrains.uast.values.UStringConstant;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.values.UValueKt;

public class IconLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        UIdentifier identifier;
        Collection constants;
        List psiElements;
        List arguments;
        UCallExpression expression2;
        if (element == null) {
            IconLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((expression2 = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class)) == null) {
            return null;
        }
        if (!ProjectIconsAccessor.isIconClassType(expression2.getExpressionType())) {
            return null;
        }
        UValue uValue = UEvaluationContextKt.uValueOf((UExpression)expression2);
        if (uValue instanceof UCallResultValue && (arguments = ((UCallResultValue)uValue).getArguments()).size() > 0 && (psiElements = UastUtils.toPsiElements((Collection)(constants = (Collection)UValueKt.toPossibleConstants((UValue)((UValue)arguments.get(0))).stream().filter(constant -> constant instanceof UStringConstant).map(UConstant::getSource).collect(Collectors.toList())))).size() > 0 && (identifier = expression2.getMethodIdentifier()) != null) {
            return IconLineMarkerProvider.createIconLineMarker((PsiElement)psiElements.get(0), identifier.getPsi());
        }
        return null;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createIconLineMarker(@Nullable PsiElement initializer, PsiElement bindingElement) {
        if (initializer == null) {
            return null;
        }
        Project project = initializer.getProject();
        VirtualFile file = ProjectIconsAccessor.getInstance(project).resolveIconFile(initializer);
        if (file == null) {
            return null;
        }
        Icon icon = ProjectIconsAccessor.getInstance(project).getIcon(file);
        if (icon == null) {
            return null;
        }
        GutterIconNavigationHandler navHandler = (e, elt) -> FileEditorManager.getInstance((Project)project).openFile(file, true);
        return new LineMarkerInfo(bindingElement, bindingElement.getTextRange(), icon, 11, null, navHandler, GutterIconRenderer.Alignment.LEFT);
    }

    @NotNull
    public String getName() {
        if ("Icon preview" == null) {
            IconLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return "Icon preview";
    }

    public boolean isEnabledByDefault() {
        return DaemonCodeAnalyzerSettings.getInstance().isShowSmallIconsInGutter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IconLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

