/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.rt.execution.testFrameworks.ForkedByModuleSplitter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ForkedSplitter
extends ForkedByModuleSplitter {
    private Object myRootDescription;

    public ForkedSplitter(String workingDirsPath, String forkMode, List newArgs) {
        super(workingDirsPath, forkMode, newArgs);
    }

    protected int startSplitting(String[] args, String configName, String repeatCount) throws Exception {
        this.myRootDescription = this.createRootDescription(args, configName);
        if (this.myRootDescription == null) {
            return -1;
        }
        if (this.myWorkingDirsPath == null || new File(this.myWorkingDirsPath).length() == 0L) {
            String classpath = System.getProperty("java.class.path");
            if (repeatCount != null && RepeatCount.getCount(repeatCount) != 0 && this.myForkMode.equals("repeat")) {
                return this.startChildFork(this.createChildArgs(this.myRootDescription), null, classpath, repeatCount);
            }
            List children = this.getChildren(this.myRootDescription);
            boolean forkTillMethod = this.myForkMode.equalsIgnoreCase("method");
            return this.splitChildren(children, 0, forkTillMethod, null, classpath, repeatCount);
        }
        return this.splitPerModule(repeatCount);
    }

    protected int startPerModuleFork(String moduleName, List classNames, String packageName, String workingDir, String classpath, String repeatCount, int result, String filters) throws Exception {
        if (this.myForkMode.equals("none")) {
            List childArgs = this.createPerModuleArgs(packageName, workingDir, classNames, this.myRootDescription, filters);
            return this.startChildFork(childArgs, new File(workingDir), classpath, repeatCount);
        }
        ArrayList children = new ArrayList(this.getChildren(this.myRootDescription));
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            if (classNames.contains(this.getTestClassName(iterator.next()))) continue;
            iterator.remove();
        }
        boolean forkTillMethod = this.myForkMode.equalsIgnoreCase("method");
        return this.splitChildren(children, result, forkTillMethod, new File(workingDir), classpath, repeatCount);
    }

    protected int splitChildren(List children, int result, boolean forkTillMethod, File workingDir, String classpath, String repeatCount) throws IOException, InterruptedException {
        int argsLength = children.size();
        for (int i = 0; i < argsLength; ++i) {
            Object child = children.get(i);
            List childTests = this.getChildren(child);
            int childResult = childTests.isEmpty() || !forkTillMethod ? this.startChildFork(this.createChildArgs(child), workingDir, classpath, repeatCount) : this.splitChildren(childTests, result, forkTillMethod, workingDir, classpath, repeatCount);
            result = Math.min(childResult, result);
        }
        return result;
    }

    protected abstract List createPerModuleArgs(String var1, String var2, List var3, Object var4, String var5) throws IOException;

    protected abstract Object createRootDescription(String[] var1, String var2) throws Exception;

    protected abstract String getTestClassName(Object var1);

    protected abstract List createChildArgs(Object var1);

    protected abstract List getChildren(Object var1);
}

