/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ComponentWithFileColors;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tree
extends JTree
implements ComponentWithEmptyText,
ComponentWithExpandableItems<Integer>,
Autoscroll,
Queryable,
ComponentWithFileColors {
    private final StatusText myEmptyText;
    private final ExpandableItemsHandler<Integer> myExpandableItemsHandler;
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;
    private Rectangle myLastVisibleRec;
    private Dimension myHoldSize;
    private final MySelectionModel mySelectionModel = new MySelectionModel();
    private ThreeState myHorizontalAutoScrolling = ThreeState.UNSURE;
    private TreePath rollOverPath;
    private static final int AUTOSCROLL_MARGIN = 10;

    public Tree() {
        this(new DefaultMutableTreeNode());
    }

    public Tree(TreeNode root) {
        this(new DefaultTreeModel(root, false));
    }

    public Tree(TreeModel treemodel) {
        super(treemodel);
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return Tree.this.isEmpty();
            }
        };
        this.myExpandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point p = e.getPoint();
                    TreePath newPath = Tree.this.getPathForLocation(p.x, p.y);
                    if (newPath != null && !newPath.equals(Tree.this.rollOverPath)) {
                        TreeCellRenderer renderer = Tree.this.getCellRenderer();
                        if (newPath.getLastPathComponent() instanceof TreeNode) {
                            JComponent c;
                            TreeNode node = (TreeNode)newPath.getLastPathComponent();
                            c.putClientProperty("JCheckBox.rollOver.rectangle", (c = (JComponent)renderer.getTreeCellRendererComponent(Tree.this, node, Tree.this.isPathSelected(newPath), Tree.this.isExpanded(newPath), Tree.this.getModel().isLeaf(node), Tree.this.getRowForPath(newPath), Tree.this.hasFocus())) instanceof JCheckBox ? Tree.this.getPathBounds(newPath) : node);
                            Tree.this.rollOverPath = newPath;
                            UIUtil.repaintViewport((JComponent)Tree.this);
                        }
                    }
                }
            });
        }
        this.addMouseListener(new MyMouseListener());
        this.addFocusListener(new MyFocusListener());
        this.setCellRenderer(new NodeRenderer());
        this.setSelectionModel(this.mySelectionModel);
        this.setOpaque(false);
    }

    @Override
    public void setUI(TreeUI ui) {
        TreeUI actualUI = ui;
        if (!this.isCustomUI() && !(ui instanceof WideSelectionTreeUI) && this.isWideSelection()) {
            actualUI = new WideSelectionTreeUI(this.isWideSelection(), this.getWideSelectionBackgroundCondition());
        }
        super.setUI(actualUI);
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    public boolean isEmpty() {
        int childCount;
        TreeModel model = this.getModel();
        if (model == null) {
            return true;
        }
        if (model.getRoot() == null) {
            return true;
        }
        return !this.isRootVisible() && (childCount = model.getChildCount(model.getRoot())) == 0;
    }

    protected boolean isCustomUI() {
        return false;
    }

    protected boolean isWideSelection() {
        return true;
    }

    @NotNull
    protected Condition<Integer> getWideSelectionBackgroundCondition() {
        Condition condition = Conditions.alwaysTrue();
        if (condition == null) {
            Tree.$$$reportNull$$$0(0);
        }
        return condition;
    }

    @Override
    public boolean isFileColorsEnabled() {
        return false;
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            Tree.$$$reportNull$$$0(1);
        }
        return statusText;
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<Integer> getExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = this.myExpandableItemsHandler;
        if (expandableItemsHandler == null) {
            Tree.$$$reportNull$$$0(2);
        }
        return expandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public Color getBackground() {
        return this.isBackgroundSet() ? super.getBackground() : UIUtil.getTreeBackground();
    }

    @Override
    public Color getForeground() {
        return this.isForegroundSet() ? super.getForeground() : UIUtil.getTreeForeground();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("font", null, null);
        this.updateBusy();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.updateBusyIconLocation();
    }

    private void updateBusyIconLocation() {
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Rectangle visible = this.getVisibleRect();
        boolean canHoldSelection = false;
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths != null) {
            for (TreePath each : paths) {
                Rectangle selection = this.getPathBounds(each);
                if (selection == null || !g.getClipBounds().intersects(selection) && !g.getClipBounds().contains(selection)) continue;
                if (this.myBusy && this.myBusyIcon != null) {
                    Rectangle busyIconBounds = this.myBusyIcon.getBounds();
                    if (selection.contains(busyIconBounds) || selection.intersects(busyIconBounds)) {
                        canHoldSelection = false;
                        break;
                    }
                    canHoldSelection = true;
                    continue;
                }
                canHoldSelection = true;
            }
        }
        if (canHoldSelection && !AbstractTreeBuilder.isToPaintSelection(this)) {
            this.mySelectionModel.holdSelection();
        }
        try {
            super.paint(g);
            if (!visible.equals(this.myLastVisibleRec)) {
                this.updateBusyIconLocation();
            }
            this.myLastVisibleRec = visible;
        }
        finally {
            this.mySelectionModel.unholdSelection();
        }
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString()).setUseMask(false);
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
            this.myBusyIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!UIUtil.isActionClick((MouseEvent)e)) {
                        return;
                    }
                    AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(Tree.this);
                    if (builder != null) {
                        builder.cancelUpdate();
                    }
                }
            });
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                if (this.shouldShowBusyIconIfNeeded()) {
                    this.myBusyIcon.resume();
                    this.myBusyIcon.setToolTipText("Update is in progress. Click to cancel");
                }
            } else {
                this.myBusyIcon.suspend();
                this.myBusyIcon.setToolTipText(null);
                SwingUtilities.invokeLater(() -> {
                    if (this.myBusyIcon != null) {
                        this.repaint();
                    }
                });
            }
            this.updateBusyIconLocation();
        }
    }

    protected boolean shouldShowBusyIconIfNeeded() {
        return this.hasFocus();
    }

    protected boolean paintNodes() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.paintNodes()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintNodeContent(g);
        }
        if (this.isFileColorsEnabled()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintFileColorGutter(g);
        }
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
    }

    protected void paintFileColorGutter(Graphics g) {
        GraphicsConfig config = new GraphicsConfig(g);
        Rectangle rect = this.getVisibleRect();
        int firstVisibleRow = this.getClosestRowForLocation(rect.x, rect.y);
        int lastVisibleRow = this.getClosestRowForLocation(rect.x, rect.y + rect.height);
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            Color color;
            TreePath path2 = this.getPathForRow(row);
            Color color2 = color = path2 == null ? null : this.getFileColorForPath(path2);
            if (color == null) continue;
            Rectangle bounds = this.getRowBounds(row);
            g.setColor(color);
            g.fillRect(0, bounds.y, this.getWidth(), bounds.height);
        }
        config.restore();
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path2) {
        Object[] pathObjects;
        Object component;
        if (path2 == null) {
            Tree.$$$reportNull$$$0(3);
        }
        if ((component = path2.getLastPathComponent()) instanceof LoadingNode && (pathObjects = path2.getPath()).length > 1) {
            component = pathObjects[pathObjects.length - 2];
        }
        return this.getFileColorFor(TreeUtil.getUserObject(component));
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        return null;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        MouseEvent e2 = e;
        if (SystemInfo.isMac) {
            e2 = MacUIUtil.fixMacContextMenuIssue((MouseEvent)e);
        }
        super.processMouseEvent(e2);
        if (e != e2 && e2.isConsumed()) {
            e.consume();
        }
    }

    protected boolean isLocationInExpandControl(@Nullable TreePath path2, int mouseX) {
        if (path2 == null) {
            return false;
        }
        Rectangle bounds = this.getRowBounds(this.getRowForPath(path2));
        return this.isLocationInExpandControl(path2, mouseX, bounds.y + bounds.height / 2);
    }

    private boolean isLocationInExpandControl(TreePath path2, int x, int y) {
        TreeUI ui = this.getUI();
        if (!(ui instanceof BasicTreeUI)) {
            return false;
        }
        try {
            Class<?> aClass = ui.getClass();
            while (BasicTreeUI.class.isAssignableFrom(aClass) && !BasicTreeUI.class.equals(aClass)) {
                aClass = aClass.getSuperclass();
            }
            Method method = ReflectionUtil.getDeclaredMethod(aClass, (String)"isLocationInExpandControl", (Class[])new Class[]{TreePath.class, Integer.TYPE, Integer.TYPE});
            if (method != null) {
                return (Boolean)method.invoke((Object)ui, path2, x, y);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    @Override
    public Insets getAutoscrollInsets() {
        return new Insets(this.getLocation().y + 10, 0, this.getParent().getHeight() - 10, this.getWidth() - 1);
    }

    @Override
    public void autoscroll(Point p) {
        int realRow = this.getClosestRowForLocation(p.x, p.y);
        if (this.getLocation().y + p.y <= 10) {
            if (realRow >= 1) {
                --realRow;
            }
        } else if (realRow < this.getRowCount() - 1) {
            ++realRow;
        }
        this.scrollRowToVisible(realRow);
    }

    protected boolean highlightSingleNode() {
        return true;
    }

    private void paintNodeContent(Graphics g) {
        if (!(this.getUI() instanceof BasicTreeUI)) {
            return;
        }
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(this);
        if (builder == null || builder.isDisposed()) {
            return;
        }
        GraphicsConfig config = new GraphicsConfig(g);
        config.setAntialiasing(true);
        AbstractTreeStructure structure = builder.getTreeStructure();
        for (int eachRow = 0; eachRow < this.getRowCount(); ++eachRow) {
            Object[] kids;
            TreePath path2 = this.getPathForRow(eachRow);
            PresentableNodeDescriptor node = Tree.toPresentableNode(path2.getLastPathComponent());
            if (node == null || !node.isContentHighlighted()) continue;
            if (this.highlightSingleNode()) {
                Rectangle rect;
                if (!node.isContentHighlighted()) continue;
                TreePath nodePath = this.getPath(node);
                Rectangle parentRect = this.getPathBounds(nodePath);
                if (this.isExpanded(nodePath)) {
                    int[] max = this.getMax(node, structure);
                    rect = new Rectangle(parentRect.x, parentRect.y, Math.max((int)parentRect.getMaxX(), max[1]) - parentRect.x - 1, Math.max((int)parentRect.getMaxY(), max[0]) - parentRect.y - 1);
                } else {
                    rect = parentRect;
                }
                if (rect == null) continue;
                Color highlightColor = node.getHighlightColor();
                g.setColor(highlightColor);
                g.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 4, 4);
                g.setColor(highlightColor.darker());
                g.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 4, 4);
                continue;
            }
            if (node.getParentDescriptor() == null || (kids = structure.getChildElements(node)).length == 0) continue;
            PresentableNodeDescriptor first = null;
            PresentableNodeDescriptor last = null;
            int lastIndex = -1;
            for (int i = 0; i < kids.length; ++i) {
                PresentableNodeDescriptor eachKid;
                Object kid = kids[i];
                if (!(kid instanceof PresentableNodeDescriptor) || !node.isHighlightableContentNode(eachKid = (PresentableNodeDescriptor)kid)) continue;
                if (first == null) {
                    first = eachKid;
                }
                last = eachKid;
                lastIndex = i;
            }
            if (first == null || last == null) continue;
            Rectangle firstBounds = this.getPathBounds(this.getPath(first));
            if (this.isExpanded(this.getPath(last))) {
                if (lastIndex + 1 < kids.length) {
                    Object child = kids[lastIndex + 1];
                    if (child instanceof PresentableNodeDescriptor) {
                        PresentableNodeDescriptor nextKid = (PresentableNodeDescriptor)child;
                        int nextRow = this.getRowForPath(this.getPath(nextKid));
                        last = Tree.toPresentableNode(this.getPathForRow(nextRow - 1).getLastPathComponent());
                    }
                } else {
                    NodeDescriptor parentNode = node.getParentDescriptor();
                    if (parentNode instanceof PresentableNodeDescriptor) {
                        PresentableNodeDescriptor ppd = (PresentableNodeDescriptor)parentNode;
                        int nodeIndex = node.getIndex();
                        if (nodeIndex + 1 < structure.getChildElements(ppd).length) {
                            PresentableNodeDescriptor nextChild = ppd.getChildToHighlightAt(nodeIndex + 1);
                            int nextRow = this.getRowForPath(this.getPath(nextChild));
                            TreePath prevPath = this.getPathForRow(nextRow - 1);
                            if (prevPath != null) {
                                last = Tree.toPresentableNode(prevPath.getLastPathComponent());
                            }
                        } else {
                            int lastRow = this.getRowForPath(this.getPath(last));
                            PresentableNodeDescriptor lastParent = last;
                            boolean lastWasFound = false;
                            for (int i = lastRow + 1; i < this.getRowCount(); ++i) {
                                PresentableNodeDescriptor eachNode = Tree.toPresentableNode(this.getPathForRow(i).getLastPathComponent());
                                if (!node.isParentOf(eachNode)) {
                                    last = lastParent;
                                    lastWasFound = true;
                                    break;
                                }
                                lastParent = eachNode;
                            }
                            if (!lastWasFound) {
                                last = Tree.toPresentableNode(this.getPathForRow(this.getRowCount() - 1).getLastPathComponent());
                            }
                        }
                    }
                }
            }
            if (last == null) continue;
            Rectangle lastBounds = this.getPathBounds(this.getPath(last));
            if (firstBounds == null || lastBounds == null) continue;
            Rectangle toPaint = new Rectangle(firstBounds.x, firstBounds.y, 0, (int)lastBounds.getMaxY() - firstBounds.y - 1);
            toPaint.width = this.getWidth() - toPaint.x - 4;
            Color highlightColor = first.getHighlightColor();
            g.setColor(highlightColor);
            g.fillRoundRect(toPaint.x, toPaint.y, toPaint.width, toPaint.height, 4, 4);
            g.setColor(highlightColor.darker());
            g.drawRoundRect(toPaint.x, toPaint.y, toPaint.width, toPaint.height, 4, 4);
        }
        config.restore();
    }

    private int[] getMax(PresentableNodeDescriptor node, AbstractTreeStructure structure) {
        Object[] children;
        int x = 0;
        int y = 0;
        for (Object child : children = structure.getChildElements(node)) {
            Rectangle r;
            TreePath childPath;
            if (!(child instanceof PresentableNodeDescriptor) || (childPath = this.getPath((PresentableNodeDescriptor)child)) == null) continue;
            if (this.isExpanded(childPath)) {
                int[] tmp = this.getMax((PresentableNodeDescriptor)child, structure);
                y = Math.max(y, tmp[0]);
                x = Math.max(x, tmp[1]);
            }
            if ((r = this.getPathBounds(childPath)) == null) continue;
            y = Math.max(y, (int)r.getMaxY());
            x = Math.max(x, (int)r.getMaxX());
        }
        return new int[]{y, x};
    }

    @Nullable
    private static PresentableNodeDescriptor toPresentableNode(Object pathComponent) {
        if (!(pathComponent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)pathComponent).getUserObject();
        if (!(userObject instanceof PresentableNodeDescriptor)) {
            return null;
        }
        return (PresentableNodeDescriptor)userObject;
    }

    public TreePath getPath(@NotNull PresentableNodeDescriptor node) {
        AbstractTreeBuilder builder;
        DefaultMutableTreeNode treeNode;
        if (node == null) {
            Tree.$$$reportNull$$$0(4);
        }
        return (treeNode = (builder = AbstractTreeBuilder.getBuilderFor(this)).getNodeForElement(node)) != null ? new TreePath(treeNode.getPath()) : new TreePath(node);
    }

    public final void setLineStyleAngled() {
        UIUtil.setLineStyleAngled((JTree)this);
    }

    @NotNull
    public <T> T[] getSelectedNodes(Class<T> nodeType, @Nullable NodeFilter<T> filter) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            Object[] objectArray = (Object[])Array.newInstance(nodeType, 0);
            if (objectArray == null) {
                Tree.$$$reportNull$$$0(5);
            }
            return objectArray;
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (TreePath path2 : paths) {
            Object last = path2.getLastPathComponent();
            if (!nodeType.isAssignableFrom(last.getClass()) || filter != null && !filter.accept(last)) continue;
            nodes.add(last);
        }
        Object[] result2 = (Object[])Array.newInstance(nodeType, nodes.size());
        nodes.toArray(result2);
        if (result2 == null) {
            Tree.$$$reportNull$$$0(6);
        }
        return result2;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        TreePath[] selection;
        if (info == null) {
            Tree.$$$reportNull$$$0(7);
        }
        if ((selection = this.getSelectionPaths()) == null) {
            return;
        }
        StringBuilder nodesText = new StringBuilder();
        for (TreePath eachPath : selection) {
            Object eachNode = eachPath.getLastPathComponent();
            Component c = this.getCellRenderer().getTreeCellRendererComponent(this, eachNode, false, false, false, this.getRowForPath(eachPath), false);
            if (c == null) continue;
            if (nodesText.length() > 0) {
                nodesText.append(";");
            }
            nodesText.append(c);
        }
        if (nodesText.length() > 0) {
            info.put("selectedNodes", nodesText.toString());
        }
    }

    public void setHoldSize(boolean hold) {
        if (hold && this.myHoldSize == null) {
            this.myHoldSize = this.getPreferredSize();
        } else if (!hold && this.myHoldSize != null) {
            this.myHoldSize = null;
            this.revalidate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.myHoldSize != null) {
            size.width = Math.max(size.width, this.myHoldSize.width);
            size.height = Math.max(size.height, this.myHoldSize.height);
        }
        return size;
    }

    public boolean isHorizontalAutoScrollingEnabled() {
        return this.myHorizontalAutoScrolling != ThreeState.UNSURE ? this.myHorizontalAutoScrolling == ThreeState.YES : Registry.is((String)"ide.tree.horizontal.default.autoscrolling", (boolean)false);
    }

    public void setHorizontalAutoScrollingEnabled(boolean enabled) {
        this.myHorizontalAutoScrolling = enabled ? ThreeState.YES : ThreeState.NO;
    }

    @Nullable
    public Component getDeepestRendererComponentAt(int x, int y) {
        TreeCellRenderer renderer;
        int row = this.getRowForLocation(x, y);
        if (row >= 0 && (renderer = this.getCellRenderer()) != null) {
            TreePath path2 = this.getPathForRow(row);
            Object node = path2.getLastPathComponent();
            Component component = renderer.getTreeCellRendererComponent(this, node, this.isRowSelected(row), this.isExpanded(row), this.getModel().isLeaf(node), row, true);
            Rectangle bounds = this.getPathBounds(path2);
            if (bounds != null) {
                component.setBounds(bounds);
                return SwingUtilities.getDeepestComponentAt(component, x - bounds.x, y - bounds.y);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeadSelectionPath(TreePath newPath) {
        TreePath oldValue = this.getLeadSelectionPath();
        AccessibleContext temp = this.accessibleContext;
        try {
            this.accessibleContext = null;
            super.setLeadSelectionPath(newPath);
        }
        finally {
            this.accessibleContext = temp;
        }
        if (this.accessibleContext instanceof AccessibleTree) {
            ((AccessibleTree)this.accessibleContext).fireActiveDescendantPropertyChange(oldValue, newPath);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTree();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/treeStructure/Tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWideSelectionBackgroundCondition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/treeStructure/Tree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileColorForPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleTree
    extends JTree.AccessibleJTree {
        protected AccessibleTree() {
            super(Tree.this);
        }

        void fireActiveDescendantPropertyChange(TreePath oldPath, TreePath newPath) {
            if (UIUtil.isFocusAncestor((Component)Tree.this) && oldPath != newPath) {
                JTree.AccessibleJTree.AccessibleJTreeNode oldLSA = oldPath != null ? new JTree.AccessibleJTree.AccessibleJTreeNode(this, Tree.this, oldPath, null) : null;
                JTree.AccessibleJTree.AccessibleJTreeNode newLSA = newPath != null ? new JTree.AccessibleJTree.AccessibleJTreeNode(this, Tree.this, newPath, null) : null;
                this.firePropertyChange("AccessibleActiveDescendant", oldLSA, newLSA);
            }
        }
    }

    public static interface NodeFilter<T> {
        public boolean accept(T var1);
    }

    private class MyFocusListener
    extends FocusAdapter {
        private MyFocusListener() {
        }

        private void focusChanges() {
            TreePath[] paths = Tree.this.getSelectionPaths();
            if (paths != null) {
                TreeUI ui = Tree.this.getUI();
                for (int i = paths.length - 1; i >= 0; --i) {
                    Rectangle bounds = ui.getPathBounds(Tree.this, paths[i]);
                    if (bounds == null) continue;
                    Tree.this.repaint(bounds);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusChanges();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusChanges();
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.setPressed(event, true);
            if (!JBSwingUtilities.isLeftMouseButton((MouseEvent)event) && (JBSwingUtilities.isRightMouseButton((MouseEvent)event) || JBSwingUtilities.isMiddleMouseButton((MouseEvent)event))) {
                TreePath[] selectionPaths;
                TreePath path2 = Tree.this.getClosestPathForLocation(event.getX(), event.getY());
                if (path2 == null) {
                    return;
                }
                Rectangle bounds = Tree.this.getPathBounds(path2);
                if (bounds != null && bounds.y + bounds.height < event.getY()) {
                    return;
                }
                if (Tree.this.getSelectionModel().getSelectionMode() != 1 && (selectionPaths = Tree.this.getSelectionModel().getSelectionPaths()) != null) {
                    for (TreePath selectionPath : selectionPaths) {
                        if (selectionPath == null || !selectionPath.equals(path2)) continue;
                        return;
                    }
                }
                Tree.this.getSelectionModel().setSelectionPath(path2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.setPressed(event, false);
            if (event.getButton() == 1 && event.getClickCount() == 2 && Tree.this.isLocationInExpandControl(Tree.this.getClosestPathForLocation(event.getX(), event.getY()), event.getX())) {
                event.consume();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (UIUtil.isUnderWin10LookAndFeel() && Tree.this.rollOverPath != null) {
                TreeCellRenderer renderer = Tree.this.getCellRenderer();
                if (Tree.this.rollOverPath.getLastPathComponent() instanceof TreeNode) {
                    TreeNode node = (TreeNode)Tree.this.rollOverPath.getLastPathComponent();
                    JComponent c = (JComponent)renderer.getTreeCellRendererComponent(Tree.this, node, Tree.this.isPathSelected(Tree.this.rollOverPath), Tree.this.isExpanded(Tree.this.rollOverPath), Tree.this.getModel().isLeaf(node), Tree.this.getRowForPath(Tree.this.rollOverPath), Tree.this.hasFocus());
                    c.putClientProperty("JCheckBox.rollOver.rectangle", null);
                    Tree.this.rollOverPath = null;
                    UIUtil.repaintViewport((JComponent)Tree.this);
                }
            }
        }

        private void setPressed(MouseEvent e, boolean pressed) {
            if (UIUtil.isUnderWin10LookAndFeel()) {
                Point p = e.getPoint();
                TreePath path2 = Tree.this.getPathForLocation(p.x, p.y);
                if (path2 != null && path2.getLastPathComponent() instanceof TreeNode) {
                    TreeNode node = (TreeNode)path2.getLastPathComponent();
                    JComponent c = (JComponent)Tree.this.getCellRenderer().getTreeCellRendererComponent(Tree.this, node, Tree.this.isPathSelected(path2), Tree.this.isExpanded(path2), Tree.this.getModel().isLeaf(node), Tree.this.getRowForPath(path2), Tree.this.hasFocus());
                    if (pressed) {
                        c.putClientProperty("JCheckBox.pressed.rectangle", c instanceof JCheckBox ? Tree.this.getPathBounds(path2) : node);
                    } else {
                        c.putClientProperty("JCheckBox.pressed.rectangle", null);
                    }
                    UIUtil.repaintViewport((JComponent)Tree.this);
                }
            }
        }
    }

    private static class MySelectionModel
    extends DefaultTreeSelectionModel {
        private TreePath[] myHeldSelection;

        private MySelectionModel() {
        }

        @Override
        protected void fireValueChanged(TreeSelectionEvent e) {
            if (this.myHeldSelection == null) {
                super.fireValueChanged(e);
            }
        }

        public void holdSelection() {
            this.myHeldSelection = this.getSelectionPaths();
        }

        public void unholdSelection() {
            if (this.myHeldSelection != null) {
                this.setSelectionPaths(this.myHeldSelection);
                this.myHeldSelection = null;
            }
        }
    }
}

