/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AutoScrollFromSourceHandler
implements Disposable {
    protected final Project myProject;
    protected final Alarm myAlarm;
    private final JComponent myComponent;

    public AutoScrollFromSourceHandler(@NotNull Project project, @NotNull JComponent view) {
        if (project == null) {
            AutoScrollFromSourceHandler.$$$reportNull$$$0(0);
        }
        if (view == null) {
            AutoScrollFromSourceHandler.$$$reportNull$$$0(1);
        }
        this(project, view, null);
    }

    public AutoScrollFromSourceHandler(@NotNull Project project, @NotNull JComponent view, @Nullable Disposable parentDisposable) {
        if (project == null) {
            AutoScrollFromSourceHandler.$$$reportNull$$$0(2);
        }
        if (view == null) {
            AutoScrollFromSourceHandler.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
        this.myComponent = view;
        this.myAlarm = new Alarm(this);
    }

    protected abstract boolean isAutoScrollEnabled();

    protected abstract void setAutoScrollEnabled(boolean var1);

    protected abstract void selectElementFromEditor(@NotNull FileEditor var1);

    protected ModalityState getModalityState() {
        return ModalityState.current();
    }

    protected long getAlarmDelay() {
        return Registry.intValue((String)"ide.autoscroll.from.source.delay", (int)100);
    }

    public void install() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AutoScrollFromSourceHandler.this.selectInAlarm(event.getNewEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/AutoScrollFromSourceHandler$1", "selectionChanged"));
            }
        });
        this.updateCurrentSelection();
    }

    private void selectInAlarm(FileEditor editor) {
        if (editor != null && this.myComponent.isShowing() && this.isAutoScrollEnabled()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.selectElementFromEditor(editor), this.getAlarmDelay(), this.getModalityState());
        }
    }

    private void updateCurrentSelection() {
        FileEditor selectedEditor = FileEditorManager.getInstance(this.myProject).getSelectedEditor();
        if (selectedEditor != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.selectInAlarm(selectedEditor), ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    public void dispose() {
        if (!this.myAlarm.isDisposed()) {
            this.myAlarm.cancelAllRequests();
        }
    }

    public ToggleAction createToggleAction() {
        return new AutoScrollFromSourceAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/AutoScrollFromSourceHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AutoScrollFromSourceAction
    extends ToggleAction
    implements DumbAware {
        AutoScrollFromSourceAction() {
            super(UIBundle.message((String)"autoscroll.from.source.action.name", (Object[])new Object[0]), UIBundle.message((String)"autoscroll.from.source.action.description", (Object[])new Object[0]), AllIcons.General.AutoscrollFromSource);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                AutoScrollFromSourceAction.$$$reportNull$$$0(0);
            }
            return AutoScrollFromSourceHandler.this.isAutoScrollEnabled();
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                AutoScrollFromSourceAction.$$$reportNull$$$0(1);
            }
            AutoScrollFromSourceHandler.this.setAutoScrollEnabled(flag);
            AutoScrollFromSourceHandler.this.updateCurrentSelection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ui/AutoScrollFromSourceHandler$AutoScrollFromSourceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

