/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class StubElementTypeHolderEP
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubElementTypeHolderEP");
    public static final ExtensionPointName<StubElementTypeHolderEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.stubElementTypeHolder");
    @Attribute(value="class")
    public String holderClass;
    @Attribute(value="externalIdPrefix")
    @Nullable
    public String externalIdPrefix;

    List<StubFieldAccessor> initializeOptimized() {
        try {
            if (this.externalIdPrefix != null) {
                ArrayList<StubFieldAccessor> result2 = new ArrayList<StubFieldAccessor>();
                Class<?> aClass = Class.forName(this.holderClass, false, this.getLoaderForClass());
                assert (aClass.isInterface());
                for (Field field : aClass.getDeclaredFields()) {
                    result2.add(new StubFieldAccessor(this.externalIdPrefix + field.getName(), field));
                }
                return result2;
            }
            this.findClass(this.holderClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
        }
        return Collections.emptyList();
    }

    public void initialize() {
        try {
            this.findClass(this.holderClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
        }
    }

    public String toString() {
        return this.holderClass;
    }
}

