/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtil
extends VfsUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtil");
    public static final long NOTIFICATION_DELAY_MILLIS = 300L;

    public static void saveText(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            VfsUtil.$$$reportNull$$$0(1);
        }
        Charset charset = file.getCharset();
        file.setBinaryContent(text.getBytes(charset.name()));
    }

    @NotNull
    public static byte[] toByteArray(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            VfsUtil.$$$reportNull$$$0(3);
        }
        if (text.isEmpty()) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                VfsUtil.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        Charset charset = file.getCharset();
        byte[] byArray = text.getBytes(charset.name());
        if (byArray == null) {
            VfsUtil.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    public static void copyDirectory(Object requestor, @NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, @Nullable VirtualFileFilter filter) throws IOException {
        VirtualFile[] children;
        if (fromDir == null) {
            VfsUtil.$$$reportNull$$$0(6);
        }
        if (toDir == null) {
            VfsUtil.$$$reportNull$$$0(7);
        }
        for (VirtualFile child : children = fromDir.getChildren()) {
            if (child.is(VFileProperty.SYMLINK) || child.is(VFileProperty.SPECIAL) || filter != null && !filter.accept(child)) continue;
            if (!child.isDirectory()) {
                VfsUtil.copyFile(requestor, child, toDir);
                continue;
            }
            VirtualFile newChild = toDir.findChild(child.getName());
            if (newChild == null) {
                newChild = toDir.createChildDirectory(requestor, child.getName());
            }
            VfsUtil.copyDirectory(requestor, child, newChild, filter);
        }
    }

    public static VirtualFile copy(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(8);
        }
        if (toDir == null) {
            VfsUtil.$$$reportNull$$$0(9);
        }
        if (file.isDirectory()) {
            VirtualFile newDir = toDir.createChildDirectory(requestor, file.getName());
            VfsUtil.copyDirectory(requestor, file, newDir, null);
            return newDir;
        }
        return VfsUtil.copyFile(requestor, file, toDir);
    }

    @NotNull
    public static VirtualFile[] getCommonAncestors(@NotNull VirtualFile[] files) {
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(10);
        }
        HashMap<VirtualFile, Object> map = new HashMap<VirtualFile, Object>();
        for (VirtualFile aFile : files) {
            Object filesSet;
            VirtualFile directory;
            VirtualFile virtualFile2 = directory = aFile.isDirectory() ? aFile : aFile.getParent();
            if (directory == null) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    VfsUtil.$$$reportNull$$$0(11);
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] path2 = VfsUtil.getPathComponents(directory);
            VirtualFile firstPart = path2[0];
            if (map.containsKey(firstPart)) {
                filesSet = (Set)map.get(firstPart);
            } else {
                filesSet = new THashSet();
                map.put(firstPart, filesSet);
            }
            filesSet.add(directory);
        }
        ArrayList<VirtualFile> ancestorsList = new ArrayList<VirtualFile>();
        for (Set filesSet : map.values()) {
            VirtualFile ancestor = null;
            for (VirtualFile file : filesSet) {
                if (ancestor == null) {
                    ancestor = file;
                    continue;
                }
                ancestor = VfsUtil.getCommonAncestor(ancestor, file);
            }
            ancestorsList.add(ancestor);
            filesSet.clear();
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(ancestorsList);
        if (virtualFileArray == null) {
            VfsUtil.$$$reportNull$$$0(12);
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(13);
        }
        VirtualFile ancestor = null;
        for (VirtualFile virtualFile2 : files) {
            if (ancestor == null) {
                ancestor = virtualFile2;
                continue;
            }
            if ((ancestor = VfsUtil.getCommonAncestor(ancestor, virtualFile2)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@Nullable VirtualFile base, String ... path2) {
        VirtualFile file = base;
        for (String pathElement : path2) {
            if (file == null) {
                return null;
            }
            file = "..".equals(pathElement) ? file.getParent() : file.findChild(pathElement);
        }
        return file;
    }

    @Nullable
    public static VirtualFile findFileByURL(@NotNull URL url) {
        if (url == null) {
            VfsUtil.$$$reportNull$$$0(14);
        }
        String vfsUrl = VfsUtil.convertFromUrl(url);
        return VirtualFileManager.getInstance().findFileByUrl(vfsUrl);
    }

    @Nullable
    public static VirtualFile findFile(@NotNull Path path2, boolean refreshIfNeeded) {
        if (path2 == null) {
            VfsUtil.$$$reportNull$$$0(15);
        }
        return VfsUtil.findFileByIoFile(path2.toFile(), refreshIfNeeded);
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull File file, boolean refreshIfNeeded) {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(16);
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile2 = fileSystem.findFileByIoFile(file);
        if (refreshIfNeeded && (virtualFile2 == null || !virtualFile2.isValid())) {
            virtualFile2 = fileSystem.refreshAndFindFileByIoFile(file);
        }
        return virtualFile2;
    }

    @Nullable
    public static VirtualFile refreshAndFindChild(@NotNull VirtualFile directory, @NotNull String name) {
        if (directory == null) {
            VfsUtil.$$$reportNull$$$0(17);
        }
        if (name == null) {
            VfsUtil.$$$reportNull$$$0(18);
        }
        if (directory instanceof NewVirtualFile) {
            return ((NewVirtualFile)directory).refreshAndFindChild(name);
        }
        return VfsUtil.findFileByIoFile(new File(VfsUtil.virtualToIoFile(directory), name), true);
    }

    @NotNull
    public static URI toUri(@NotNull File file) {
        URI uRI;
        block4: {
            if (file == null) {
                VfsUtil.$$$reportNull$$$0(19);
            }
            String path2 = file.toURI().getPath();
            try {
                if (SystemInfo.isWindows && path2.charAt(0) != '/') {
                    path2 = '/' + path2;
                }
                if ((uRI = new URI("file", "", path2, null, null)) != null) break block4;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            VfsUtil.$$$reportNull$$$0(20);
        }
        return uRI;
    }

    @Nullable
    public static URI toUri(@NonNls @NotNull String uri) {
        int firstSlashIndex;
        int index2;
        if (uri == null) {
            VfsUtil.$$$reportNull$$$0(21);
        }
        if ((index2 = uri.indexOf("://")) < 0) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }
        if (SystemInfo.isWindows && uri.startsWith("file://") && uri.charAt(firstSlashIndex = index2 + "://".length()) != '/') {
            uri = "file:///" + uri.substring(firstSlashIndex);
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.debug("uri is not fully encoded", (Throwable)e);
            try {
                int fragmentIndex = uri.lastIndexOf(35);
                String path2 = uri.substring(index2 + 1, fragmentIndex > 0 ? fragmentIndex : uri.length());
                String fragment = fragmentIndex > 0 ? uri.substring(fragmentIndex + 1) : null;
                return new URI(uri.substring(0, index2), path2, fragment);
            }
            catch (URISyntaxException e1) {
                LOG.debug((Throwable)e1);
                return null;
            }
        }
    }

    public static String getUrlForLibraryRoot(@NotNull File libraryRoot) {
        if (libraryRoot == null) {
            VfsUtil.$$$reportNull$$$0(22);
        }
        String path2 = FileUtil.toSystemIndependentName((String)libraryRoot.getAbsolutePath());
        if (FileTypeManager.getInstance().getFileTypeByFileName(libraryRoot.getName()) == ArchiveFileType.INSTANCE) {
            return VirtualFileManager.constructUrl(JarFileSystem.getInstance().getProtocol(), path2 + "!/");
        }
        return VirtualFileManager.constructUrl(LocalFileSystem.getInstance().getProtocol(), path2);
    }

    @NotNull
    public static String getNextAvailableName(@NotNull VirtualFile dir, @NotNull String prefix, @NotNull String extension) {
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(23);
        }
        if (prefix == null) {
            VfsUtil.$$$reportNull$$$0(24);
        }
        if (extension == null) {
            VfsUtil.$$$reportNull$$$0(25);
        }
        String dotExt = PathUtil.makeFileName("", extension);
        String fileName = prefix + dotExt;
        int i = 1;
        while (dir.findChild(fileName) != null) {
            fileName = prefix + "_" + i + dotExt;
            ++i;
        }
        String string = fileName;
        if (string == null) {
            VfsUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static VirtualFile createChildSequent(Object requestor, @NotNull VirtualFile dir, @NotNull String prefix, @NotNull String extension) throws IOException {
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(27);
        }
        if (prefix == null) {
            VfsUtil.$$$reportNull$$$0(28);
        }
        if (extension == null) {
            VfsUtil.$$$reportNull$$$0(29);
        }
        VirtualFile virtualFile2 = dir.createChildData(requestor, VfsUtil.getNextAvailableName(dir, prefix, extension));
        if (virtualFile2 == null) {
            VfsUtil.$$$reportNull$$$0(30);
        }
        return virtualFile2;
    }

    @NotNull
    public static String[] filterNames(@NotNull String[] names) {
        if (names == null) {
            VfsUtil.$$$reportNull$$$0(31);
        }
        int filteredCount = 0;
        for (String string : names) {
            if (!VfsUtil.isBadName(string)) continue;
            ++filteredCount;
        }
        if (filteredCount == 0) {
            if (names == null) {
                VfsUtil.$$$reportNull$$$0(32);
            }
            return names;
        }
        String[] result2 = ArrayUtil.newStringArray((int)(names.length - filteredCount));
        int count = 0;
        for (String string : names) {
            if (VfsUtil.isBadName(string)) continue;
            result2[count++] = string;
        }
        if (result2 == null) {
            VfsUtil.$$$reportNull$$$0(33);
        }
        return result2;
    }

    public static boolean isBadName(String name) {
        return name == null || name.isEmpty() || "/".equals(name) || "\\".equals(name);
    }

    public static VirtualFile createDirectories(@NotNull String directoryPath) throws IOException {
        if (directoryPath == null) {
            VfsUtil.$$$reportNull$$$0(34);
        }
        return (VirtualFile)WriteAction.computeAndWait(() -> VfsUtil.createDirectoryIfMissing(directoryPath));
    }

    public static VirtualFile createDirectoryIfMissing(@Nullable VirtualFile parent, String relativePath) throws IOException {
        if (parent == null) {
            return VfsUtil.createDirectoryIfMissing(relativePath);
        }
        for (String each : StringUtil.split((String)relativePath, (String)"/")) {
            VirtualFile child = parent.findChild(each);
            if (child == null) {
                child = parent.createChildDirectory(parent.getFileSystem(), each);
            }
            parent = child;
        }
        return parent;
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull String directoryPath) throws IOException {
        if (directoryPath == null) {
            VfsUtil.$$$reportNull$$$0(35);
        }
        String path2 = FileUtil.toSystemIndependentName((String)directoryPath);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
        if (file == null) {
            int pos = path2.lastIndexOf(47);
            if (pos < 0) {
                return null;
            }
            VirtualFile parent = VfsUtil.createDirectoryIfMissing(path2.substring(0, pos));
            if (parent == null) {
                return null;
            }
            String dirName = path2.substring(pos + 1);
            VirtualFile child = parent.findChild(dirName);
            if (child != null && child.isDirectory()) {
                return child;
            }
            return parent.createChildDirectory(LocalFileSystem.getInstance(), dirName);
        }
        return file;
    }

    @NotNull
    public static List<VirtualFile> collectChildrenRecursively(@NotNull VirtualFile root) {
        if (root == null) {
            VfsUtil.$$$reportNull$$$0(36);
        }
        final ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        VfsUtil.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                result2.add(file);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil$1", "visitFile"));
            }
        });
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            VfsUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    public static void processFileRecursivelyWithoutIgnored(final @NotNull VirtualFile root, final @NotNull Processor<? super VirtualFile> processor) {
        if (root == null) {
            VfsUtil.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            VfsUtil.$$$reportNull$$$0(39);
        }
        final FileTypeManager ftm = FileTypeManager.getInstance();
        VfsUtil.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!processor.process((Object)file)) {
                    VirtualFileVisitor.Result result2 = 2.skipTo(root);
                    if (result2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = file.isDirectory() && ftm.isFileIgnored(file) ? SKIP_CHILDREN : CONTINUE;
                if (result3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtil$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    public static String getReadableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(40);
        }
        String url = null;
        if (file.isInLocalFileSystem()) {
            url = file.getPresentableUrl();
        }
        if (url == null) {
            url = file.getUrl();
        }
        String string = url;
        if (string == null) {
            VfsUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getUserHomeDir() {
        String path2 = SystemProperties.getUserHome();
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
    }

    @NotNull
    public static VirtualFile[] getChildren(@NotNull VirtualFile dir) {
        VirtualFile[] children;
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(42);
        }
        VirtualFile[] virtualFileArray = (children = dir.getChildren()) == null ? VirtualFile.EMPTY_ARRAY : children;
        if (virtualFileArray == null) {
            VfsUtil.$$$reportNull$$$0(43);
        }
        return virtualFileArray;
    }

    @NotNull
    public static List<VirtualFile> getChildren(@NotNull VirtualFile dir, @NotNull VirtualFileFilter filter) {
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(44);
        }
        if (filter == null) {
            VfsUtil.$$$reportNull$$$0(45);
        }
        List result2 = null;
        for (VirtualFile child : dir.getChildren()) {
            if (!filter.accept(child)) continue;
            if (result2 == null) {
                result2 = ContainerUtil.newSmartList();
            }
            result2.add(child);
        }
        List list = result2 != null ? result2 : ContainerUtil.emptyList();
        if (list == null) {
            VfsUtil.$$$reportNull$$$0(46);
        }
        return list;
    }

    @Nullable
    public static String getParentDir(@Nullable String url) {
        if (url == null) {
            return null;
        }
        int index2 = url.lastIndexOf(47);
        return index2 < 0 ? null : url.substring(0, index2);
    }

    @Nullable
    public static String extractFileName(@Nullable String urlOrPath) {
        if (urlOrPath == null) {
            return null;
        }
        int index2 = urlOrPath.lastIndexOf(47);
        return index2 < 0 ? null : urlOrPath.substring(index2 + 1);
    }

    @NotNull
    public static List<VirtualFile> markDirty(boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List list;
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(47);
        }
        if ((list = ContainerUtil.filter((Object[])files, (Condition)Condition.NOT_NULL)).isEmpty()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VfsUtil.$$$reportNull$$$0(48);
            }
            return list2;
        }
        for (VirtualFile file : list) {
            if (reloadChildren && file.isValid()) {
                file.getChildren();
            }
            if (!(file instanceof NewVirtualFile)) continue;
            if (recursive) {
                ((NewVirtualFile)file).markDirtyRecursively();
                continue;
            }
            ((NewVirtualFile)file).markDirty();
        }
        List list3 = list;
        if (list3 == null) {
            VfsUtil.$$$reportNull$$$0(49);
        }
        return list3;
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List<VirtualFile> list;
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(50);
        }
        if ((list = VfsUtil.markDirty(recursive, reloadChildren, files)).isEmpty()) {
            return;
        }
        LocalFileSystem.getInstance().refreshFiles(list, async, recursive, null);
    }

    @NotNull
    public static VirtualFile getRootFile(@NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(51);
        }
        while ((parent = file.getParent()) != null) {
            file = parent;
        }
        VirtualFile virtualFile2 = file;
        if (virtualFile2 == null) {
            VfsUtil.$$$reportNull$$$0(52);
        }
        return virtualFile2;
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile file) {
        VirtualFile localFile;
        VirtualFileSystem fileSystem;
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(53);
        }
        if (file.isValid() && (fileSystem = file.getFileSystem()) instanceof ArchiveFileSystem && (localFile = ((ArchiveFileSystem)fileSystem).getLocalByEntry(file)) != null) {
            VirtualFile virtualFile2 = localFile;
            if (virtualFile2 == null) {
                VfsUtil.$$$reportNull$$$0(54);
            }
            return virtualFile2;
        }
        VirtualFile virtualFile3 = file;
        if (virtualFile3 == null) {
            VfsUtil.$$$reportNull$$$0(55);
        }
        return virtualFile3;
    }

    @Deprecated
    public static String toIdeaUrl(@NotNull String url) {
        if (url == null) {
            VfsUtil.$$$reportNull$$$0(56);
        }
        return VfsUtil.toIdeaUrl(url, true);
    }

    @Deprecated
    public static VirtualFile copyFileRelative(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String relativePath) throws IOException {
        String token;
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(57);
        }
        if (toDir == null) {
            VfsUtil.$$$reportNull$$$0(58);
        }
        if (relativePath == null) {
            VfsUtil.$$$reportNull$$$0(59);
        }
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        VirtualFile curDir = toDir;
        while (true) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) break;
            VirtualFile childDir = curDir.findChild(token);
            if (childDir == null) {
                childDir = curDir.createChildDirectory(requestor, token);
            }
            curDir = childDir;
        }
        return VfsUtil.copyFile(requestor, file, curDir, token);
    }

    @Deprecated
    @Nullable
    public static String getPath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        VirtualFile commonAncestor;
        if (src == null) {
            VfsUtil.$$$reportNull$$$0(60);
        }
        if (dst == null) {
            VfsUtil.$$$reportNull$$$0(61);
        }
        if ((commonAncestor = VfsUtil.getCommonAncestor(src, dst)) != null) {
            StringBuilder buffer = new StringBuilder();
            if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                while (!Comparing.equal((Object)src.getParent(), (Object)commonAncestor)) {
                    buffer.append("..").append(separatorChar);
                    src = src.getParent();
                }
            }
            buffer.append(VfsUtil.getRelativePath(dst, commonAncestor, separatorChar));
            return buffer.toString();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static URI toUri(@NotNull VirtualFile file) {
        URI uRI;
        block10: {
            String protocol;
            String path2;
            block8: {
                URI uRI2;
                block9: {
                    block6: {
                        URI uRI3;
                        block7: {
                            if (file == null) {
                                VfsUtil.$$$reportNull$$$0(62);
                            }
                            path2 = file.getPath();
                            try {
                                protocol = file.getFileSystem().getProtocol();
                                if (!file.isInLocalFileSystem()) break block6;
                                if (SystemInfo.isWindows && path2.charAt(0) != '/') {
                                    path2 = '/' + path2;
                                }
                                if ((uRI3 = new URI(protocol, "", path2, null, null)) != null) break block7;
                            }
                            catch (URISyntaxException e) {
                                throw new IllegalArgumentException(e);
                            }
                            VfsUtil.$$$reportNull$$$0(63);
                        }
                        return uRI3;
                    }
                    if (!"http".equals(protocol)) break block8;
                    uRI2 = new URI("http://" + path2);
                    if (uRI2 != null) break block9;
                    VfsUtil.$$$reportNull$$$0(64);
                }
                return uRI2;
            }
            uRI = new URI(protocol, path2, null);
            if (uRI != null) break block10;
            VfsUtil.$$$reportNull$$$0(65);
        }
        return uRI;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VfsUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 7: 
            case 9: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 10: 
            case 13: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 14: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRoot";
                break;
            }
            case 23: 
            case 27: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VfsUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toByteArray";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonAncestors";
                break;
            }
            case 20: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "toUri";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextAvailableName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildSequent";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChildrenRecursively";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableUrl";
                break;
            }
            case 43: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "markDirty";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toByteArray";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findFileByURL";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 19: 
            case 21: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "toUri";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUrlForLibraryRoot";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNextAvailableName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createChildSequent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryIfMissing";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectChildrenRecursively";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processFileRecursivelyWithoutIgnored";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getReadableUrl";
                break;
            }
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "markDirty";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyAndRefresh";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getRootFile";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFile";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "toIdeaUrl";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "copyFileRelative";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 20: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 54: 
            case 55: 
            case 63: 
            case 64: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

