/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u001e\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u001a\u000e\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\u000bH\u0007\u001a\f\u0010\u0010\u001a\u00020\u000f*\u0004\u0018\u00010\u000b\u001a\u000e\u0010\u0011\u001a\u00020\u000f*\u0004\u0018\u00010\u000bH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"SERVICE_NAME_PREFIX", "", "CredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "requestor", "Ljava/lang/Class;", "userName", "generateServiceName", "subsystem", "key", "getAndMigrateCredentials", "Lcom/intellij/credentialStore/Credentials;", "oldAttributes", "newAttributes", "hasOnlyUserName", "", "isEmpty", "isFulfilled", "intellij.platform.ide"})
public final class CredentialAttributesKt {
    @NotNull
    public static final String SERVICE_NAME_PREFIX = "IntelliJ Platform";

    @NotNull
    public static final String generateServiceName(@NotNull String subsystem, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)subsystem, (String)"subsystem");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return "IntelliJ Platform " + subsystem + " \u2014 " + key;
    }

    @Deprecated(message="Never use it in a new code.")
    @NotNull
    public static final CredentialAttributes CredentialAttributes(@NotNull Class<?> requestor, @Nullable String userName) {
        Intrinsics.checkParameterIsNotNull(requestor, (String)"requestor");
        String string = requestor.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requestor.name");
        return new CredentialAttributes(string, userName, requestor, false, 8, null);
    }

    @Contract(value="null -> false")
    public static final boolean isFulfilled(@Nullable Credentials $receiver) {
        CharSequence charSequence;
        return $receiver != null && $receiver.getUserName() != null && !((charSequence = (CharSequence)((Object)$receiver.getPassword())) == null || charSequence.length() == 0);
    }

    @Contract(value="null -> false")
    public static final boolean hasOnlyUserName(@Nullable Credentials $receiver) {
        CharSequence charSequence;
        return $receiver != null && $receiver.getUserName() != null && ((charSequence = (CharSequence)((Object)$receiver.getPassword())) == null || charSequence.length() == 0);
    }

    public static final boolean isEmpty(@Nullable Credentials $receiver) {
        CharSequence charSequence;
        return $receiver == null || $receiver.getUserName() == null && ((charSequence = (CharSequence)((Object)$receiver.getPassword())) == null || charSequence.length() == 0);
    }

    @Nullable
    public static final Credentials getAndMigrateCredentials(@NotNull CredentialAttributes oldAttributes, @NotNull CredentialAttributes newAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)oldAttributes, (String)"oldAttributes");
        Intrinsics.checkParameterIsNotNull((Object)newAttributes, (String)"newAttributes");
        PasswordSafe safe = PasswordSafe.Companion.getInstance();
        Credentials credentials = safe.get(newAttributes);
        if (credentials == null && (credentials = safe.get(oldAttributes)) != null) {
            safe.set(oldAttributes, null);
            safe.set(newAttributes, credentials);
        }
        return credentials;
    }
}

