/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.lib;

import java.io.IOException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.PersonIdent;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RefUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;

public abstract class RefRename {
    protected final RefUpdate source;
    protected final RefUpdate destination;
    private RefUpdate.Result result = RefUpdate.Result.NOT_ATTEMPTED;

    protected RefRename(RefUpdate src, RefUpdate dst) {
        this.source = src;
        this.destination = dst;
        String cmd = "";
        if (this.source.getName().startsWith("refs/heads/") && this.destination.getName().startsWith("refs/heads/")) {
            cmd = "Branch: ";
        }
        this.setRefLogMessage(cmd + "renamed " + Repository.shortenRefName(this.source.getName()) + " to " + Repository.shortenRefName(this.destination.getName()));
    }

    public PersonIdent getRefLogIdent() {
        return this.destination.getRefLogIdent();
    }

    public void setRefLogIdent(PersonIdent pi) {
        this.destination.setRefLogIdent(pi);
    }

    public String getRefLogMessage() {
        return this.destination.getRefLogMessage();
    }

    public void setRefLogMessage(String msg) {
        if (msg == null) {
            this.disableRefLog();
        } else {
            this.destination.setRefLogMessage(msg, false);
        }
    }

    public void disableRefLog() {
        this.destination.setRefLogMessage("", false);
    }

    public RefUpdate.Result getResult() {
        return this.result;
    }

    public RefUpdate.Result rename() throws IOException {
        try {
            this.result = this.doRename();
            return this.result;
        }
        catch (IOException err) {
            this.result = RefUpdate.Result.IO_FAILURE;
            throw err;
        }
    }

    protected abstract RefUpdate.Result doRename() throws IOException;

    protected boolean needToUpdateHEAD() throws IOException {
        Ref head = this.source.getRefDatabase().getRef("HEAD");
        if (head != null && head.isSymbolic()) {
            head = head.getTarget();
            return head.getName().equals(this.source.getName());
        }
        return false;
    }
}

