/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.StoredConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleSyncCommand
extends GitCommand<Map<String, String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleSyncCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleSyncCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    protected String getHeadBranch(Repository subRepo) throws IOException {
        Ref head = subRepo.exactRef("HEAD");
        if (head != null && head.isSymbolic()) {
            return Repository.shortenRefName(head.getLeaf().getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> call() throws GitAPIException {
        this.checkCallable();
        try {
            SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            HashMap<String, String> synced = new HashMap<String, String>();
            StoredConfig config = this.repo.getConfig();
            while (generator.next()) {
                String remoteUrl = generator.getRemoteUrl();
                if (remoteUrl == null) continue;
                String path = generator.getPath();
                config.setString("submodule", path, "url", remoteUrl);
                synced.put(path, remoteUrl);
                Repository subRepo = generator.getRepository();
                if (subRepo == null) continue;
                try {
                    StoredConfig subConfig = subRepo.getConfig();
                    String branch = this.getHeadBranch(subRepo);
                    String remote = null;
                    if (branch != null) {
                        remote = subConfig.getString("branch", branch, "remote");
                    }
                    if (remote == null) {
                        remote = "origin";
                    }
                    subConfig.setString("remote", remote, "url", remoteUrl);
                    subConfig.save();
                }
                finally {
                    subRepo.close();
                }
            }
            if (!synced.isEmpty()) {
                config.save();
            }
            return synced;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

