/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.legacy.repository;

import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout2;
import org.gradle.internal.impldep.org.apache.maven.repository.legacy.repository.ArtifactRepositoryFactory;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactRepositoryFactory.class)
public class DefaultArtifactRepositoryFactory
implements ArtifactRepositoryFactory {
    private String globalUpdatePolicy;
    private String globalChecksumPolicy;
    @Requirement(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;

    public ArtifactRepositoryLayout getLayout(String layoutId) throws UnknownRepositoryLayoutException {
        return this.repositoryLayouts.get(layoutId);
    }

    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, String layoutId, boolean uniqueVersion) throws UnknownRepositoryLayoutException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return this.createDeploymentArtifactRepository(id, url, layout, uniqueVersion);
    }

    private void checkLayout(String repositoryId, String layoutId, ArtifactRepositoryLayout layout) throws UnknownRepositoryLayoutException {
        if (layout == null) {
            throw new UnknownRepositoryLayoutException(repositoryId, layoutId);
        }
    }

    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, boolean uniqueVersion) {
        return this.createArtifactRepository(id, url, repositoryLayout, null, null);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, String layoutId, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) throws UnknownRepositoryLayoutException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return this.createArtifactRepository(id, url, layout, snapshots, releases);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        if (this.globalUpdatePolicy != null) {
            snapshots.setUpdatePolicy(this.globalUpdatePolicy);
            releases.setUpdatePolicy(this.globalUpdatePolicy);
        }
        if (this.globalChecksumPolicy != null) {
            snapshots.setChecksumPolicy(this.globalChecksumPolicy);
            releases.setChecksumPolicy(this.globalChecksumPolicy);
        }
        ArtifactRepository repository = repositoryLayout instanceof ArtifactRepositoryLayout2 ? ((ArtifactRepositoryLayout2)repositoryLayout).newMavenArtifactRepository(id, url, snapshots, releases) : new MavenArtifactRepository(id, url, repositoryLayout, snapshots, releases);
        return repository;
    }

    public void setGlobalUpdatePolicy(String updatePolicy) {
        this.globalUpdatePolicy = updatePolicy;
    }

    public void setGlobalChecksumPolicy(String checksumPolicy) {
        this.globalChecksumPolicy = checksumPolicy;
    }
}

