/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.common.hash;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.impldep.com.google.common.annotations.Beta;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.hash.HashFunction;
import org.gradle.internal.impldep.com.google.common.hash.Hasher;

@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super(Preconditions.checkNotNull(out));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

