/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.test.env;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.lang.MetaLanguage;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.util.JavaClassSupers;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.test.env.AbstractCoreEnvironment;

public class TestCoreEnvironment
extends AbstractCoreEnvironment {
    private static final Object APPLICATION_LOCK = new Object();
    private static volatile JavaCoreApplicationEnvironment sEnvironment = null;
    private final Disposable mDisposable;
    private volatile JavaCoreProjectEnvironment mProjectEnvironment;

    public TestCoreEnvironment(@NotNull Disposable disposable) {
        if (disposable == null) {
            TestCoreEnvironment.$$$reportNull$$$0(0);
        }
        this.mProjectEnvironment = null;
        this.mDisposable = disposable;
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.mDisposable);
    }

    @Override
    public MockProject getProject() {
        JavaCoreProjectEnvironment projectEnvironment = this.getProjectEnvironment();
        if (projectEnvironment == null) {
            return null;
        }
        return projectEnvironment.getProject();
    }

    @Override
    public void addJavaSourceRoot(@NotNull File root) {
        if (root == null) {
            TestCoreEnvironment.$$$reportNull$$$0(1);
        }
        VirtualFileSystem vfs = StandardFileSystems.local();
        try {
            this.addDirectoryToClassPath(vfs, root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDirectoryToClassPath(VirtualFileSystem vfs, File root) throws IOException {
        VirtualFile virtualFile = vfs.findFileByPath(root.getCanonicalPath());
        assert (virtualFile != null);
        this.getProjectEnvironment().addSourcesToClasspath(virtualFile);
    }

    @Override
    public void addJar(@NotNull File root) {
        if (root == null) {
            TestCoreEnvironment.$$$reportNull$$$0(2);
        }
        this.getProjectEnvironment().addJarToClassPath(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaCoreProjectEnvironment getProjectEnvironment() {
        if (this.mProjectEnvironment != null) {
            return this.mProjectEnvironment;
        }
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            if (this.mProjectEnvironment != null) {
                return this.mProjectEnvironment;
            }
            JavaCoreApplicationEnvironment coreEnvironment = TestCoreEnvironment.getCoreEnvironment();
            this.mProjectEnvironment = new TestJavaCoreProjectEnvironment(coreEnvironment);
            Disposer.register((Disposable)this.mDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    TestCoreEnvironment.this.mProjectEnvironment = null;
                }
            });
            return this.mProjectEnvironment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaCoreApplicationEnvironment getCoreEnvironment() {
        if (sEnvironment != null) {
            return sEnvironment;
        }
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            if (sEnvironment != null) {
                return sEnvironment;
            }
            Disposable parentDisposable = Disposer.newDisposable();
            Extensions.cleanRootArea((Disposable)parentDisposable);
            TestCoreEnvironment.registerAppExtensionPoints();
            JavaCoreApplicationEnvironment coreEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
            coreEnvironment.registerApplicationService(JavaClassSupers.class, (Object)new JavaClassSupersImpl());
            sEnvironment = coreEnvironment;
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispose() {
                    Object object = APPLICATION_LOCK;
                    synchronized (object) {
                        JavaCoreApplicationEnvironment environment = sEnvironment;
                        sEnvironment = null;
                        Disposer.dispose((Disposable)environment.getParentDisposable());
                        ZipHandler.clearFileAccessorCache();
                    }
                }
            });
            return sEnvironment;
        }
    }

    private static void registerAppExtensionPoints() {
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (String)"com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)FileContextProvider.EP_NAME, FileContextProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)MetaDataContributor.EP_NAME, MetaDataContributor.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)ContainerProvider.EP_NAME, ContainerProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)MetaLanguage.EP_NAME, MetaLanguage.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/uast/test/env/TestCoreEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addJavaSourceRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addJar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TestJavaCoreProjectEnvironment
    extends JavaCoreProjectEnvironment {
        TestJavaCoreProjectEnvironment(JavaCoreApplicationEnvironment coreEnvironment) {
            if (coreEnvironment == null) {
                TestJavaCoreProjectEnvironment.$$$reportNull$$$0(0);
            }
            super(TestCoreEnvironment.this.mDisposable, (CoreApplicationEnvironment)coreEnvironment);
            this.registerProjectExtensions();
        }

        protected void preregisterServices() {
            this.registerProjectExtensionPoints();
        }

        private void registerProjectExtensionPoints() {
            ExtensionsArea area = Extensions.getArea((AreaInstance)this.myProject);
            CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (BaseExtensionPointName)PsiTreeChangePreprocessor.EP, PsiTreeChangePreprocessor.class);
            CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (BaseExtensionPointName)PsiElementFinder.EP, PsiElementFinder.class);
        }

        private void registerProjectExtensions() {
            this.myProject.registerService(CoreJavaFileManager.class, (Object)((CoreJavaFileManager)ServiceManager.getService((Project)this.myProject, JavaFileManager.class)));
            PsiElementFinder.EP.getPoint(null).registerExtension((Object)new PsiElementFinderImpl((Project)this.myProject, (JavaFileManager)ServiceManager.getService((Project)this.myProject, JavaFileManager.class)), TestCoreEnvironment.this.mDisposable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreEnvironment", "org/jetbrains/uast/test/env/TestCoreEnvironment$TestJavaCoreProjectEnvironment", "<init>"));
        }
    }
}

