/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.test.common;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.test.common.RenderLogTestBase;
import org.jetbrains.uast.test.env.AbstractTestWithCoreEnvironmentKt;
import org.jetbrains.uast.visitor.UastVisitor;
import org.junit.Assert;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H&J\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/uast/test/common/RenderLogTestBase;", "", "check", "", "testName", "", "file", "Lorg/jetbrains/uast/UFile;", "checkParentConsistency", "", "getLogFile", "Ljava/io/File;", "getRenderFile", "getTestFile", "ext", "checkContainingFileForAllElements", "intellij.platform.uast.tests"})
public interface RenderLogTestBase {
    @NotNull
    public File getTestFile(@NotNull String var1, @NotNull String var2);

    public void check(@NotNull String var1, @NotNull UFile var2);

    public void check(@NotNull String var1, @NotNull UFile var2, boolean var3);

    public void checkParentConsistency(@NotNull UFile var1);

    public void checkContainingFileForAllElements(@NotNull UFile var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        private static File getRenderFile(RenderLogTestBase $this, String testName) {
            return $this.getTestFile(testName, "render.txt");
        }

        private static File getLogFile(RenderLogTestBase $this, String testName) {
            return $this.getTestFile(testName, "log.txt");
        }

        public static void check(RenderLogTestBase $this, @NotNull String testName, @NotNull UFile file) {
            Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            $this.check(testName, file, true);
        }

        public static void check(RenderLogTestBase $this, @NotNull String testName, @NotNull UFile file, boolean checkParentConsistency2) {
            Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            File renderFile = DefaultImpls.getRenderFile($this, testName);
            File logFile = DefaultImpls.getLogFile($this, testName);
            AbstractTestWithCoreEnvironmentKt.assertEqualsToFile("Render string", renderFile, file.asRenderString());
            AbstractTestWithCoreEnvironmentKt.assertEqualsToFile("Log string", logFile, UastUtils.asRecursiveLogString$default((UElement)((UElement)file), null, (int)1, null));
            if (checkParentConsistency2) {
                $this.checkParentConsistency(file);
            }
            $this.checkContainingFileForAllElements(file);
        }

        public static void checkParentConsistency(RenderLogTestBase $this, @NotNull UFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Map parentMap = new LinkedHashMap();
            file.accept(new UastVisitor(parentMap){
                private final Stack<UElement> parentStack;
                final /* synthetic */ Map $parentMap;

                public boolean visitElement(@NotNull UElement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UElement parent = node.getUastParent();
                    if (parent == null) {
                        Object object;
                        Assert.assertTrue((String)("Wrong null-parent of " + node.getClass() + " '" + ((object = node.getPsi()) != null && (object = object.getText()) != null && (object = StringsKt.lineSequence((CharSequence)((CharSequence)object))) != null ? (String)SequencesKt.firstOrNull((Sequence)object) : null) + '\''), (boolean)this.parentStack.empty());
                    } else {
                        Object object;
                        Assert.assertEquals((String)("Wrong parent of " + node.getClass() + " '" + ((object = node.getPsi()) != null && (object = object.getText()) != null && (object = StringsKt.lineSequence((CharSequence)((CharSequence)object))) != null ? (String)SequencesKt.firstOrNull((Sequence)object) : null) + '\''), (Object)this.parentStack.peek(), (Object)parent);
                    }
                    PsiElement psiElement = node.getPsi();
                    if (psiElement != null) {
                        PsiElement psiElement2;
                        PsiElement it = psiElement2 = psiElement;
                        boolean bl = false;
                        Map map = this.$parentMap;
                        Object object = map;
                        if (!object.containsKey(it)) {
                            map = this.$parentMap;
                            object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)this.parentStack), null, null, null, (int)0, null, (Function1)checkParentConsistency.visitElement.1.1.INSTANCE, (int)31, null);
                            map.put(it, object);
                        }
                    }
                    this.parentStack.push(node);
                    return false;
                }

                public void afterVisitElement(@NotNull UElement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitElement((UastVisitor)this, (UElement)node);
                    this.parentStack.pop();
                }
                {
                    this.$parentMap = $captured_local_variable$0;
                    this.parentStack = new Stack<E>();
                }

                public void afterVisitAnnotation(@NotNull UAnnotation node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitAnnotation((UastVisitor)this, (UAnnotation)node);
                }

                public void afterVisitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
                }

                public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
                }

                public void afterVisitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
                }

                public void afterVisitBlockExpression(@NotNull UBlockExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBlockExpression((UastVisitor)this, (UBlockExpression)node);
                }

                public void afterVisitBreakExpression(@NotNull UBreakExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBreakExpression((UastVisitor)this, (UBreakExpression)node);
                }

                public void afterVisitCallExpression(@NotNull UCallExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitCallExpression((UastVisitor)this, (UCallExpression)node);
                }

                public void afterVisitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
                }

                public void afterVisitCatchClause(@NotNull UCatchClause node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitCatchClause((UastVisitor)this, (UCatchClause)node);
                }

                public void afterVisitClass(@NotNull UClass node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitClass((UastVisitor)this, (UClass)node);
                }

                public void afterVisitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
                }

                public void afterVisitContinueExpression(@NotNull UContinueExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitContinueExpression((UastVisitor)this, (UContinueExpression)node);
                }

                public void afterVisitDeclaration(@NotNull UDeclaration node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitDeclaration((UastVisitor)this, (UDeclaration)node);
                }

                public void afterVisitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
                }

                public void afterVisitDoWhileExpression(@NotNull UDoWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
                }

                public void afterVisitEnumConstant(@NotNull UEnumConstant node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitEnumConstant((UastVisitor)this, (UEnumConstant)node);
                }

                public void afterVisitExpression(@NotNull UExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitExpression((UastVisitor)this, (UExpression)node);
                }

                public void afterVisitExpressionList(@NotNull UExpressionList node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitExpressionList((UastVisitor)this, (UExpressionList)node);
                }

                public void afterVisitField(@NotNull UField node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitField((UastVisitor)this, (UField)node);
                }

                public void afterVisitFile(@NotNull UFile node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitFile((UastVisitor)this, (UFile)node);
                }

                public void afterVisitForEachExpression(@NotNull UForEachExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitForEachExpression((UastVisitor)this, (UForEachExpression)node);
                }

                public void afterVisitForExpression(@NotNull UForExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitForExpression((UastVisitor)this, (UForExpression)node);
                }

                public void afterVisitIfExpression(@NotNull UIfExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitIfExpression((UastVisitor)this, (UIfExpression)node);
                }

                public void afterVisitImportStatement(@NotNull UImportStatement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitImportStatement((UastVisitor)this, (UImportStatement)node);
                }

                public void afterVisitInitializer(@NotNull UClassInitializer node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitInitializer((UastVisitor)this, (UClassInitializer)node);
                }

                public void afterVisitLabeledExpression(@NotNull ULabeledExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
                }

                public void afterVisitLambdaExpression(@NotNull ULambdaExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
                }

                public void afterVisitLiteralExpression(@NotNull ULiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
                }

                public void afterVisitLocalVariable(@NotNull ULocalVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLocalVariable((UastVisitor)this, (ULocalVariable)node);
                }

                public void afterVisitMethod(@NotNull UMethod node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitMethod((UastVisitor)this, (UMethod)node);
                }

                public void afterVisitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
                }

                public void afterVisitParameter(@NotNull UParameter node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitParameter((UastVisitor)this, (UParameter)node);
                }

                public void afterVisitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
                }

                public void afterVisitPolyadicExpression(@NotNull UPolyadicExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
                }

                public void afterVisitPostfixExpression(@NotNull UPostfixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
                }

                public void afterVisitPrefixExpression(@NotNull UPrefixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
                }

                public void afterVisitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
                }

                public void afterVisitReturnExpression(@NotNull UReturnExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitReturnExpression((UastVisitor)this, (UReturnExpression)node);
                }

                public void afterVisitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
                }

                public void afterVisitSuperExpression(@NotNull USuperExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSuperExpression((UastVisitor)this, (USuperExpression)node);
                }

                public void afterVisitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
                }

                public void afterVisitSwitchExpression(@NotNull USwitchExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
                }

                public void afterVisitThisExpression(@NotNull UThisExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitThisExpression((UastVisitor)this, (UThisExpression)node);
                }

                public void afterVisitThrowExpression(@NotNull UThrowExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitThrowExpression((UastVisitor)this, (UThrowExpression)node);
                }

                public void afterVisitTryExpression(@NotNull UTryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitTryExpression((UastVisitor)this, (UTryExpression)node);
                }

                public void afterVisitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
                }

                public void afterVisitUnaryExpression(@NotNull UUnaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
                }

                public void afterVisitVariable(@NotNull UVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitVariable((UastVisitor)this, (UVariable)node);
                }

                public void afterVisitWhileExpression(@NotNull UWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitWhileExpression((UastVisitor)this, (UWhileExpression)node);
                }

                public boolean visitAnnotation(@NotNull UAnnotation node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitAnnotation((UastVisitor)this, (UAnnotation)node);
                }

                public boolean visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
                }

                public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
                }

                public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
                }

                public boolean visitBlockExpression(@NotNull UBlockExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBlockExpression((UastVisitor)this, (UBlockExpression)node);
                }

                public boolean visitBreakExpression(@NotNull UBreakExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBreakExpression((UastVisitor)this, (UBreakExpression)node);
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitCallExpression((UastVisitor)this, (UCallExpression)node);
                }

                public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
                }

                public boolean visitCatchClause(@NotNull UCatchClause node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitCatchClause((UastVisitor)this, (UCatchClause)node);
                }

                public boolean visitClass(@NotNull UClass node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitClass((UastVisitor)this, (UClass)node);
                }

                public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
                }

                public boolean visitContinueExpression(@NotNull UContinueExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitContinueExpression((UastVisitor)this, (UContinueExpression)node);
                }

                public boolean visitDeclaration(@NotNull UDeclaration node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitDeclaration((UastVisitor)this, (UDeclaration)node);
                }

                public boolean visitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
                }

                public boolean visitDoWhileExpression(@NotNull UDoWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
                }

                public boolean visitEnumConstant(@NotNull UEnumConstant node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitEnumConstant((UastVisitor)this, (UEnumConstant)node);
                }

                public boolean visitExpression(@NotNull UExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitExpression((UastVisitor)this, (UExpression)node);
                }

                public boolean visitExpressionList(@NotNull UExpressionList node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitExpressionList((UastVisitor)this, (UExpressionList)node);
                }

                public boolean visitField(@NotNull UField node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitField((UastVisitor)this, (UField)node);
                }

                public boolean visitFile(@NotNull UFile node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitFile((UastVisitor)this, (UFile)node);
                }

                public boolean visitForEachExpression(@NotNull UForEachExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitForEachExpression((UastVisitor)this, (UForEachExpression)node);
                }

                public boolean visitForExpression(@NotNull UForExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitForExpression((UastVisitor)this, (UForExpression)node);
                }

                public boolean visitIfExpression(@NotNull UIfExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitIfExpression((UastVisitor)this, (UIfExpression)node);
                }

                public boolean visitImportStatement(@NotNull UImportStatement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitImportStatement((UastVisitor)this, (UImportStatement)node);
                }

                public boolean visitInitializer(@NotNull UClassInitializer node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitInitializer((UastVisitor)this, (UClassInitializer)node);
                }

                public boolean visitLabeledExpression(@NotNull ULabeledExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
                }

                public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
                }

                public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
                }

                public boolean visitLocalVariable(@NotNull ULocalVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLocalVariable((UastVisitor)this, (ULocalVariable)node);
                }

                public boolean visitMethod(@NotNull UMethod node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitMethod((UastVisitor)this, (UMethod)node);
                }

                public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
                }

                public boolean visitParameter(@NotNull UParameter node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitParameter((UastVisitor)this, (UParameter)node);
                }

                public boolean visitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
                }

                public boolean visitPolyadicExpression(@NotNull UPolyadicExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
                }

                public boolean visitPostfixExpression(@NotNull UPostfixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
                }

                public boolean visitPrefixExpression(@NotNull UPrefixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
                }

                public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
                }

                public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitReturnExpression((UastVisitor)this, (UReturnExpression)node);
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
                }

                public boolean visitSuperExpression(@NotNull USuperExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSuperExpression((UastVisitor)this, (USuperExpression)node);
                }

                public boolean visitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
                }

                public boolean visitSwitchExpression(@NotNull USwitchExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
                }

                public boolean visitThisExpression(@NotNull UThisExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitThisExpression((UastVisitor)this, (UThisExpression)node);
                }

                public boolean visitThrowExpression(@NotNull UThrowExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitThrowExpression((UastVisitor)this, (UThrowExpression)node);
                }

                public boolean visitTryExpression(@NotNull UTryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitTryExpression((UastVisitor)this, (UTryExpression)node);
                }

                public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
                }

                public boolean visitUnaryExpression(@NotNull UUnaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
                }

                public boolean visitVariable(@NotNull UVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitVariable((UastVisitor)this, (UVariable)node);
                }

                public boolean visitWhileExpression(@NotNull UWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitWhileExpression((UastVisitor)this, (UWhileExpression)node);
                }
            });
            file.getPsi().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(parentMap){
                final /* synthetic */ Map $parentMap;

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    UElement uElement = ((UastContext)ServiceManager.getService((Project)element.getProject(), UastContext.class)).convertElementWithParent(element, null);
                    String expectedParents = (String)this.$parentMap.get(element);
                    if (expectedParents != null) {
                        TestCase.assertNotNull((String)("Expected to be able to convert PSI element " + element), (Object)uElement);
                        UElement uElement2 = uElement;
                        if (uElement2 == null) {
                            Intrinsics.throwNpe();
                        }
                        String parents2 = SequencesKt.joinToString$default((Sequence)SequencesKt.generateSequence((Object)uElement2.getUastParent(), (Function1)checkParentConsistency.visitElement.parents.1.INSTANCE), null, null, null, (int)0, null, (Function1)checkParentConsistency.visitElement.parents.2.INSTANCE, (int)31, null);
                        TestCase.assertEquals((String)("Inconsistent parents for " + uElement + " (converted from " + element + ") parent: -> " + uElement.getUastParent()), (String)expectedParents, (String)parents2);
                    }
                    super.visitElement(element);
                }
                {
                    this.$parentMap = $captured_local_variable$0;
                }
            });
        }

        public static void checkContainingFileForAllElements(RenderLogTestBase $this, @NotNull UFile $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            $receiver.accept(new UastVisitor($receiver){
                final /* synthetic */ UFile $this_checkContainingFileForAllElements;

                public boolean visitElement(@NotNull UElement node) {
                    PsiElement anchorPsi;
                    UElement uastAnchor;
                    UElement uElement;
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (node instanceof PsiElement) {
                        UElement uElement2 = UastContextKt.toUElement((PsiElement)node.getPsi());
                        if (uElement2 == null) {
                            Intrinsics.throwNpe();
                        }
                        UElement uElement3 = uElement2;
                        TestCase.assertEquals((String)("getContainingUFile should be equal to source for " + uElement3.getClass()), (Object)this.$this_checkContainingFileForAllElements, (Object)UastUtils.getContainingUFile((UElement)uElement3));
                    }
                    if (!((uElement = node) instanceof UDeclaration)) {
                        uElement = null;
                    }
                    UDeclaration uDeclaration = (UDeclaration)uElement;
                    Object object = uastAnchor = uDeclaration != null ? uDeclaration.getUastAnchor() : null;
                    if (uastAnchor != null) {
                        PsiElement psiElement = node.getSourcePsi();
                        String string = "should be appropriate sourcePsi for uastAnchor for " + ((UDeclaration)node).getClass() + " [" + (psiElement != null ? psiElement.getText() : null) + "] ";
                        PsiElement psiElement2 = UElementKt.getSourcePsiElement((UElement)node);
                        if (psiElement2 == null) {
                            Intrinsics.throwNpe();
                        }
                        PsiFile psiFile = psiElement2.getContainingFile();
                        if (psiFile == null) {
                            Intrinsics.throwNpe();
                        }
                        PsiElement psiElement3 = uastAnchor.getSourcePsi();
                        TestCase.assertEquals((String)string, (Object)psiFile, (Object)(psiElement3 != null ? psiElement3.getContainingFile() : null));
                    }
                    UElement uElement4 = uastAnchor;
                    Object object2 = anchorPsi = uElement4 != null ? uElement4.getPsi() : null;
                    if (anchorPsi != null) {
                        PsiFile psiFile = anchorPsi.getContainingFile();
                        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)node);
                        if (psiElement == null) {
                            Intrinsics.throwNpe();
                        }
                        PsiFile psiFile2 = psiElement.getContainingFile();
                        if (psiFile2 == null) {
                            Intrinsics.throwNpe();
                        }
                        TestCase.assertEquals((Object)psiFile, (Object)psiFile2);
                    }
                    return false;
                }
                {
                    this.$this_checkContainingFileForAllElements = $receiver;
                }

                public void afterVisitAnnotation(@NotNull UAnnotation node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitAnnotation((UastVisitor)this, (UAnnotation)node);
                }

                public void afterVisitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
                }

                public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
                }

                public void afterVisitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
                }

                public void afterVisitBlockExpression(@NotNull UBlockExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBlockExpression((UastVisitor)this, (UBlockExpression)node);
                }

                public void afterVisitBreakExpression(@NotNull UBreakExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitBreakExpression((UastVisitor)this, (UBreakExpression)node);
                }

                public void afterVisitCallExpression(@NotNull UCallExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitCallExpression((UastVisitor)this, (UCallExpression)node);
                }

                public void afterVisitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
                }

                public void afterVisitCatchClause(@NotNull UCatchClause node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitCatchClause((UastVisitor)this, (UCatchClause)node);
                }

                public void afterVisitClass(@NotNull UClass node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitClass((UastVisitor)this, (UClass)node);
                }

                public void afterVisitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
                }

                public void afterVisitContinueExpression(@NotNull UContinueExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitContinueExpression((UastVisitor)this, (UContinueExpression)node);
                }

                public void afterVisitDeclaration(@NotNull UDeclaration node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitDeclaration((UastVisitor)this, (UDeclaration)node);
                }

                public void afterVisitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
                }

                public void afterVisitDoWhileExpression(@NotNull UDoWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
                }

                public void afterVisitElement(@NotNull UElement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitElement((UastVisitor)this, (UElement)node);
                }

                public void afterVisitEnumConstant(@NotNull UEnumConstant node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitEnumConstant((UastVisitor)this, (UEnumConstant)node);
                }

                public void afterVisitExpression(@NotNull UExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitExpression((UastVisitor)this, (UExpression)node);
                }

                public void afterVisitExpressionList(@NotNull UExpressionList node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitExpressionList((UastVisitor)this, (UExpressionList)node);
                }

                public void afterVisitField(@NotNull UField node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitField((UastVisitor)this, (UField)node);
                }

                public void afterVisitFile(@NotNull UFile node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitFile((UastVisitor)this, (UFile)node);
                }

                public void afterVisitForEachExpression(@NotNull UForEachExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitForEachExpression((UastVisitor)this, (UForEachExpression)node);
                }

                public void afterVisitForExpression(@NotNull UForExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitForExpression((UastVisitor)this, (UForExpression)node);
                }

                public void afterVisitIfExpression(@NotNull UIfExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitIfExpression((UastVisitor)this, (UIfExpression)node);
                }

                public void afterVisitImportStatement(@NotNull UImportStatement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitImportStatement((UastVisitor)this, (UImportStatement)node);
                }

                public void afterVisitInitializer(@NotNull UClassInitializer node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitInitializer((UastVisitor)this, (UClassInitializer)node);
                }

                public void afterVisitLabeledExpression(@NotNull ULabeledExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
                }

                public void afterVisitLambdaExpression(@NotNull ULambdaExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
                }

                public void afterVisitLiteralExpression(@NotNull ULiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
                }

                public void afterVisitLocalVariable(@NotNull ULocalVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitLocalVariable((UastVisitor)this, (ULocalVariable)node);
                }

                public void afterVisitMethod(@NotNull UMethod node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitMethod((UastVisitor)this, (UMethod)node);
                }

                public void afterVisitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
                }

                public void afterVisitParameter(@NotNull UParameter node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitParameter((UastVisitor)this, (UParameter)node);
                }

                public void afterVisitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
                }

                public void afterVisitPolyadicExpression(@NotNull UPolyadicExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
                }

                public void afterVisitPostfixExpression(@NotNull UPostfixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
                }

                public void afterVisitPrefixExpression(@NotNull UPrefixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
                }

                public void afterVisitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
                }

                public void afterVisitReturnExpression(@NotNull UReturnExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitReturnExpression((UastVisitor)this, (UReturnExpression)node);
                }

                public void afterVisitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
                }

                public void afterVisitSuperExpression(@NotNull USuperExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSuperExpression((UastVisitor)this, (USuperExpression)node);
                }

                public void afterVisitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
                }

                public void afterVisitSwitchExpression(@NotNull USwitchExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
                }

                public void afterVisitThisExpression(@NotNull UThisExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitThisExpression((UastVisitor)this, (UThisExpression)node);
                }

                public void afterVisitThrowExpression(@NotNull UThrowExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitThrowExpression((UastVisitor)this, (UThrowExpression)node);
                }

                public void afterVisitTryExpression(@NotNull UTryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitTryExpression((UastVisitor)this, (UTryExpression)node);
                }

                public void afterVisitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
                }

                public void afterVisitUnaryExpression(@NotNull UUnaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
                }

                public void afterVisitVariable(@NotNull UVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitVariable((UastVisitor)this, (UVariable)node);
                }

                public void afterVisitWhileExpression(@NotNull UWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UastVisitor.DefaultImpls.afterVisitWhileExpression((UastVisitor)this, (UWhileExpression)node);
                }

                public boolean visitAnnotation(@NotNull UAnnotation node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitAnnotation((UastVisitor)this, (UAnnotation)node);
                }

                public boolean visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
                }

                public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
                }

                public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
                }

                public boolean visitBlockExpression(@NotNull UBlockExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBlockExpression((UastVisitor)this, (UBlockExpression)node);
                }

                public boolean visitBreakExpression(@NotNull UBreakExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitBreakExpression((UastVisitor)this, (UBreakExpression)node);
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitCallExpression((UastVisitor)this, (UCallExpression)node);
                }

                public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
                }

                public boolean visitCatchClause(@NotNull UCatchClause node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitCatchClause((UastVisitor)this, (UCatchClause)node);
                }

                public boolean visitClass(@NotNull UClass node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitClass((UastVisitor)this, (UClass)node);
                }

                public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
                }

                public boolean visitContinueExpression(@NotNull UContinueExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitContinueExpression((UastVisitor)this, (UContinueExpression)node);
                }

                public boolean visitDeclaration(@NotNull UDeclaration node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitDeclaration((UastVisitor)this, (UDeclaration)node);
                }

                public boolean visitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
                }

                public boolean visitDoWhileExpression(@NotNull UDoWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
                }

                public boolean visitEnumConstant(@NotNull UEnumConstant node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitEnumConstant((UastVisitor)this, (UEnumConstant)node);
                }

                public boolean visitExpression(@NotNull UExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitExpression((UastVisitor)this, (UExpression)node);
                }

                public boolean visitExpressionList(@NotNull UExpressionList node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitExpressionList((UastVisitor)this, (UExpressionList)node);
                }

                public boolean visitField(@NotNull UField node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitField((UastVisitor)this, (UField)node);
                }

                public boolean visitFile(@NotNull UFile node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitFile((UastVisitor)this, (UFile)node);
                }

                public boolean visitForEachExpression(@NotNull UForEachExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitForEachExpression((UastVisitor)this, (UForEachExpression)node);
                }

                public boolean visitForExpression(@NotNull UForExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitForExpression((UastVisitor)this, (UForExpression)node);
                }

                public boolean visitIfExpression(@NotNull UIfExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitIfExpression((UastVisitor)this, (UIfExpression)node);
                }

                public boolean visitImportStatement(@NotNull UImportStatement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitImportStatement((UastVisitor)this, (UImportStatement)node);
                }

                public boolean visitInitializer(@NotNull UClassInitializer node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitInitializer((UastVisitor)this, (UClassInitializer)node);
                }

                public boolean visitLabeledExpression(@NotNull ULabeledExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
                }

                public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
                }

                public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
                }

                public boolean visitLocalVariable(@NotNull ULocalVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitLocalVariable((UastVisitor)this, (ULocalVariable)node);
                }

                public boolean visitMethod(@NotNull UMethod node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitMethod((UastVisitor)this, (UMethod)node);
                }

                public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
                }

                public boolean visitParameter(@NotNull UParameter node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitParameter((UastVisitor)this, (UParameter)node);
                }

                public boolean visitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
                }

                public boolean visitPolyadicExpression(@NotNull UPolyadicExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
                }

                public boolean visitPostfixExpression(@NotNull UPostfixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
                }

                public boolean visitPrefixExpression(@NotNull UPrefixExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
                }

                public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
                }

                public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitReturnExpression((UastVisitor)this, (UReturnExpression)node);
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
                }

                public boolean visitSuperExpression(@NotNull USuperExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSuperExpression((UastVisitor)this, (USuperExpression)node);
                }

                public boolean visitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
                }

                public boolean visitSwitchExpression(@NotNull USwitchExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
                }

                public boolean visitThisExpression(@NotNull UThisExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitThisExpression((UastVisitor)this, (UThisExpression)node);
                }

                public boolean visitThrowExpression(@NotNull UThrowExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitThrowExpression((UastVisitor)this, (UThrowExpression)node);
                }

                public boolean visitTryExpression(@NotNull UTryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitTryExpression((UastVisitor)this, (UTryExpression)node);
                }

                public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
                }

                public boolean visitUnaryExpression(@NotNull UUnaryExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
                }

                public boolean visitVariable(@NotNull UVariable node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitVariable((UastVisitor)this, (UVariable)node);
                }

                public boolean visitWhileExpression(@NotNull UWhileExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    return UastVisitor.DefaultImpls.visitWhileExpression((UastVisitor)this, (UWhileExpression)node);
                }
            });
        }
    }
}

