/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionFilter
implements Filter,
DumbAware {
    private static final String EXCEPTION_IN_THREAD = "Exception in thread \"";
    private static final String CAUSED_BY = "Caused by: ";
    private final ExceptionInfoCache myCache;
    private PsiElementFilter myNextLineRefiner;

    public ExceptionFilter(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ExceptionFilter.$$$reportNull$$$0(0);
        }
        this.myCache = new ExceptionInfoCache(scope);
    }

    public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
        ExceptionWorker worker;
        Filter.Result result;
        if (line == null) {
            ExceptionFilter.$$$reportNull$$$0(1);
        }
        this.myNextLineRefiner = (result = (worker = new ExceptionWorker(this.myCache)).execute(line, textEndOffset, this.myNextLineRefiner)) == null ? ExceptionFilter.getRefinerFromException(line) : worker.getLocationRefiner();
        return result;
    }

    private static PsiElementFilter getRefinerFromException(@NotNull String line) {
        String exceptionName;
        if (line == null) {
            ExceptionFilter.$$$reportNull$$$0(2);
        }
        if ((exceptionName = ExceptionFilter.getExceptionFromMessage(line)) == null) {
            return null;
        }
        PsiElementFilter exceptionCreationFilter = e -> {
            if (!(e instanceof PsiKeyword) || !e.textMatches((CharSequence)"new")) {
                return false;
            }
            PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiNewExpression.class);
            if (newExpression == null) {
                return false;
            }
            PsiType type = newExpression.getType();
            return type != null && type.equalsToText(exceptionName);
        };
        PsiElementFilter specificFilter = ExceptionFilter.getExceptionSpecificFilter(exceptionName);
        if (specificFilter == null) {
            return exceptionCreationFilter;
        }
        return element -> exceptionCreationFilter.isAccepted(element) || specificFilter.isAccepted(element);
    }

    @Nullable
    private static PsiElementFilter getExceptionSpecificFilter(String exceptionName) {
        switch (exceptionName) {
            case "java.lang.ArrayIndexOutOfBoundsException": {
                return e -> e instanceof PsiJavaToken && e.textMatches((CharSequence)"[") && e.getParent() instanceof PsiArrayAccessExpression;
            }
            case "java.lang.ArrayStoreException": {
                return e -> {
                    if (e instanceof PsiJavaToken && e.textMatches((CharSequence)"=") && e.getParent() instanceof PsiAssignmentExpression) {
                        PsiExpression lExpression = ((PsiAssignmentExpression)e.getParent()).getLExpression();
                        return PsiUtil.skipParenthesizedExprDown((PsiExpression)lExpression) instanceof PsiArrayAccessExpression;
                    }
                    return false;
                };
            }
            case "java.lang.AssertionError": {
                return e -> e instanceof PsiKeyword && e.textMatches((CharSequence)"assert");
            }
            case "java.lang.ArithmeticException": {
                return e -> {
                    if (e instanceof PsiJavaToken && (e.textMatches((CharSequence)"%") || e.textMatches((CharSequence)"/")) && e.getParent() instanceof PsiPolyadicExpression) {
                        PsiExpression prevOperand = (PsiExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)e, PsiExpression.class);
                        PsiExpression nextOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)e, PsiExpression.class)));
                        if (prevOperand != null && TypeConversionUtil.isIntegralNumberType((PsiType)prevOperand.getType()) && nextOperand != null && TypeConversionUtil.isIntegralNumberType((PsiType)nextOperand.getType())) {
                            Object value;
                            while (nextOperand instanceof PsiUnaryExpression && ((PsiUnaryExpression)nextOperand).getOperationTokenType().equals(JavaTokenType.MINUS)) {
                                nextOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiUnaryExpression)nextOperand).getOperand());
                            }
                            return !(nextOperand instanceof PsiLiteral) || !((value = ((PsiLiteral)nextOperand).getValue()) instanceof Number) || ((Number)value).longValue() == 0L;
                        }
                    }
                    return false;
                };
            }
            case "java.lang.NegativeArraySizeException": {
                return e -> {
                    if (e instanceof PsiKeyword && e.textMatches((CharSequence)"new") && e.getParent() instanceof PsiNewExpression) {
                        PsiExpression[] dimensions;
                        for (PsiExpression dimension : dimensions = ((PsiNewExpression)e.getParent()).getArrayDimensions()) {
                            PsiLiteral literal;
                            if (dimension != null && (literal = (PsiLiteral)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)dimension), PsiLiteral.class)) != null && literal.getValue() instanceof Integer) continue;
                            return true;
                        }
                    }
                    return false;
                };
            }
        }
        return null;
    }

    @Nullable
    private static String getExceptionFromMessage(String line) {
        int firstSpace = line.indexOf(32);
        if (firstSpace == -1) {
            return ExceptionFilter.getExceptionFromMessage(line, 0, ExceptionFilter.getLength(line));
        }
        if (firstSpace == "Caused".length() && line.startsWith(CAUSED_BY)) {
            int colonPos = line.indexOf(58, CAUSED_BY.length());
            return ExceptionFilter.getExceptionFromMessage(line, CAUSED_BY.length(), colonPos == -1 ? ExceptionFilter.getLength(line) : colonPos);
        }
        if (firstSpace == "Exception".length() && line.startsWith(EXCEPTION_IN_THREAD)) {
            int start;
            int nextQuotePos = line.indexOf("\" ", EXCEPTION_IN_THREAD.length());
            if (nextQuotePos == -1) {
                return null;
            }
            int colonPos = line.indexOf(58, start = nextQuotePos + "\" ".length());
            return ExceptionFilter.getExceptionFromMessage(line, start, colonPos == -1 ? ExceptionFilter.getLength(line) : colonPos);
        }
        if (firstSpace > 2 && line.charAt(firstSpace - 1) == ':') {
            return ExceptionFilter.getExceptionFromMessage(line, 0, firstSpace - 1);
        }
        return null;
    }

    private static int getLength(String line) {
        int length;
        for (length = line.length(); length > 2 && Character.isWhitespace(line.charAt(length - 1)); --length) {
        }
        return length;
    }

    private static String getExceptionFromMessage(String line, int from, int to) {
        if (to - from > 200) {
            return null;
        }
        boolean hasDot = false;
        for (int i = from; i < to; ++i) {
            char c = line.charAt(i);
            if (c != '.' && !Character.isJavaIdentifierPart(c)) {
                return null;
            }
            hasDot |= c == '.';
        }
        if (!hasDot) {
            return null;
        }
        return line.substring(from, to);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/ExceptionFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefinerFromException";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

