/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheVersion;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManager;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributes;
import org.jetbrains.kotlin.jps.incremental.LookupsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "rootPath", "Ljava/io/File;", "expectedComponents", "", "", "(Ljava/io/File;Ljava/util/Set;)V", "actualComponentsFile", "expected", "getExpected", "()Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "versionManager", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "versionManagerForTesting", "getVersionManagerForTesting", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "isCompatible", "", "actual", "loadActual", "writeVersion", "", "values", "jps-plugin"})
public final class CompositeLookupsCacheAttributesManager
implements CacheAttributesManager<CompositeLookupsCacheAttributes> {
    private final CacheVersionManager versionManager;
    private final File actualComponentsFile;
    @Nullable
    private final CompositeLookupsCacheAttributes expected;

    @Override
    @Nullable
    public CompositeLookupsCacheAttributes getExpected() {
        return this.expected;
    }

    @Override
    @Nullable
    public CompositeLookupsCacheAttributes loadActual() {
        Set set;
        CacheVersion cacheVersion = this.versionManager.loadActual();
        if (cacheVersion == null) {
            return null;
        }
        CacheVersion version = cacheVersion;
        if (!this.actualComponentsFile.exists()) {
            return null;
        }
        try {
            set = CollectionsKt.toSet((Iterable)FilesKt.readLines$default((File)this.actualComponentsFile, null, (int)1, null));
        }
        catch (IOException e) {
            return null;
        }
        Set components = set;
        return new CompositeLookupsCacheAttributes(version.getVersion(), components);
    }

    @Override
    public void writeVersion(@Nullable CompositeLookupsCacheAttributes values) {
        if (values == null) {
            this.versionManager.writeVersion(null);
            this.actualComponentsFile.delete();
        } else {
            this.versionManager.writeVersion(new CacheVersion(values.getVersion()));
            this.actualComponentsFile.getParentFile().mkdirs();
            FilesKt.writeText$default((File)this.actualComponentsFile, (String)CollectionsKt.joinToString$default((Iterable)values.getComponents(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
        }
    }

    @Override
    public boolean isCompatible(@NotNull CompositeLookupsCacheAttributes actual, @NotNull CompositeLookupsCacheAttributes expected) {
        Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return actual.getVersion() == expected.getVersion() && actual.getComponents().containsAll((Collection)expected.getComponents());
    }

    @NotNull
    public final CacheVersionManager getVersionManagerForTesting() {
        return this.versionManager;
    }

    public CompositeLookupsCacheAttributesManager(@NotNull File rootPath, @NotNull Set<String> expectedComponents) {
        CompositeLookupsCacheAttributes compositeLookupsCacheAttributes;
        Intrinsics.checkParameterIsNotNull((Object)rootPath, (String)"rootPath");
        Intrinsics.checkParameterIsNotNull(expectedComponents, (String)"expectedComponents");
        Collection collection = expectedComponents;
        File file = rootPath;
        CompositeLookupsCacheAttributesManager compositeLookupsCacheAttributesManager = this;
        boolean bl = !collection.isEmpty();
        compositeLookupsCacheAttributesManager.versionManager = LookupsKt.lookupsCacheVersionManager(file, bl);
        this.actualComponentsFile = new File(rootPath, "components.txt");
        if (expectedComponents.isEmpty()) {
            compositeLookupsCacheAttributes = null;
        } else {
            CacheVersion cacheVersion = this.versionManager.getExpected();
            if (cacheVersion == null) {
                Intrinsics.throwNpe();
            }
            compositeLookupsCacheAttributes = new CompositeLookupsCacheAttributes(cacheVersion.getVersion(), expectedComponents);
        }
        this.expected = compositeLookupsCacheAttributes;
    }
}

