/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSmartStepIntoHandler;", "Lcom/intellij/debugger/actions/JvmSmartStepIntoHandler;", "()V", "methods", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods;", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "stepTarget", "Lcom/intellij/debugger/actions/SmartStepTarget;", "findSmartStepTargets", "", "position", "Lcom/intellij/debugger/SourcePosition;", "isAvailable", "", "isIntrinsic", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isInvokeInBuiltinFunction", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "idea-jvm"})
public final class KotlinSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    private final IntrinsicMethods methods = new IntrinsicMethods(JvmTarget.JVM_1_6);

    public boolean isAvailable(@Nullable SourcePosition position2) {
        SourcePosition sourcePosition = position2;
        return (sourcePosition != null ? sourcePosition.getFile() : null) instanceof KtFile;
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(@NotNull SourcePosition position2) {
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        PsiFile psiFile = position2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"position.file");
        PsiFile file2 = psiFile;
        PsiElement psiElement = position2.getElementAt();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement elementAtOffset = psiElement;
        TextRange textRange = elementAtOffset.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"elementAtOffset.textRange");
        PsiElement psiElement2 = CodeInsightUtils.getTopmostElementAtOffset((PsiElement)elementAtOffset, (int)textRange.getStartOffset());
        if (!(psiElement2 instanceof KtElement)) {
            psiElement2 = null;
        }
        KtElement ktElement = (KtElement)psiElement2;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement element = ktElement;
        TextRange textRange2 = element.getTextRange();
        if (textRange2 == null) {
            return CollectionsKt.emptyList();
        }
        TextRange elementTextRange = textRange2;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"PsiDocumentManager.getIn\u2026le) ?: return emptyList()");
        Document doc = document;
        Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getEndOffset())));
        BindingContext bindingContext2 = ResolutionUtils.analyzeWithAllCompilerChecks((KtElement)element).getBindingContext();
        OrderedSet result2 = new OrderedSet();
        element.accept((KtVisitor)new KtTreeVisitorVoid(this, result2, lines, bindingContext2, file2){
            final /* synthetic */ KotlinSmartStepIntoHandler this$0;
            final /* synthetic */ OrderedSet $result;
            final /* synthetic */ Range $lines;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ PsiFile $file;

            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
                Intrinsics.checkParameterIsNotNull((Object)lambdaExpression, (String)"lambdaExpression");
                KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
                this.recordFunctionLiteral((KtFunction)ktFunctionLiteral);
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function) {
                Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
                if (!this.recordFunctionLiteral((KtFunction)function)) {
                    super.visitNamedFunction(function);
                }
            }

            private final boolean recordFunctionLiteral(KtFunction function) {
                BindingContext context = ResolutionUtils.analyze$default((KtElement)((KtElement)function), null, (int)1, null);
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((Call)CallUtilKt.getParentCall$default((KtElement)((KtElement)function), (BindingContext)context, (boolean)false, (int)2, null), (BindingContext)context);
                if (resolvedCall != null) {
                    Map arguments2;
                    Map map2 = resolvedCall.getValueArguments();
                    Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"resolvedCall.valueArguments");
                    Map map3 = arguments2 = map2;
                    Iterator<Map.Entry<K, V>> iterator = map3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        boolean bl;
                        ValueParameterDescriptor param;
                        block5: {
                            ResolvedValueArgument argument;
                            Map.Entry<K, V> entry;
                            Map.Entry<K, V> entry2 = entry = iterator.next();
                            param = (ValueParameterDescriptor)entry2.getKey();
                            entry2 = entry;
                            ResolvedValueArgument resolvedValueArgument = argument = (ResolvedValueArgument)entry2.getValue();
                            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"argument");
                            List list2 = resolvedValueArgument.getArguments();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"argument.arguments");
                            Iterable $receiver$iv = list2;
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $receiver$iv) {
                                    ValueArgument it;
                                    ValueArgument valueArgument = it = (ValueArgument)element$iv;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"it");
                                    if (!Intrinsics.areEqual((Object)this.getArgumentExpression(valueArgument), (Object)function)) continue;
                                    bl = true;
                                    break block5;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
                        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)resultingDescriptor;
                        ValueParameterDescriptor valueParameterDescriptor = param;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"param");
                        Name name = valueParameterDescriptor.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"param.name");
                        String label2 = KotlinLambdaSmartStepTarget.Companion.calcLabel(declarationDescriptor, name);
                        boolean bl2 = InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)resultingDescriptor));
                        KotlinType kotlinType = param.getType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"param.type");
                        this.$result.add((Object)((Object)new KotlinLambdaSmartStepTarget(label2, function, (Range<Integer>)this.$lines, bl2, FunctionTypesKt.isSuspendFunctionType((KotlinType)kotlinType))));
                        return true;
                    }
                }
                return false;
            }

            private final KtExpression getArgumentExpression(ValueArgument it) {
                KtLambdaExpression ktLambdaExpression;
                KtExpression ktExpression = it.getArgumentExpression();
                if (!(ktExpression instanceof KtLambdaExpression)) {
                    ktExpression = null;
                }
                return (ktLambdaExpression = (KtLambdaExpression)ktExpression) != null && (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) != null ? (KtExpression)ktLambdaExpression : it.getArgumentExpression();
            }

            public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            }

            public void visitIfExpression(@NotNull KtIfExpression expression) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    KtExpression ktExpression = expression.getCondition();
                    if (ktExpression == null) break block0;
                    ktExpression.accept((PsiElementVisitor)this);
                }
            }

            public void visitWhileExpression(@NotNull KtWhileExpression expression) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    KtExpression ktExpression = expression.getCondition();
                    if (ktExpression == null) break block0;
                    ktExpression.accept((PsiElementVisitor)this);
                }
            }

            public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    KtExpression ktExpression = expression.getCondition();
                    if (ktExpression == null) break block0;
                    ktExpression.accept((PsiElementVisitor)this);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    KtExpression ktExpression = expression.getLoopRange();
                    if (ktExpression == null) break block0;
                    ktExpression.accept((PsiElementVisitor)this);
                }
            }

            public void visitWhenExpression(@NotNull KtWhenExpression expression) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    KtExpression ktExpression = expression.getSubjectExpression();
                    if (ktExpression == null) break block0;
                    ktExpression.accept((PsiElementVisitor)this);
                }
            }

            public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                this.recordFunction((KtExpression)expression);
                super.visitArrayAccessExpression(expression);
            }

            public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
                this.recordFunction((KtExpression)ktSimpleNameExpression);
                super.visitUnaryExpression(expression);
            }

            public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                this.recordFunction((KtExpression)ktOperationReferenceExpression);
                super.visitBinaryExpression(expression);
            }

            public void visitCallExpression(@NotNull KtCallExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                KtExpression calleeExpression = expression.getCalleeExpression();
                if (calleeExpression != null) {
                    this.recordFunction(calleeExpression);
                }
                super.visitCallExpression(expression);
            }

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                this.recordGetter(expression);
                super.visitSimpleNameExpression(expression);
            }

            private final void recordGetter(KtSimpleNameExpression expression) {
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.$bindingContext);
                if (resolvedCall == null) {
                    return;
                }
                ResolvedCall resolvedCall2 = resolvedCall;
                CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
                if (!(callableDescriptor instanceof PropertyDescriptor)) {
                    callableDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)callableDescriptor;
                if (propertyDescriptor == null) {
                    return;
                }
                PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
                PropertyGetterDescriptor getterDescriptor = propertyDescriptor2.getGetter();
                if (getterDescriptor == null || getterDescriptor.isDefault()) {
                    return;
                }
                Project project = this.$file.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                PsiElement psiElement = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, (DeclarationDescriptor)getterDescriptor);
                if (!(psiElement instanceof KtDeclaration)) {
                    psiElement = null;
                }
                KtDeclaration ktDeclaration = (KtDeclaration)psiElement;
                if (ktDeclaration == null) {
                    return;
                }
                KtDeclaration ktDeclaration2 = ktDeclaration;
                ResolvedCall delegatedResolvedCall = (ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)getterDescriptor);
                if (delegatedResolvedCall != null) {
                    CallableDescriptor callableDescriptor2 = delegatedResolvedCall.getResultingDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor2, (String)"delegatedResolvedCall.resultingDescriptor");
                    FunctionDescriptor delegatedPropertyGetterDescriptor = (FunctionDescriptor)callableDescriptor2;
                    String label2 = propertyDescriptor2.getName() + '.' + KotlinMethodSmartStepTarget.Companion.calcLabel((DeclarationDescriptor)delegatedPropertyGetterDescriptor);
                    this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((CallableMemberDescriptor)delegatedPropertyGetterDescriptor, ktDeclaration2, label2, (PsiElement)expression, (Range<Integer>)this.$lines)));
                } else if (ktDeclaration2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)ktDeclaration2).hasBody()) {
                    String label3 = KotlinMethodSmartStepTarget.Companion.calcLabel((DeclarationDescriptor)getterDescriptor);
                    this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((CallableMemberDescriptor)getterDescriptor, ktDeclaration2, label3, (PsiElement)expression, (Range<Integer>)this.$lines)));
                }
            }

            private final void recordFunction(KtExpression expression) {
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.$bindingContext);
                if (resolvedCall == null) {
                    return;
                }
                ResolvedCall resolvedCall2 = resolvedCall;
                CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
                if (!(descriptor2 instanceof FunctionDescriptor) || KotlinSmartStepIntoHandler.access$isIntrinsic(this.this$0, (CallableMemberDescriptor)descriptor2)) {
                    return;
                }
                Project project = this.$file.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, (DeclarationDescriptor)descriptor2);
                if (SpecialBuiltinMembers.isFromJava((CallableMemberDescriptor)((CallableMemberDescriptor)descriptor2))) {
                    PsiElement psiElement = declaration2;
                    if (!(psiElement instanceof PsiMethod)) {
                        psiElement = null;
                    }
                    PsiMethod psiMethod = (PsiMethod)psiElement;
                    if (psiMethod != null) {
                        PsiMethod psiMethod2;
                        PsiMethod it = psiMethod2 = psiMethod;
                        this.$result.add((Object)new MethodSmartStepTarget(it, null, declaration2, false, this.$lines));
                    }
                } else {
                    KtExpression ktExpression;
                    if (declaration2 == null && !KotlinSmartStepIntoHandler.access$isInvokeInBuiltinFunction(this.this$0, (DeclarationDescriptor)descriptor2)) {
                        return;
                    }
                    PsiElement psiElement = declaration2;
                    if (!(psiElement != null ? psiElement instanceof KtDeclaration : true)) {
                        return;
                    }
                    if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary() && declaration2 instanceof KtClass && ((KtClass)declaration2).getAnonymousInitializers().isEmpty()) {
                        return;
                    }
                    String callLabel = KotlinMethodSmartStepTarget.Companion.calcLabel((DeclarationDescriptor)descriptor2);
                    CallableDescriptor callableDescriptor = descriptor2;
                    String label2 = callableDescriptor instanceof FunctionInvokeDescriptor ? ((ktExpression = expression) instanceof KtSimpleNameExpression ? (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(expression){
                        final /* synthetic */ KtExpression $expression;

                        public final String invoke() {
                            return ((KtSimpleNameExpression)this.$expression).getText();
                        }
                        {
                            this.$expression = ktExpression;
                            super(0);
                        }
                    })) + '.' + callLabel : callLabel) : callLabel;
                    this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((CallableMemberDescriptor)descriptor2, (KtDeclaration)declaration2, label2, (PsiElement)expression, (Range<Integer>)this.$lines)));
                }
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
                this.$lines = $captured_local_variable$2;
                this.$bindingContext = $captured_local_variable$3;
                this.$file = $captured_local_variable$4;
            }
        }, null);
        return (List)result2;
    }

    @Nullable
    protected MethodFilter createMethodFilter(@Nullable SmartStepTarget stepTarget) {
        MethodFilter methodFilter;
        SmartStepTarget smartStepTarget = stepTarget;
        if (smartStepTarget instanceof KotlinMethodSmartStepTarget) {
            KtDeclaration ktDeclaration = ((KotlinMethodSmartStepTarget)stepTarget).getDeclaration();
            Object object = ktDeclaration != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktDeclaration)) : null;
            boolean bl = ((KotlinMethodSmartStepTarget)stepTarget).isInvoke();
            String string = ((KotlinMethodSmartStepTarget)stepTarget).getTargetMethodName();
            Range range = ((KotlinMethodSmartStepTarget)stepTarget).getCallingExpressionLines();
            if (range == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"stepTarget.callingExpressionLines!!");
            methodFilter = (MethodFilter)new KotlinBasicStepMethodFilter((SmartPsiElementPointer<KtDeclaration>)object, bl, string, (Range<Integer>)range);
        } else if (smartStepTarget instanceof KotlinLambdaSmartStepTarget) {
            KtFunction ktFunction = ((KotlinLambdaSmartStepTarget)stepTarget).getLambda();
            Range range = ((KotlinLambdaSmartStepTarget)stepTarget).getCallingExpressionLines();
            if (range == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"stepTarget.callingExpressionLines!!");
            methodFilter = (MethodFilter)new KotlinLambdaMethodFilter(ktFunction, (Range<Integer>)range, ((KotlinLambdaSmartStepTarget)stepTarget).isInline(), ((KotlinLambdaSmartStepTarget)stepTarget).isSuspend());
        } else {
            methodFilter = super.createMethodFilter(stepTarget);
        }
        return methodFilter;
    }

    private final boolean isIntrinsic(CallableMemberDescriptor descriptor2) {
        return this.methods.getIntrinsic(descriptor2) != null;
    }

    private final boolean isInvokeInBuiltinFunction(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof FunctionInvokeDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((FunctionInvokeDescriptor)descriptor2).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        SimpleType simpleType = classDescriptor2.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"classDescriptor.defaultType");
        return FunctionTypesKt.isBuiltinFunctionalType((KotlinType)((KotlinType)simpleType));
    }

    public static final /* synthetic */ boolean access$isIntrinsic(KotlinSmartStepIntoHandler $this, CallableMemberDescriptor descriptor2) {
        return $this.isIntrinsic(descriptor2);
    }

    public static final /* synthetic */ boolean access$isInvokeInBuiltinFunction(KotlinSmartStepIntoHandler $this, DeclarationDescriptor descriptor2) {
        return $this.isInvokeInBuiltinFunction(descriptor2);
    }
}

