/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\t\u00a8\u0006\n"}, d2={"callName", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "previousCall", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "resolveType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea-jvm"})
public final class KotlinPsiUtilKt {
    @NotNull
    public static final KotlinType resolveType(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        KotlinType kotlinType = ResolutionUtils.analyze((KtElement)((KtElement)$receiver), (BodyResolveMode)BodyResolveMode.PARTIAL).getType($receiver);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        return kotlinType;
    }

    @NotNull
    public static final String callName(@NotNull KtCallExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        KtExpression ktExpression = $receiver.getCalleeExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"this.calleeExpression!!");
        String string = ktExpression.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.calleeExpression!!.text");
        return string;
    }

    @Nullable
    public static final ReceiverValue receiverValue(@NotNull KtCallExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$receiver), (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)$receiver), (BodyResolveMode)BodyResolveMode.PARTIAL));
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
        if (receiverValue == null) {
            receiverValue = resolvedCall2.getExtensionReceiver();
        }
        return receiverValue;
    }

    @Nullable
    public static final KtCallExpression previousCall(@NotNull KtCallExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElement psiElement = $receiver.getParent();
        if (!(psiElement instanceof KtDotQualifiedExpression)) {
            psiElement = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression parent = ktDotQualifiedExpression;
        KtExpression receiverExpression = parent.getReceiverExpression();
        if (receiverExpression instanceof KtCallExpression) {
            return (KtCallExpression)receiverExpression;
        }
        if (receiverExpression instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression = ((KtDotQualifiedExpression)receiverExpression).getSelectorExpression();
            if (!(ktExpression instanceof KtCallExpression)) {
                ktExpression = null;
            }
            return (KtCallExpression)ktExpression;
        }
        return null;
    }

    @Nullable
    public static final KotlinType receiverType(@NotNull KtCallExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ReceiverValue receiverValue = KotlinPsiUtilKt.receiverValue($receiver);
        return receiverValue != null ? receiverValue.getType() : null;
    }
}

