/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.ProjectTopics;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.OutdatedBundledCompilerNotificationKt;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isSyncing", "", "()Z", "notificationPostponed", "getProject", "()Lcom/intellij/openapi/project/Project;", "syncDepth", "Ljava/util/concurrent/atomic/AtomicInteger;", "performProjectPostOpenActions", "", "projectOpened", "syncDone", "syncStarted", "Companion", "idea-jvm"})
public final class KotlinConfigurationCheckerComponent
implements ProjectComponent {
    private final AtomicInteger syncDepth;
    private volatile boolean notificationPostponed;
    @NotNull
    private final Project project;
    @NotNull
    public static final String CONFIGURE_NOTIFICATION_GROUP_ID = "Configure Kotlin in Project";
    public static final Companion Companion = new Companion(null);

    public void projectOpened() {
        super.projectOpened();
        StartupManager.getInstance((Project)this.project).registerPostStartupActivity(new Runnable(this){
            final /* synthetic */ KotlinConfigurationCheckerComponent this$0;

            public final void run() {
                this.this$0.performProjectPostOpenActions();
            }
            {
                this.this$0 = kotlinConfigurationCheckerComponent;
            }
        });
    }

    public final void performProjectPostOpenActions() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ KotlinConfigurationCheckerComponent this$0;

            public final void run() {
                DumbService.getInstance((Project)this.this$0.getProject()).waitForSmartMode();
                for (Module module : ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(this.this$0.getProject())) {
                    PlatformKt.getAndCacheLanguageLevelByDependencies((Module)module);
                }
                if (!this.this$0.isSyncing()) {
                    List<VersionedLibrary> libraries = OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(this.this$0.getProject());
                    List<Module> excludeModules = OutdatedKotlinRuntimeCheckerKt.collectModulesWithOutdatedRuntime(libraries);
                    ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(this.this$0.getProject(), excludeModules);
                } else {
                    KotlinConfigurationCheckerComponent.access$setNotificationPostponed$p(this.this$0, true);
                }
            }
            {
                this.this$0 = kotlinConfigurationCheckerComponent;
            }
        });
    }

    public final boolean isSyncing() {
        return this.syncDepth.get() > 0;
    }

    public final void syncStarted() {
        this.syncDepth.incrementAndGet();
    }

    public final void syncDone() {
        this.syncDepth.decrementAndGet();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConfigurationCheckerComponent(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.syncDepth = new AtomicInteger();
        NotificationsConfiguration.getNotificationsConfiguration().register(CONFIGURE_NOTIFICATION_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (!this.getProject().isInitialized()) {
                    return;
                }
                if (notificationPostponed && !this.isSyncing()) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                        final /* synthetic */ 1 this$0;

                        public final void run() {
                            DumbService.getInstance((Project)this.this$0.this.getProject()).waitForSmartMode();
                            if (!this.this$0.this.isSyncing()) {
                                KotlinConfigurationCheckerComponent.access$setNotificationPostponed$p(this.this$0.this, false);
                                ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(this.this$0.this.getProject(), OutdatedKotlinRuntimeCheckerKt.collectModulesWithOutdatedRuntime(OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(this.this$0.this.getProject())));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(this.getProject());
            }
        });
        connection.subscribe(ProjectDataImportListener.TOPIC, (Object)new ProjectDataImportListener(){

            public final void onImportFinished(String it) {
                OutdatedBundledCompilerNotificationKt.notifyOutdatedBundledCompilerIfNecessary((Project)this.getProject());
            }
        });
        NewCodeStyleNotificationKt.notifyKotlinStyleUpdateIfNeeded(this.project);
    }

    public static final /* synthetic */ void access$setNotificationPostponed$p(KotlinConfigurationCheckerComponent $this, boolean bl) {
        $this.notificationPostponed = bl;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent$Companion;", "", "()V", "CONFIGURE_NOTIFICATION_GROUP_ID", "", "getInstance", "Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerComponent;", "project", "Lcom/intellij/openapi/project/Project;", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final KotlinConfigurationCheckerComponent getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getComponent(KotlinConfigurationCheckerComponent.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.getComponent(Kot\u2026kerComponent::class.java)");
            return (KotlinConfigurationCheckerComponent)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

