/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public class ReplClassLoader
extends ClassLoader {
    private final Map<JvmClassName, byte[]> classes = Maps.newLinkedHashMap();

    public ReplClassLoader(@NotNull ClassLoader parent) {
        super(parent);
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        byte[] classBytes = this.classes.get(JvmClassName.byFqNameWithoutInnerClasses((String)name));
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return super.findClass(name);
    }

    public void addClass(@NotNull JvmClassName className, @NotNull byte[] bytes) {
        byte[] oldBytes = this.classes.put(className, bytes);
        if (oldBytes != null) {
            throw new IllegalStateException("Rewrite at key " + className);
        }
    }

    public void dumpClasses(@NotNull PrintWriter writer) {
        for (byte[] classBytes : this.classes.values()) {
            new ClassReader(classBytes).accept((ClassVisitor)new TraceClassVisitor(writer), 0);
        }
    }
}

