/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestEnumValuesFix
implements LocalQuickFix,
BatchQuickFix<CommonProblemDescriptor> {
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public SuggestEnumValuesFix(JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Replace with allowed value" == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(0);
        }
        return "Replace with allowed value";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(3);
        }
        PsiElement initialElement = descriptor.getPsiElement();
        PsiElement element = this.myQuickFixAdapter.adjustValue(initialElement);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(element.getContainingFile().getVirtualFile());
        boolean whitespaceBefore = false;
        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
            whitespaceBefore = true;
        }
        WriteAction.run(() -> element.delete());
        EditorEx editor = EditorUtil.getEditorEx(fileEditor);
        assert (editor != null);
        if (this.myQuickFixAdapter.fixWhitespaceBefore(initialElement, element) && whitespaceBefore) {
            WriteAction.run(() -> {
                int offset = editor.getCaretModel().getOffset();
                editor.getDocument().insertString(offset, " ");
                editor.getCaretModel().moveToOffset(offset + 1);
            });
        }
        CodeCompletionHandlerBase.createHandler(CompletionType.BASIC).invokeCompletion(project, editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        Editor editor;
        if (project == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(5);
        }
        if (psiElementsToIgnore == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(6);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
            HintManager.getInstance().showErrorHint(editor, "Sorry, this fix is not available in batch mode");
        } else {
            Messages.showErrorDialog((Project)project, (String)"Sorry, this fix is not available in batch mode", (String)"Not Applicable in Batch Mode");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

