/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonErrorPriority;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.fixes.AddMissingPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.RemoveProhibitedPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.SuggestEnumValuesFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonValidationError {
    private final String myMessage;
    private final FixableIssueKind myFixableIssueKind;
    private final IssueData myIssueData;
    private final JsonErrorPriority myPriority;

    public IssueData getIssueData() {
        return this.myIssueData;
    }

    public JsonErrorPriority getPriority() {
        return this.myPriority;
    }

    public JsonValidationError(String message, FixableIssueKind fixableIssueKind, IssueData issueData, JsonErrorPriority priority) {
        this.myMessage = message;
        this.myFixableIssueKind = fixableIssueKind;
        this.myIssueData = issueData;
        this.myPriority = priority;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public FixableIssueKind getFixableIssueKind() {
        return this.myFixableIssueKind;
    }

    @NotNull
    public LocalQuickFix[] createFixes(@Nullable JsonLikeSyntaxAdapter quickFixAdapter) {
        if (quickFixAdapter == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                JsonValidationError.$$$reportNull$$$0(0);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        switch (this.myFixableIssueKind) {
            case MissingProperty: {
                LocalQuickFix[] localQuickFixArray = new AddMissingPropertyFix[]{new AddMissingPropertyFix((MissingMultiplePropsIssueData)this.myIssueData, quickFixAdapter)};
                if (localQuickFixArray == null) {
                    JsonValidationError.$$$reportNull$$$0(1);
                }
                return localQuickFixArray;
            }
            case MissingOneOfProperty: 
            case MissingAnyOfProperty: {
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])((MissingOneOfPropsIssueData)this.myIssueData).myExclusiveOptions.stream().map(d -> new AddMissingPropertyFix((MissingMultiplePropsIssueData)d, quickFixAdapter)).toArray(LocalQuickFix[]::new);
                if (localQuickFixArray == null) {
                    JsonValidationError.$$$reportNull$$$0(2);
                }
                return localQuickFixArray;
            }
            case ProhibitedProperty: {
                LocalQuickFix[] localQuickFixArray = new RemoveProhibitedPropertyFix[]{new RemoveProhibitedPropertyFix((ProhibitedPropertyIssueData)this.myIssueData, quickFixAdapter)};
                if (localQuickFixArray == null) {
                    JsonValidationError.$$$reportNull$$$0(3);
                }
                return localQuickFixArray;
            }
            case NonEnumValue: {
                LocalQuickFix[] localQuickFixArray = new SuggestEnumValuesFix[]{new SuggestEnumValuesFix(quickFixAdapter)};
                if (localQuickFixArray == null) {
                    JsonValidationError.$$$reportNull$$$0(4);
                }
                return localQuickFixArray;
            }
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            JsonValidationError.$$$reportNull$$$0(5);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonValidationError", "createFixes"));
    }

    public static class TypeMismatchIssueData
    implements IssueData {
        public final JsonSchemaType[] expectedTypes;

        public TypeMismatchIssueData(JsonSchemaType[] expectedTypes) {
            this.expectedTypes = expectedTypes;
        }
    }

    public static class ProhibitedPropertyIssueData
    implements IssueData {
        public final String propertyName;

        public ProhibitedPropertyIssueData(String propertyName) {
            this.propertyName = propertyName;
        }
    }

    public static class MissingPropertyIssueData
    implements IssueData {
        public final String propertyName;
        public final JsonSchemaType propertyType;
        public final Object defaultValue;
        public final int enumItemsCount;

        public MissingPropertyIssueData(String propertyName, JsonSchemaType propertyType, Object defaultValue, int enumItemsCount) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.defaultValue = defaultValue;
            this.enumItemsCount = enumItemsCount;
        }
    }

    public static class MissingMultiplePropsIssueData
    implements IssueData {
        public final Collection<MissingPropertyIssueData> myMissingPropertyIssues;

        public MissingMultiplePropsIssueData(Collection<MissingPropertyIssueData> missingPropertyIssues) {
            this.myMissingPropertyIssues = missingPropertyIssues;
        }

        private static String getPropertyNameWithComment(MissingPropertyIssueData prop) {
            String comment = "";
            if (prop.enumItemsCount == 1) {
                comment = " = " + prop.defaultValue.toString();
            }
            return "'" + prop.propertyName + "'" + comment;
        }

        public String getMessage(boolean trimIfNeeded) {
            if (this.myMissingPropertyIssues.size() == 1) {
                MissingPropertyIssueData prop = this.myMissingPropertyIssues.iterator().next();
                return "property " + MissingMultiplePropsIssueData.getPropertyNameWithComment(prop);
            }
            ArrayList namesToDisplay = this.myMissingPropertyIssues;
            boolean trimmed = false;
            if (trimIfNeeded && namesToDisplay.size() > 3) {
                namesToDisplay = ContainerUtil.newArrayList();
                Iterator<MissingPropertyIssueData> iterator = this.myMissingPropertyIssues.iterator();
                for (int i = 0; i < 3; ++i) {
                    namesToDisplay.add(iterator.next());
                }
                trimmed = true;
            }
            String allNames = this.myMissingPropertyIssues.stream().map(MissingMultiplePropsIssueData::getPropertyNameWithComment).sorted((s1, s2) -> {
                boolean secondHasEq;
                boolean firstHasEq = s1.contains("=");
                if (firstHasEq == (secondHasEq = s2.contains("="))) {
                    return s1.compareTo((String)s2);
                }
                return firstHasEq ? -1 : 1;
            }).collect(Collectors.joining(", "));
            if (trimmed) {
                allNames = allNames + ", ...";
            }
            return "properties " + allNames;
        }
    }

    public static class MissingOneOfPropsIssueData
    implements IssueData {
        public final Collection<MissingMultiplePropsIssueData> myExclusiveOptions;

        public MissingOneOfPropsIssueData(Collection<MissingMultiplePropsIssueData> options) {
            this.myExclusiveOptions = options;
        }
    }

    public static interface IssueData {
    }

    public static enum FixableIssueKind {
        MissingProperty,
        MissingOneOfProperty,
        MissingAnyOfProperty,
        ProhibitedProperty,
        NonEnumValue,
        ProhibitedType,
        TypeMismatch,
        None;

    }
}

