/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService {
    private static final Logger LOG = Logger.getInstance(JsonSchemaServiceImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MyState myState;
    @NotNull
    private final ClearableLazyValue<Set<String>> myBuiltInSchemaIds;
    @NotNull
    private final Set<String> myRefs;
    private final AtomicLong myAnyChangeCount;
    @NotNull
    private final JsonSchemaCatalogManager myCatalogManager;
    private final ConcurrentList<Runnable> myResetActions;

    public JsonSchemaServiceImpl(@NotNull Project project) {
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(0);
        }
        this.myRefs = ContainerUtil.newConcurrentSet();
        this.myAnyChangeCount = new AtomicLong(0L);
        this.myResetActions = ContainerUtil.createConcurrentList();
        this.myProject = project;
        this.myState = new MyState(() -> this.getProvidersFromFactories(), this.myProject);
        this.myBuiltInSchemaIds = new ClearableLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                Set set2 = ContainerUtil.map2Set(JsonSchemaServiceImpl.this.myState.getFiles(), f -> JsonCachedValues.getSchemaId(f, JsonSchemaServiceImpl.this.myProject));
                if (set2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$1", "compute"));
            }
        };
        this.myCatalogManager = new JsonSchemaCatalogManager(this.myProject);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        connection.subscribe(JsonSchemaVfsListener.JSON_DEPS_CHANGED, () -> {
            this.myRefs.clear();
            this.myAnyChangeCount.incrementAndGet();
        });
        JsonSchemaVfsListener.startListening(project, this, connection);
        this.myCatalogManager.startUpdates();
    }

    @NotNull
    private List<JsonSchemaFileProvider> getProvidersFromFactories() {
        ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
        for (JsonSchemaProviderFactory factory : this.getProviderFactories()) {
            try {
                providers.addAll(factory.getProviders(this.myProject));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                PluginException.logPluginError((Logger)Logger.getInstance(JsonSchemaService.class), (String)e.getMessage(), (Throwable)e, factory.getClass());
            }
        }
        ArrayList<JsonSchemaFileProvider> arrayList = providers;
        if (arrayList == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    protected List<JsonSchemaProviderFactory> getProviderFactories() {
        List list2 = JsonSchemaProviderFactory.EP_NAME.getExtensionList();
        if (list2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(3);
        }
        return this.myState.getProvider(schemaFile);
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file2;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(4);
        }
        return (file2 = this.resolveSchemaFile(schemaObject)) == null ? null : this.getSchemaProvider(file2);
    }

    @Override
    public void reset() {
        this.myState.reset();
        this.myBuiltInSchemaIds.drop();
        this.myAnyChangeCount.incrementAndGet();
        for (Runnable action : this.myResetActions) {
            action.run();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference, @Nullable VirtualFile referent) {
        VirtualFile file2;
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(6);
        }
        if ((file2 = this.findBuiltInSchemaByReference(reference)) != null) {
            return file2;
        }
        if (reference.startsWith("#")) {
            return referent;
        }
        return JsonFileResolver.resolveSchemaByReference(referent, JsonPointerUtil.normalizeId(reference));
    }

    @Nullable
    private VirtualFile findBuiltInSchemaByReference(@NotNull String reference) {
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(7);
        }
        String id = JsonPointerUtil.normalizeId(reference);
        if (!((Set)this.myBuiltInSchemaIds.getValue()).contains(id)) {
            return null;
        }
        for (VirtualFile file2 : this.myState.getFiles()) {
            if (!id.equals(JsonCachedValues.getSchemaId(file2, this.myProject))) continue;
            return file2;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(8);
        }
        Collection<VirtualFile> collection = this.getSchemasForFile(file2, false, false);
        if (collection == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<VirtualFile> getSchemasForFile(@NotNull VirtualFile file2, boolean single, boolean onlyUserSchemas) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(10);
        }
        String schemaUrl = null;
        if (!onlyUserSchemas && JsonSchemaServiceImpl.isSchemaUrl(schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject)) && (virtualFile2 = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
            List<VirtualFile> list2 = Collections.singletonList(virtualFile2);
            if (list2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<JsonSchemaFileProvider> providers = this.getProvidersForFile(file2);
        boolean checkSchemaProperty = true;
        if (!onlyUserSchemas && providers.stream().noneMatch(p -> p.getSchemaType() == SchemaType.userSchema)) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
                List<VirtualFile> list3 = Collections.singletonList(virtualFile);
                if (list3 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(12);
                }
                return list3;
            }
            checkSchemaProperty = false;
        }
        if (!single) {
            ArrayList files2 = ContainerUtil.newArrayList();
            for (JsonSchemaFileProvider provider2 : providers) {
                VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, provider2);
                if (schemaFile == null) continue;
                files2.add(schemaFile);
            }
            if (!files2.isEmpty()) {
                ArrayList arrayList = files2;
                if (arrayList == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(13);
                }
                return arrayList;
            }
        } else if (!providers.isEmpty()) {
            JsonSchemaFileProvider selected;
            if (providers.size() > 2) {
                List list4 = ContainerUtil.emptyList();
                if (list4 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(14);
                }
                return list4;
            }
            if (providers.size() > 1) {
                Optional<JsonSchemaFileProvider> userSchema = providers.stream().filter(provider -> SchemaType.userSchema.equals((Object)provider.getSchemaType())).findFirst();
                if (!userSchema.isPresent()) {
                    List list5 = ContainerUtil.emptyList();
                    if (list5 == null) {
                        JsonSchemaServiceImpl.$$$reportNull$$$0(15);
                    }
                    return list5;
                }
                selected = userSchema.get();
            } else {
                selected = providers.get(0);
            }
            VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, selected);
            List list6 = ContainerUtil.createMaybeSingletonList((Object)schemaFile);
            if (list6 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(16);
            }
            return list6;
        }
        if (onlyUserSchemas) {
            List list7 = ContainerUtil.emptyList();
            if (list7 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(17);
            }
            return list7;
        }
        if (checkSchemaProperty) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
                List<VirtualFile> list8 = Collections.singletonList(virtualFile);
                if (list8 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(18);
                }
                return list8;
            }
        }
        List list9 = ContainerUtil.createMaybeSingletonList((Object)this.resolveSchemaFromOtherSources(file2));
        if (list9 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(19);
        }
        return list9;
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProvidersForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(20);
        }
        List list2 = ContainerUtil.filter(this.myState.getProviders(), provider -> JsonSchemaServiceImpl.isProviderAvailable(file2, provider));
        if (list2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Nullable
    private VirtualFile resolveFromSchemaProperty(@Nullable String schemaUrl, @NotNull VirtualFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(22);
        }
        if (schemaUrl != null && (virtualFile = this.findSchemaFileByReference(schemaUrl, file2)) != null) {
            return virtualFile;
        }
        return null;
    }

    @Override
    public List<JsonSchemaInfo> getAllUserVisibleSchemas() {
        JsonSchemaInfo info;
        List<JsonSchemaCatalogEntry> schemas = this.myCatalogManager.getAllCatalogEntries();
        Collection<? extends JsonSchemaFileProvider> providers = this.myState.getProviders();
        ArrayList results = ContainerUtil.newArrayListWithCapacity((int)(schemas.size() + providers.size()));
        HashMap processedRemotes = ContainerUtil.newHashMap();
        for (JsonSchemaFileProvider jsonSchemaFileProvider : providers) {
            if (!jsonSchemaFileProvider.isUserVisible()) continue;
            String remoteSource = jsonSchemaFileProvider.getRemoteSource();
            if (remoteSource != null) {
                if (processedRemotes.containsKey(remoteSource)) continue;
                info = new JsonSchemaInfo(jsonSchemaFileProvider);
                processedRemotes.put(remoteSource, info);
                results.add(info);
                continue;
            }
            results.add(new JsonSchemaInfo(jsonSchemaFileProvider));
        }
        for (JsonSchemaCatalogEntry jsonSchemaCatalogEntry : schemas) {
            String url = jsonSchemaCatalogEntry.getUrl();
            if (!processedRemotes.containsKey(url)) {
                info = new JsonSchemaInfo(url);
                if (jsonSchemaCatalogEntry.getDescription() != null) {
                    info.setDocumentation(jsonSchemaCatalogEntry.getDescription());
                }
                if (jsonSchemaCatalogEntry.getName() != null) {
                    info.setName(jsonSchemaCatalogEntry.getName());
                }
                results.add(info);
                continue;
            }
            info = (JsonSchemaInfo)processedRemotes.get(url);
            if (info.getDocumentation() == null) {
                info.setDocumentation(jsonSchemaCatalogEntry.getDescription());
            }
            if (info.getName() != null) continue;
            info.setName(jsonSchemaCatalogEntry.getName());
        }
        return results;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file2) {
        Collection<VirtualFile> schemas;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(23);
        }
        if ((schemas = this.getSchemasForFile(file2, true, false)).size() == 0) {
            return null;
        }
        assert (schemas.size() == 1);
        VirtualFile schemaFile = schemas.iterator().next();
        return JsonCachedValues.getSchemaObject(this.replaceHttpFileWithBuiltinIfNeeded(schemaFile), this.myProject);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull PsiFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(24);
        }
        return JsonCachedValues.computeSchemaForFile(file2, this);
    }

    public VirtualFile replaceHttpFileWithBuiltinIfNeeded(VirtualFile schemaFile) {
        if (!JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas() && schemaFile instanceof HttpVirtualFile) {
            String url = schemaFile.getUrl();
            VirtualFile first1 = this.getLocalSchemaByUrl(url);
            return first1 != null ? first1 : schemaFile;
        }
        return schemaFile;
    }

    @Nullable
    public VirtualFile getLocalSchemaByUrl(String url) {
        return this.myState.getFiles().stream().filter(f -> {
            JsonSchemaFileProvider prov = this.getSchemaProvider((VirtualFile)f);
            return prov != null && !(prov.getSchemaFile() instanceof HttpVirtualFile) && (url.equals(prov.getRemoteSource()) || JsonFileResolver.replaceUnsafeSchemaStoreUrls(url).equals(prov.getRemoteSource()) || url.equals(JsonFileResolver.replaceUnsafeSchemaStoreUrls(prov.getRemoteSource())));
        }).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(25);
        }
        return JsonCachedValues.getSchemaObject(schemaFile, this.myProject);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(26);
        }
        return this.isMappedSchema(file2) || this.isSchemaByProvider(file2) || this.hasSchemaSchema(file2);
    }

    @Override
    public boolean isSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file2;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(27);
        }
        return (file2 = this.resolveSchemaFile(schemaObject)) != null && this.isSchemaFile(file2);
    }

    private boolean isMappedSchema(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(28);
        }
        return this.isMappedSchema(file2, true);
    }

    public boolean isMappedSchema(@NotNull VirtualFile file2, boolean canRecompute) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(29);
        }
        return (canRecompute || this.myState.isComputed()) && this.myState.getFiles().contains(file2);
    }

    private boolean isSchemaByProvider(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(30);
        }
        if ((provider = this.myState.getProvider(file2)) == null) {
            for (JsonSchemaFileProvider jsonSchemaFileProvider : this.myState.getProviders()) {
                if (!JsonSchemaServiceImpl.isSchemaProvider(jsonSchemaFileProvider) || !jsonSchemaFileProvider.isAvailable(file2)) continue;
                return true;
            }
            return false;
        }
        return JsonSchemaServiceImpl.isSchemaProvider(provider);
    }

    private static boolean isSchemaProvider(JsonSchemaFileProvider provider) {
        VirtualFile schemaFile = provider.getSchemaFile();
        if (!(schemaFile instanceof HttpVirtualFile)) {
            return false;
        }
        String url = schemaFile.getUrl();
        return JsonSchemaServiceImpl.isSchemaUrl(url);
    }

    private static boolean isSchemaUrl(@Nullable String url) {
        return url != null && url.startsWith("http://json-schema.org/") && (url.endsWith("/schema") || url.endsWith("/schema#"));
    }

    @Override
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(31);
        }
        if (this.isMappedSchema(file2) && (provider = this.myState.getProvider(file2)) != null) {
            return provider.getSchemaVersion();
        }
        return this.getSchemaVersionFromSchemaUrl(file2);
    }

    @Nullable
    private JsonSchemaVersion getSchemaVersionFromSchemaUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(32);
        }
        Ref res2 = Ref.create(null);
        ApplicationManager.getApplication().runReadAction(() -> res2.set((Object)JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject)));
        if (res2.isNull()) {
            return null;
        }
        return JsonSchemaVersion.byId((String)res2.get());
    }

    private boolean hasSchemaSchema(VirtualFile file2) {
        return this.getSchemaVersionFromSchemaUrl(file2) != null;
    }

    private static boolean isProviderAvailable(@NotNull VirtualFile file2, @NotNull JsonSchemaFileProvider provider) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(33);
        }
        if (provider == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(34);
        }
        return provider.isAvailable(file2);
    }

    @Nullable
    private VirtualFile resolveSchemaFromOtherSources(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(35);
        }
        return this.myCatalogManager.getSchemaFileForFile(file2);
    }

    @Override
    public void registerRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.registerCatalogUpdateCallback(callback2);
    }

    @Override
    public void unregisterRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.unregisterCatalogUpdateCallback(callback2);
    }

    @Override
    public void registerResetAction(Runnable action) {
        this.myResetActions.add((Object)action);
    }

    @Override
    public void unregisterResetAction(Runnable action) {
        this.myResetActions.remove((Object)action);
    }

    @Override
    public void registerReference(String ref) {
        int index = StringUtil.lastIndexOfAny((CharSequence)ref, (String)"\\/");
        if (index >= 0) {
            ref = ref.substring(index + 1);
        }
        this.myRefs.add(ref);
    }

    @Override
    public boolean possiblyHasReference(String ref) {
        return this.myRefs.contains(ref);
    }

    @Override
    public void triggerUpdateRemote() {
        this.myCatalogManager.triggerUpdateCatalog(this.myProject);
    }

    @Override
    public boolean isApplicableToFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        for (JsonSchemaEnabler e : JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!e.isEnabledForFile(file2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getSchemaForProvider(@NotNull Project project, @NotNull JsonSchemaFileProvider provider) {
        String source;
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(36);
        }
        if (provider == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(37);
        }
        if (JsonSchemaCatalogProjectConfiguration.getInstance(project).isPreferRemoteSchemas() && (source = provider.getRemoteSource()) != null && !source.endsWith("!")) {
            return VirtualFileManager.getInstance().findFileByUrl(source);
        }
        return provider.getSchemaFile();
    }

    @Override
    @Nullable
    public VirtualFile resolveSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile rawFile;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(38);
        }
        if ((rawFile = schemaObject.getRawFile()) != null) {
            return rawFile;
        }
        String fileUrl = schemaObject.getFileUrl();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(fileUrl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 3: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 4: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: 
            case 10: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersFromFactories";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFactories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFilesForFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasForFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaProvider";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSchemaFileByReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltInSchemaByReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFilesForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSchemasForFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromSchemaProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObjectForSchemaFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isMappedSchema";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaByProvider";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersion";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersionFromSchemaUrl";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isProviderAvailable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFromOtherSources";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaForProvider";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyState {
        @NotNull
        private final Factory<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClearableLazyValue<MultiMap<VirtualFile, JsonSchemaFileProvider>> myData;
        private final AtomicBoolean myIsComputed;

        private MyState(@NotNull Factory<List<JsonSchemaFileProvider>> factory, @NotNull Project project) {
            if (factory == null) {
                MyState.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyState.$$$reportNull$$$0(1);
            }
            this.myIsComputed = new AtomicBoolean(false);
            this.myFactory = factory;
            this.myProject = project;
            this.myData = new ClearableLazyValue<MultiMap<VirtualFile, JsonSchemaFileProvider>>(){

                @NotNull
                public MultiMap<VirtualFile, JsonSchemaFileProvider> compute() {
                    MultiMap map2 = MyState.createFileProviderMap((List)myFactory.create(), myProject);
                    myIsComputed.set(true);
                    MultiMap multiMap = map2;
                    if (multiMap == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return multiMap;
                }

                @NotNull
                public final synchronized MultiMap<VirtualFile, JsonSchemaFileProvider> getValue() {
                    MultiMap multiMap = (MultiMap)super.getValue();
                    if (multiMap == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return multiMap;
                }

                public final synchronized void drop() {
                    myIsComputed.set(false);
                    super.drop();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "compute";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValue";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        public void reset() {
            this.myData.drop();
        }

        @NotNull
        public Collection<? extends JsonSchemaFileProvider> getProviders() {
            Collection collection = ((MultiMap)this.myData.getValue()).values();
            if (collection == null) {
                MyState.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            Set set2 = ((MultiMap)this.myData.getValue()).keySet();
            if (set2 == null) {
                MyState.$$$reportNull$$$0(3);
            }
            return set2;
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyState.$$$reportNull$$$0(4);
            }
            Collection providers = ((MultiMap)this.myData.getValue()).get((Object)file2);
            for (JsonSchemaFileProvider p : providers) {
                if (p.getSchemaType() != SchemaType.userSchema) continue;
                return p;
            }
            return (JsonSchemaFileProvider)ContainerUtil.getFirstItem((Collection)providers);
        }

        public boolean isComputed() {
            return this.myIsComputed.get();
        }

        @NotNull
        private static MultiMap<VirtualFile, JsonSchemaFileProvider> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list2, @NotNull Project project) {
            if (list2 == null) {
                MyState.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyState.$$$reportNull$$$0(6);
            }
            MultiMap map2 = MultiMap.create();
            for (JsonSchemaFileProvider provider : list2) {
                VirtualFile schemaFile;
                try {
                    schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(project, provider);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (schemaFile == null) continue;
                map2.putValue((Object)schemaFile, (Object)provider);
            }
            MultiMap multiMap = map2;
            if (multiMap == null) {
                MyState.$$$reportNull$$$0(7);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProviders";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFileProviderMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvider";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileProviderMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

