/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsUtilEx {
    @Nullable
    static FileViewProvider findViewProvider(VirtualFile file2, Project project) {
        if (file2 == null || file2.isDirectory()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findViewProvider(file2);
    }

    @Nullable
    static BreadcrumbsProvider findProvider(VirtualFile file2, @Nullable Project project, @Nullable Boolean forcedShown) {
        return project == null ? null : BreadcrumbsUtilEx.findProvider(BreadcrumbsUtilEx.findViewProvider(file2, project), forcedShown);
    }

    @Nullable
    public static BreadcrumbsProvider findProvider(@Nullable FileViewProvider viewProvider, @Nullable Boolean forceShown) {
        if (viewProvider == null) {
            return null;
        }
        if (forceShown == null) {
            return BreadcrumbsUtilEx.findProvider(true, viewProvider);
        }
        return forceShown != false ? BreadcrumbsUtilEx.findProvider(false, viewProvider) : null;
    }

    @Nullable
    public static BreadcrumbsProvider findProvider(boolean checkSettings, @NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            BreadcrumbsUtilEx.$$$reportNull$$$0(0);
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (checkSettings && !settings.isBreadcrumbsShown()) {
            return null;
        }
        Language baseLang = viewProvider.getBaseLanguage();
        if (checkSettings && !BreadcrumbsUtilEx.isBreadcrumbsShownFor(baseLang)) {
            return null;
        }
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)baseLang);
        if (provider == null) {
            for (Language language : viewProvider.getLanguages()) {
                if (checkSettings && !BreadcrumbsUtilEx.isBreadcrumbsShownFor(language) || (provider = BreadcrumbsUtil.getInfoProvider((Language)language)) == null) continue;
                break;
            }
        }
        return provider;
    }

    public static boolean isBreadcrumbsShownFor(Language language) {
        String id = BreadcrumbsUtilEx.findLanguageWithBreadcrumbSettings(language);
        return EditorSettingsExternalizable.getInstance().isBreadcrumbsShownFor(id);
    }

    public static String findLanguageWithBreadcrumbSettings(Language language) {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        for (Language base = language; base != null; base = base.getBaseLanguage()) {
            if (!settings.hasBreadcrumbSettings(base.getID())) continue;
            return base.getID();
        }
        return language.getID();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/xml/breadcrumbs/BreadcrumbsUtilEx", "findProvider"));
    }
}

