/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.popup.async.AsyncPopupStep;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.StatusText;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachHostProvider;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.intellij.xdebugger.impl.actions.LocalAttachHostPresentationGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttachToProcessActionBase
extends AnAction {
    private static final Key<Map<XAttachHost, LinkedHashSet<RecentItem>>> RECENT_ITEMS_KEY = Key.create((String)"AttachToProcessAction.RECENT_ITEMS_KEY");
    private static final Logger LOG = Logger.getInstance(AttachToProcessActionBase.class);
    @NotNull
    private final Supplier<? extends List<XAttachDebuggerProvider>> myAttachProvidersSupplier;
    @NotNull
    private final String myAttachActionsListTitle;
    @NotNull
    private final Supplier<? extends List<XAttachHostProvider>> myAttachHostProviderSupplier;

    public AttachToProcessActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon, @NotNull Supplier<? extends List<XAttachDebuggerProvider>> attachProvidersSupplier, @NotNull Supplier<? extends List<XAttachHostProvider>> attachHostProviderSupplier, @NotNull String attachActionsListTitle) {
        if (attachProvidersSupplier == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(0);
        }
        if (attachHostProviderSupplier == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(1);
        }
        if (attachActionsListTitle == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(2);
        }
        super(text, description, icon);
        this.myAttachProvidersSupplier = attachProvidersSupplier;
        this.myAttachActionsListTitle = attachActionsListTitle;
        this.myAttachHostProviderSupplier = attachHostProviderSupplier;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(3);
        }
        super.update(e);
        Project project = AttachToProcessActionBase.getEventProject((AnActionEvent)e);
        int attachDebuggerProvidersNumber = this.myAttachProvidersSupplier.get().size();
        boolean enabled = project != null && attachDebuggerProvidersNumber > 0;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(4);
        }
        if ((project = AttachToProcessActionBase.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        new Task.Backgroundable(project, XDebuggerBundle.message((String)"xdebugger.attach.action.collectingItems", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ImmutableList allItems = ContainerUtil.immutableList(AttachToProcessActionBase.this.getTopLevelItems(indicator, project));
                ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$1((List)allItems, project), project.getDisposed());
            }

            private /* synthetic */ void lambda$run$1(List allItems, Project project2) {
                AttachListStep step = new AttachListStep(allItems, XDebuggerBundle.message((String)"xdebugger.attach.popup.title.default", (Object[])new Object[0]), project2);
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                JList mainList = ((ListPopupImpl)popup2).getList();
                ListSelectionListener listener2 = event -> {
                    if (event.getValueIsAdjusting()) {
                        return;
                    }
                    Object item = ((JList)event.getSource()).getSelectedValue();
                    if (item == null) {
                        item = mainList.getSelectedValue();
                    }
                    if (item instanceof AttachToProcessItem) {
                        String debuggerName = ((AttachToProcessItem)item).getSelectedDebugger().getDebuggerDisplayName();
                        debuggerName = StringUtil.shortenTextWithEllipsis((String)debuggerName, (int)50, (int)0);
                        popup2.setCaption(XDebuggerBundle.message((String)"xdebugger.attach.popup.title", (Object[])new Object[]{debuggerName}));
                    }
                    if (item instanceof AttachHostItem) {
                        AttachHostItem hostItem = (AttachHostItem)item;
                        String attachHostName = hostItem.getText(project2);
                        attachHostName = StringUtil.shortenTextWithEllipsis((String)attachHostName, (int)50, (int)0);
                        popup2.setCaption(XDebuggerBundle.message((String)"xdebugger.attach.host.popup.title", (Object[])new Object[]{attachHostName}));
                    }
                };
                popup2.addListSelectionListener(listener2);
                listener2.valueChanged(new ListSelectionEvent(mainList, mainList.getMinSelectionIndex(), mainList.getMaxSelectionIndex(), false));
                popup2.showCenteredInCurrentWindow(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$1", "run"));
            }
        }.queue();
    }

    @NotNull
    protected List<? extends AttachItem> getTopLevelItems(@NotNull ProgressIndicator indicator, @NotNull Project project) {
        List<AttachItem> attachHostItems;
        if (indicator == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(5);
        }
        if (project == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(6);
        }
        if (!(attachHostItems = this.collectAttachHostsItems(project, indicator)).isEmpty()) {
            AttachHostItem localHostGroupItem = new AttachHostItem(LocalAttachHostPresentationGroup.INSTANCE, false, LocalAttachHost.INSTANCE, project, (UserDataHolder)new UserDataHolderBase());
            attachHostItems.add(localHostGroupItem);
            AttachToProcessActionBase.doUpdateFirstInGroup(attachHostItems);
            List<AttachItem> list2 = attachHostItems;
            if (list2 == null) {
                AttachToProcessActionBase.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<AttachToProcessItem> list3 = this.collectAttachProcessItems(project, LocalAttachHost.INSTANCE, indicator);
        if (list3 == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(8);
        }
        return list3;
    }

    private static void doUpdateFirstInGroup(@NotNull List<? extends AttachItem> items) {
        if (items == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(9);
        }
        if (items.isEmpty()) {
            return;
        }
        items.get(0).makeFirstInGroup();
        for (int i = 1; i < items.size(); ++i) {
            if (items.get(i).getGroup() == items.get(i - 1).getGroup()) continue;
            items.get(i).makeFirstInGroup();
        }
    }

    @NotNull
    public List<AttachItem> collectAttachHostsItems(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(11);
        }
        ArrayList currentItems = ContainerUtil.newArrayList();
        UserDataHolderBase dataHolder = new UserDataHolderBase();
        for (XAttachHostProvider hostProvider : this.myAttachHostProviderSupplier.get()) {
            indicator.checkCanceled();
            HashSet hosts = ContainerUtil.newHashSet(hostProvider.getAvailableHosts(project));
            for (XAttachHost host : hosts) {
                currentItems.add(new AttachHostItem(hostProvider.getPresentationGroup(), false, host, project, (UserDataHolder)dataHolder));
            }
        }
        Collections.sort(currentItems);
        AttachToProcessActionBase.doUpdateFirstInGroup(currentItems);
        ArrayList arrayList = currentItems;
        if (arrayList == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<AttachToProcessItem> getRecentItems(@NotNull List<? extends AttachToProcessItem> currentItems, @NotNull XAttachHost host, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
        if (currentItems == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(13);
        }
        if (host == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(14);
        }
        if (project == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(15);
        }
        if (dataHolder == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(16);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        List<RecentItem> recentItems = AttachToProcessActionBase.getRecentItems(host, project);
        for (int i = recentItems.size() - 1; i >= 0; --i) {
            RecentItem recentItem = recentItems.get(i);
            for (AttachToProcessItem attachToProcessItem : currentItems) {
                boolean isSuitableItem;
                boolean bl = isSuitableItem = recentItem.getGroup().equals(attachToProcessItem.getGroup()) && recentItem.getProcessInfo().getCommandLine().equals(attachToProcessItem.getProcessInfo().getCommandLine());
                if (!isSuitableItem) continue;
                List<XAttachDebugger> debuggers = attachToProcessItem.getDebuggers();
                int selectedDebugger = -1;
                for (int j = 0; j < debuggers.size(); ++j) {
                    XAttachDebugger debugger = debuggers.get(j);
                    if (!debugger.getDebuggerDisplayName().equals(recentItem.getDebuggerName())) continue;
                    selectedDebugger = j;
                    break;
                }
                if (selectedDebugger == -1) continue;
                result2.add(AttachToProcessItem.createRecentAttachItem(attachToProcessItem, result2.isEmpty(), debuggers, selectedDebugger, project, dataHolder));
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static List<ProcessInfo> getProcessInfos(@NotNull XAttachHost host) {
        List<ProcessInfo> list2;
        if (host == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(18);
        }
        try {
            list2 = host.getProcessList();
        }
        catch (ExecutionException e) {
            Notifications.Bus.notify((Notification)new Notification("Attach to Process action", XDebuggerBundle.message((String)"xdebugger.attach.action.items.error.title", (Object[])new Object[0]), XDebuggerBundle.message((String)"xdebugger.attach.action.items.error.message", (Object[])new Object[0]), NotificationType.WARNING));
            LOG.warn("Error while getting attach items", (Throwable)e);
            List<ProcessInfo> list3 = Collections.emptyList();
            if (list3 == null) {
                AttachToProcessActionBase.$$$reportNull$$$0(20);
            }
            return list3;
        }
        if (list2 == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private List<XAttachDebuggerProvider> getProvidersApplicableForHost(@NotNull XAttachHost host) {
        if (host == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(21);
        }
        List list2 = ContainerUtil.filter((Collection)this.myAttachProvidersSupplier.get(), provider -> provider.isAttachHostApplicable(host));
        if (list2 == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    public List<AttachToProcessItem> collectAttachProcessItems(@NotNull Project project, @NotNull XAttachHost host, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(23);
        }
        if (host == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(25);
        }
        List<AttachToProcessItem> list2 = AttachToProcessActionBase.doCollectAttachProcessItems(project, host, AttachToProcessActionBase.getProcessInfos(host), indicator, this.getProvidersApplicableForHost(host));
        if (list2 == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    static List<AttachToProcessItem> doCollectAttachProcessItems(@NotNull Project project, @NotNull XAttachHost host, @NotNull List<? extends ProcessInfo> processInfos, @NotNull ProgressIndicator indicator, @NotNull List<? extends XAttachDebuggerProvider> providers) {
        if (project == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(27);
        }
        if (host == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(28);
        }
        if (processInfos == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(29);
        }
        if (indicator == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(30);
        }
        if (providers == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(31);
        }
        UserDataHolderBase dataHolder = new UserDataHolderBase();
        ArrayList currentItems = ContainerUtil.newArrayList();
        for (ProcessInfo processInfo : processInfos) {
            MultiMap groupsWithDebuggers = new MultiMap();
            for (XAttachDebuggerProvider xAttachDebuggerProvider : providers) {
                indicator.checkCanceled();
                groupsWithDebuggers.putValues(xAttachDebuggerProvider.getPresentationGroup(), xAttachDebuggerProvider.getAvailableDebuggers(project, host, processInfo, (UserDataHolder)dataHolder));
            }
            for (XAttachPresentationGroup xAttachPresentationGroup : groupsWithDebuggers.keySet()) {
                Collection debuggers = groupsWithDebuggers.get((Object)xAttachPresentationGroup);
                if (debuggers.isEmpty()) continue;
                currentItems.add(new AttachToProcessItem(xAttachPresentationGroup, false, host, processInfo, new ArrayList<XAttachDebugger>(debuggers), project, (UserDataHolder)dataHolder));
            }
        }
        Collections.sort(currentItems);
        AttachToProcessActionBase.doUpdateFirstInGroup(currentItems);
        List<AttachToProcessItem> result2 = AttachToProcessActionBase.getRecentItems(currentItems, host, project, (UserDataHolder)dataHolder);
        result2.addAll(currentItems);
        List<AttachToProcessItem> list2 = result2;
        if (list2 == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(32);
        }
        return list2;
    }

    public static void addToRecent(@NotNull Project project, @NotNull AttachToProcessItem item) {
        XAttachHost host;
        LinkedHashSet hostRecentItems;
        Map recentItems;
        if (project == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(33);
        }
        if (item == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(34);
        }
        if ((recentItems = (Map)project.getUserData(RECENT_ITEMS_KEY)) == null) {
            recentItems = ContainerUtil.newHashMap();
            project.putUserData(RECENT_ITEMS_KEY, (Object)recentItems);
        }
        if ((hostRecentItems = (LinkedHashSet)recentItems.get(host = item.getHost())) == null) {
            recentItems.put(host, ContainerUtil.newLinkedHashSet());
            hostRecentItems = (LinkedHashSet)recentItems.get(host);
        }
        RecentItem newRecentItem = new RecentItem(host, item);
        hostRecentItems.remove(newRecentItem);
        hostRecentItems.add(newRecentItem);
        while (hostRecentItems.size() > 4) {
            hostRecentItems.remove(hostRecentItems.iterator().next());
        }
    }

    @NotNull
    public static List<RecentItem> getRecentItems(@NotNull XAttachHost host, @NotNull Project project) {
        Map recentItems;
        if (host == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(35);
        }
        if (project == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(36);
        }
        List<RecentItem> list2 = (recentItems = (Map)project.getUserData(RECENT_ITEMS_KEY)) == null || !recentItems.containsKey(host) ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList((Collection)recentItems.get(host)));
        if (list2 == null) {
            AttachToProcessActionBase.$$$reportNull$$$0(37);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 32: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 32: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachProvidersSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachHostProviderSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachActionsListTitle";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 11: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 23: 
            case 27: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentItems";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfos";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelItems";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAttachHostsItems";
                break;
            }
            case 17: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentItems";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessInfos";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersApplicableForHost";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAttachProcessItems";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollectAttachProcessItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelItems";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 32: 
            case 37: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateFirstInGroup";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectAttachHostsItems";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getRecentItems";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProcessInfos";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersApplicableForHost";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectAttachProcessItems";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doCollectAttachProcessItems";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addToRecent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 32: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class AttachListStep
    extends MyBasePopupStep<AttachItem>
    implements ListPopupStepEx<AttachItem> {
        public AttachListStep(@Nullable List<AttachItem> items, @NotNull String title, Project project) {
            if (items == null) {
                AttachListStep.$$$reportNull$$$0(0);
            }
            if (project == null) {
                AttachListStep.$$$reportNull$$$0(1);
            }
            super(project, title, items);
        }

        @Nullable
        public ListSeparator getSeparatorAbove(AttachItem value) {
            String separatorTitle = value.getSeparatorTitle();
            return separatorTitle == null ? null : new ListSeparator(separatorTitle);
        }

        public Icon getIconFor(AttachItem value) {
            return value.getIcon(this.myProject);
        }

        @NotNull
        public String getTextFor(AttachItem value) {
            String string = value.getText(this.myProject);
            if (string == null) {
                AttachListStep.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean hasSubstep(AttachItem selectedValue) {
            return selectedValue.hasSubStep();
        }

        @Nullable
        public String getTooltipTextFor(AttachItem value) {
            return value.getTooltipText(this.myProject);
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            if (emptyText == null) {
                AttachListStep.$$$reportNull$$$0(3);
            }
            emptyText.setText(XDebuggerBundle.message((String)"xdebugger.attach.popup.emptyText", (Object[])new Object[0]));
        }

        @Override
        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice) {
            if (selectedValue instanceof AttachToProcessItem) {
                AttachToProcessItem attachToProcessItem = (AttachToProcessItem)selectedValue;
                if (finalChoice) {
                    AttachToProcessActionBase.addToRecent(this.myProject, attachToProcessItem);
                    return this.doFinalStep(() -> attachToProcessItem.startDebugSession(this.myProject));
                }
                return new ActionListStep(attachToProcessItem.getSubItems(), attachToProcessItem.mySelectedDebugger);
            }
            if (selectedValue instanceof AttachHostItem) {
                final AttachHostItem attachHostItem = (AttachHostItem)selectedValue;
                return new AsyncPopupStep(){

                    @Override
                    public PopupStep call() {
                        ArrayList<AttachItem> attachItems = new ArrayList<AttachItem>(attachHostItem.getSubItems());
                        return new AttachListStep(attachItems, null, AttachListStep.this.myProject);
                    }
                };
            }
            return null;
        }

        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice, int eventModifiers) {
            return this.onChosen(selectedValue, finalChoice);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachListStep";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachListStep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setEmptyText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class ActionListStep
        extends MyBasePopupStep<AttachToProcessItem> {
            ActionListStep(List<AttachToProcessItem> items, int selectedItem) {
                super(AttachListStep.this.myProject, AttachToProcessActionBase.this.myAttachActionsListTitle, items);
                this.setDefaultOptionIndex(selectedItem);
            }

            @NotNull
            public String getTextFor(AttachToProcessItem value) {
                String string = value.getSelectedDebugger().getDebuggerDisplayName();
                if (string == null) {
                    ActionListStep.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public PopupStep onChosen(AttachToProcessItem selectedValue, boolean finalChoice) {
                AttachToProcessActionBase.addToRecent(this.myProject, selectedValue);
                return this.doFinalStep(() -> selectedValue.startDebugSession(this.myProject));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachListStep$ActionListStep", "getTextFor"));
            }
        }
    }

    private static class MyBasePopupStep<T extends AttachItem>
    extends BaseListPopupStep<T> {
        @NotNull
        final Project myProject;

        MyBasePopupStep(@NotNull Project project, @Nullable String title, List<T> values) {
            if (project == null) {
                MyBasePopupStep.$$$reportNull$$$0(0);
            }
            super(title, values);
            this.myProject = project;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public boolean hasSubstep(AttachItem selectedValue) {
            return !selectedValue.getSubItems().isEmpty();
        }

        public PopupStep onChosen(T selectedValue, boolean finalChoice) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$MyBasePopupStep", "<init>"));
        }
    }

    public static class AttachToProcessItem
    extends AttachItem<ProcessInfo> {
        @NotNull
        private final List<XAttachDebugger> myDebuggers;
        private final int mySelectedDebugger;
        @NotNull
        private final List<AttachToProcessItem> mySubItems;
        @NotNull
        private final XAttachHost myHost;

        public AttachToProcessItem(@NotNull XAttachPresentationGroup<ProcessInfo> group, boolean isFirstInGroup, @NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull List<XAttachDebugger> debuggers, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
            if (group == null) {
                AttachToProcessItem.$$$reportNull$$$0(0);
            }
            if (host == null) {
                AttachToProcessItem.$$$reportNull$$$0(1);
            }
            if (info == null) {
                AttachToProcessItem.$$$reportNull$$$0(2);
            }
            if (debuggers == null) {
                AttachToProcessItem.$$$reportNull$$$0(3);
            }
            if (project == null) {
                AttachToProcessItem.$$$reportNull$$$0(4);
            }
            if (dataHolder == null) {
                AttachToProcessItem.$$$reportNull$$$0(5);
            }
            this(group, isFirstInGroup, group.getGroupName(), host, info, debuggers, 0, project, dataHolder);
        }

        public AttachToProcessItem(@NotNull XAttachPresentationGroup<ProcessInfo> group, boolean isFirstInGroup, @NotNull String groupName, @NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull List<XAttachDebugger> debuggers, int selectedDebugger, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
            if (group == null) {
                AttachToProcessItem.$$$reportNull$$$0(6);
            }
            if (groupName == null) {
                AttachToProcessItem.$$$reportNull$$$0(7);
            }
            if (host == null) {
                AttachToProcessItem.$$$reportNull$$$0(8);
            }
            if (info == null) {
                AttachToProcessItem.$$$reportNull$$$0(9);
            }
            if (debuggers == null) {
                AttachToProcessItem.$$$reportNull$$$0(10);
            }
            if (project == null) {
                AttachToProcessItem.$$$reportNull$$$0(11);
            }
            if (dataHolder == null) {
                AttachToProcessItem.$$$reportNull$$$0(12);
            }
            super(group, isFirstInGroup, groupName, info, project, dataHolder);
            assert (!debuggers.isEmpty()) : "debugger list should not be empty";
            assert (selectedDebugger >= 0 && selectedDebugger < debuggers.size()) : "wrong selected debugger index";
            this.myDebuggers = debuggers;
            this.mySelectedDebugger = selectedDebugger;
            this.myHost = host;
            this.mySubItems = debuggers.size() > 1 ? ContainerUtil.map(debuggers, debugger -> new AttachToProcessItem(this.myGroup, false, this.myHost, (ProcessInfo)this.myInfo, Collections.singletonList(debugger), this.myProject, dataHolder)) : Collections.emptyList();
        }

        static AttachToProcessItem createRecentAttachItem(AttachToProcessItem item, boolean isFirstInGroup, List<XAttachDebugger> debuggers, int selectedDebugger, Project project, UserDataHolder dataHolder) {
            return new AttachToProcessItem(item.getGroup(), isFirstInGroup, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.recent", (Object[])new Object[0]), item.getHost(), item.getProcessInfo(), debuggers, selectedDebugger, project, dataHolder);
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            ProcessInfo processInfo = (ProcessInfo)this.myInfo;
            if (processInfo == null) {
                AttachToProcessItem.$$$reportNull$$$0(13);
            }
            return processInfo;
        }

        @NotNull
        public XAttachHost getHost() {
            XAttachHost xAttachHost = this.myHost;
            if (xAttachHost == null) {
                AttachToProcessItem.$$$reportNull$$$0(14);
            }
            return xAttachHost;
        }

        @Override
        public boolean hasSubStep() {
            return !this.mySubItems.isEmpty();
        }

        @Override
        @Nullable
        public String getTooltipText(@NotNull Project project) {
            if (project == null) {
                AttachToProcessItem.$$$reportNull$$$0(15);
            }
            return this.myGroup.getItemDescription(project, this.myInfo, this.myDataHolder);
        }

        @Override
        @NotNull
        public String getText(@NotNull Project project) {
            if (project == null) {
                AttachToProcessItem.$$$reportNull$$$0(16);
            }
            String shortenedText = StringUtil.shortenTextWithEllipsis((String)this.myGroup.getItemDisplayText(project, this.myInfo, this.myDataHolder), (int)200, (int)0);
            int pid = ((ProcessInfo)this.myInfo).getPid();
            String string = (pid == -1 ? "" : pid + " ") + shortenedText;
            if (string == null) {
                AttachToProcessItem.$$$reportNull$$$0(17);
            }
            return string;
        }

        @NotNull
        public List<XAttachDebugger> getDebuggers() {
            List<XAttachDebugger> list2 = this.myDebuggers;
            if (list2 == null) {
                AttachToProcessItem.$$$reportNull$$$0(18);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<AttachToProcessItem> getSubItems() {
            List<AttachToProcessItem> list2 = this.mySubItems;
            if (list2 == null) {
                AttachToProcessItem.$$$reportNull$$$0(19);
            }
            return list2;
        }

        @NotNull
        public XAttachDebugger getSelectedDebugger() {
            XAttachDebugger xAttachDebugger = this.myDebuggers.get(this.mySelectedDebugger);
            if (xAttachDebugger == null) {
                AttachToProcessItem.$$$reportNull$$$0(20);
            }
            return xAttachDebugger;
        }

        public void startDebugSession(@NotNull Project project) {
            if (project == null) {
                AttachToProcessItem.$$$reportNull$$$0(21);
            }
            XAttachDebugger debugger = this.getSelectedDebugger();
            try {
                debugger.attachDebugSession(project, this.myHost, (ProcessInfo)this.myInfo);
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)project, (String)ToolWindowId.DEBUG, (String)("pid " + ((ProcessInfo)this.myInfo).getPid()), (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 13: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 13: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggers";
                    break;
                }
                case 4: 
                case 11: 
                case 15: 
                case 16: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 13: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachToProcessItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachToProcessItem";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessInfo";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHost";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggers";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubItems";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedDebugger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 13: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getTooltipText";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "startDebugSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 13: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class AttachHostItem
    extends AttachItem<XAttachHost> {
        AttachHostItem(XAttachPresentationGroup<XAttachHost> group, @NotNull boolean isFirstInGroup, @NotNull XAttachHost host, @NotNull Project project, UserDataHolder dataHolder) {
            if (group == null) {
                AttachHostItem.$$$reportNull$$$0(0);
            }
            if (host == null) {
                AttachHostItem.$$$reportNull$$$0(1);
            }
            if (project == null) {
                AttachHostItem.$$$reportNull$$$0(2);
            }
            if (dataHolder == null) {
                AttachHostItem.$$$reportNull$$$0(3);
            }
            super(group, isFirstInGroup, group.getGroupName(), host, project, dataHolder);
        }

        @Override
        public boolean hasSubStep() {
            return true;
        }

        @Override
        @NotNull
        public String getText(@NotNull Project project) {
            if (project == null) {
                AttachHostItem.$$$reportNull$$$0(4);
            }
            String string = this.myGroup.getItemDisplayText(project, this.myInfo, this.myDataHolder);
            if (string == null) {
                AttachHostItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @Nullable
        public String getTooltipText(@NotNull Project project) {
            if (project == null) {
                AttachHostItem.$$$reportNull$$$0(6);
            }
            return this.myGroup.getItemDescription(project, this.myInfo, this.myDataHolder);
        }

        @Override
        public List<AttachToProcessItem> getSubItems() {
            return AttachToProcessActionBase.this.collectAttachProcessItems(this.myProject, (XAttachHost)this.myInfo, (ProgressIndicator)new EmptyProgressIndicator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachHostItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachHostItem";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTooltipText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class AttachItem<T>
    implements Comparable<AttachItem<T>> {
        @NotNull
        XAttachPresentationGroup<T> myGroup;
        boolean myIsFirstInGroup;
        @NotNull
        String myGroupName;
        @NotNull
        Project myProject;
        @NotNull
        UserDataHolder myDataHolder;
        @NotNull
        T myInfo;

        public AttachItem(@NotNull XAttachPresentationGroup<T> group, boolean isFirstInGroup, @NotNull String groupName, @NotNull T info, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
            if (group == null) {
                AttachItem.$$$reportNull$$$0(0);
            }
            if (groupName == null) {
                AttachItem.$$$reportNull$$$0(1);
            }
            if (info == null) {
                AttachItem.$$$reportNull$$$0(2);
            }
            if (project == null) {
                AttachItem.$$$reportNull$$$0(3);
            }
            if (dataHolder == null) {
                AttachItem.$$$reportNull$$$0(4);
            }
            this.myGroup = group;
            this.myIsFirstInGroup = isFirstInGroup;
            this.myInfo = info;
            this.myProject = project;
            this.myDataHolder = dataHolder;
            this.myGroupName = groupName;
        }

        void makeFirstInGroup() {
            this.myIsFirstInGroup = true;
        }

        @NotNull
        XAttachPresentationGroup<T> getGroup() {
            XAttachPresentationGroup<T> xAttachPresentationGroup = this.myGroup;
            if (xAttachPresentationGroup == null) {
                AttachItem.$$$reportNull$$$0(5);
            }
            return xAttachPresentationGroup;
        }

        @Nullable
        String getSeparatorTitle() {
            return this.myIsFirstInGroup ? this.myGroupName : null;
        }

        @Nullable
        protected Icon getIcon(@NotNull Project project) {
            if (project == null) {
                AttachItem.$$$reportNull$$$0(6);
            }
            return this.myGroup.getItemIcon(project, this.myInfo, this.myDataHolder);
        }

        protected abstract boolean hasSubStep();

        protected abstract String getText(@NotNull Project var1);

        @Nullable
        protected abstract String getTooltipText(@NotNull Project var1);

        protected abstract List<AttachToProcessItem> getSubItems();

        @Override
        public int compareTo(AttachItem<T> compareItem) {
            int groupDifference = this.myGroup.getOrder() - compareItem.getGroup().getOrder();
            if (groupDifference != 0) {
                return groupDifference;
            }
            return this.myGroup.compare(this.myInfo, compareItem.myInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$AttachItem";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RecentItem {
        @NotNull
        private final XAttachHost myHost;
        @NotNull
        private final ProcessInfo myProcessInfo;
        @NotNull
        private final XAttachPresentationGroup myGroup;
        @NotNull
        private final String myDebuggerName;

        public RecentItem(@NotNull XAttachHost host, @NotNull AttachToProcessItem item) {
            if (host == null) {
                RecentItem.$$$reportNull$$$0(0);
            }
            if (item == null) {
                RecentItem.$$$reportNull$$$0(1);
            }
            this(host, item.getProcessInfo(), item.getGroup(), item.getSelectedDebugger().getDebuggerDisplayName());
        }

        private RecentItem(@NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull XAttachPresentationGroup group, @NotNull String debuggerName) {
            if (host == null) {
                RecentItem.$$$reportNull$$$0(2);
            }
            if (info == null) {
                RecentItem.$$$reportNull$$$0(3);
            }
            if (group == null) {
                RecentItem.$$$reportNull$$$0(4);
            }
            if (debuggerName == null) {
                RecentItem.$$$reportNull$$$0(5);
            }
            this.myHost = host;
            this.myProcessInfo = info;
            this.myGroup = group;
            this.myDebuggerName = debuggerName;
        }

        public static RecentItem createRecentItem(@NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull XAttachPresentationGroup group, @NotNull String debuggerName) {
            if (host == null) {
                RecentItem.$$$reportNull$$$0(6);
            }
            if (info == null) {
                RecentItem.$$$reportNull$$$0(7);
            }
            if (group == null) {
                RecentItem.$$$reportNull$$$0(8);
            }
            if (debuggerName == null) {
                RecentItem.$$$reportNull$$$0(9);
            }
            return new RecentItem(host, info, group, debuggerName);
        }

        @NotNull
        public XAttachHost getHost() {
            XAttachHost xAttachHost = this.myHost;
            if (xAttachHost == null) {
                RecentItem.$$$reportNull$$$0(10);
            }
            return xAttachHost;
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            ProcessInfo processInfo = this.myProcessInfo;
            if (processInfo == null) {
                RecentItem.$$$reportNull$$$0(11);
            }
            return processInfo;
        }

        @NotNull
        public XAttachPresentationGroup getGroup() {
            XAttachPresentationGroup xAttachPresentationGroup = this.myGroup;
            if (xAttachPresentationGroup == null) {
                RecentItem.$$$reportNull$$$0(12);
            }
            return xAttachPresentationGroup;
        }

        @NotNull
        public String getDebuggerName() {
            String string = this.myDebuggerName;
            if (string == null) {
                RecentItem.$$$reportNull$$$0(13);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecentItem item = (RecentItem)o;
            return Objects.equals(this.myProcessInfo.getCommandLine(), item.myProcessInfo.getCommandLine());
        }

        public int hashCode() {
            return Objects.hash(this.myProcessInfo.getCommandLine());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerName";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$RecentItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToProcessActionBase$RecentItem";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHost";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessInfo";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroup";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createRecentItem";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

