/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.FilterByDetailsResult;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ<\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016JH\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'J4\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J>\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$H\u0002J:\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"002\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$H\u0002J4\u00104\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\"\u0018\u00010$\u0012\u0006\u0012\u0004\u0018\u00010'0\u00112\u0006\u00105\u001a\u0002062\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002JD\u00107\u001a\u00020+2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\"002\u0006\u0010\u001e\u001a\u00020\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J2\u00109\u001a\b\u0012\u0004\u0012\u00020.0\u00172\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\"H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020\"H\u0002J$\u0010@\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010A\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J,\u0010@\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010A\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010(\u001a\u00020DH\u0002J,\u0010@\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$2\u0006\u0010E\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ$\u0010@\u001a\b\u0012\u0004\u0012\u00020\"0$2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010(\u001a\u00020FH\u0002JD\u0010G\u001a\b\u0012\u0004\u0012\u0002HI0H\"\u0004\b\u0000\u0010I2\u0006\u0010A\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020L\u0012\n\u0012\b\u0012\u0004\u0012\u0002HI0M0KH\u0002J<\u0010N\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020>2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"002\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$H\u0002J.\u0010P\u001a\u00020\u001d2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"002\u0006\u0010O\u001a\u00020>2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010$H\u0002J\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020\"0$*\b\u0012\u0004\u0012\u00020.0\u0017H\u0002J\u0018\u0010R\u001a\b\u0012\u0004\u0012\u00020\"0$*\b\u0012\u0004\u0012\u00020S0\u0017H\u0002R\u0016\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "topCommitsDetailsCache", "Lcom/intellij/vcs/log/data/TopCommitsCache;", "commitDetailsGetter", "Lcom/intellij/vcs/log/data/DataGetter;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "(Ljava/util/Map;Lcom/intellij/vcs/log/data/VcsLogStorage;Lcom/intellij/vcs/log/data/TopCommitsCache;Lcom/intellij/vcs/log/data/DataGetter;Lcom/intellij/vcs/log/data/index/VcsLogIndex;)V", "applyHashFilter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "hashes", "", "", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "commitCount", "canFilterEmptyPack", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "createVisibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "", "matchingHeads", "", "matchingCommits", "fileNamesData", "Lcom/intellij/vcs/log/history/FileNamesData;", "filter", "allFilters", "filterByDetails", "Lcom/intellij/vcs/log/visible/FilterByDetailsResult;", "visibleRoots", "filterDetailsInMemory", "Lcom/intellij/vcs/log/CommitId;", "permanentGraph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "detailsFilters", "", "Lcom/intellij/vcs/log/VcsLogDetailsFilter;", "filterWithIndex", "dataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "filterWithVcs", "graph", "filteredDetailsInVcs", "providers", "filterCollection", "maxCount", "getDetailsFromCache", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitIndex", "getMatchingHeads", "refsModel", "Lcom/intellij/vcs/log/data/RefsModel;", "roots", "Lcom/intellij/vcs/log/VcsLogBranchFilter;", "refs", "Lcom/intellij/vcs/log/VcsLogRevisionFilter;", "mapRefsForRoots", "", "T", "mapping", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/data/CompressedRefs;", "", "matchesAllFilters", "commit", "matchesAnyHead", "toCommitIndexes", "toReferencedCommitIndexes", "Lcom/intellij/vcs/log/VcsRef;", "intellij.platform.vcs.log.impl"})
public final class VcsLogFiltererImpl
implements VcsLogFilterer {
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    private final VcsLogStorage storage;
    private final TopCommitsCache topCommitsDetailsCache;
    private final DataGetter<? extends VcsFullCommitDetails> commitDetailsGetter;
    private final VcsLogIndex index;

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        return false;
    }

    @Override
    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection allFilters, @NotNull CommitCountStage commitCount) {
        Intrinsics.checkParameterIsNotNull((Object)dataPack, (String)"dataPack");
        Intrinsics.checkParameterIsNotNull((Object)sortType, (String)"sortType");
        Intrinsics.checkParameterIsNotNull((Object)allFilters, (String)"allFilters");
        Intrinsics.checkParameterIsNotNull((Object)((Object)commitCount), (String)"commitCount");
        VcsLogHashFilter hashFilter = (VcsLogHashFilter)allFilters.get(VcsLogFilterCollection.HASH_FILTER);
        VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.HASH_FILTER;
        Intrinsics.checkExpressionValueIsNotNull((Object)filterKey, (String)"VcsLogFilterCollection.HASH_FILTER");
        VcsLogFilterCollection filters = VcsLogFiltersKt.without(allFilters, filterKey);
        long start2 = System.currentTimeMillis();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            Collection collection = hashFilter.getHashes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"hashFilter.hashes");
            Pair<VisiblePack, CommitCountStage> hashFilterResult = this.applyHashFilter(dataPack, collection, sortType, commitCount);
            if (hashFilterResult != null) {
                VcsLogFiltererImplKt.access$getLOG$p().debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for filtering by " + ((VisiblePack)hashFilterResult.getFirst()).getFilters());
                return hashFilterResult;
            }
        }
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots((Collection<VirtualFile>)dataPack.getLogProviders().keySet(), filters);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"VcsLogUtil.getAllVisible\u2026gProviders.keys, filters)");
        Set<VirtualFile> visibleRoots = set2;
        RefsModel refsModel = dataPack.getRefsModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)refsModel, (String)"dataPack.refsModel");
        Set<Integer> matchingHeads = this.getMatchingHeads(refsModel, (Collection<? extends VirtualFile>)visibleRoots, filters);
        FilterByDetailsResult filterResult = this.filterByDetails(dataPack, filters, commitCount, (Collection<? extends VirtualFile>)visibleRoots, matchingHeads);
        VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, filterResult.getMatchingCommits(), filterResult.getFileNamesData());
        VisiblePack visiblePack = new VisiblePack(dataPack, visibleGraph, filterResult.getCanRequestMore(), filters);
        VcsLogFiltererImplKt.access$getLOG$p().debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for filtering by " + filters);
        return new Pair((Object)visiblePack, (Object)filterResult.getCommitCount());
    }

    @NotNull
    public final VisibleGraph<Integer> createVisibleGraph(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @Nullable Set<Integer> matchingHeads, @Nullable Set<Integer> matchingCommits, @Nullable FileNamesData fileNamesData) {
        VisibleGraph<Integer> visibleGraph;
        Intrinsics.checkParameterIsNotNull((Object)dataPack, (String)"dataPack");
        Intrinsics.checkParameterIsNotNull((Object)sortType, (String)"sortType");
        if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || VcsLogFiltererImplKt.matchesNothing((Collection)matchingCommits)) {
            VisibleGraph<Integer> visibleGraph2 = EmptyVisibleGraph.getInstance();
            visibleGraph = visibleGraph2;
            Intrinsics.checkExpressionValueIsNotNull(visibleGraph2, (String)"EmptyVisibleGraph.getInstance()");
        } else {
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            Intrinsics.checkExpressionValueIsNotNull(permanentGraph, (String)"dataPack.permanentGraph");
            PermanentGraph<Integer> permanentGraph2 = permanentGraph;
            VisibleGraph<Integer> visibleGraph3 = !(permanentGraph2 instanceof PermanentGraphImpl) || fileNamesData == null ? permanentGraph2.createVisibleGraph(sortType, matchingHeads, matchingCommits) : ((PermanentGraphImpl)permanentGraph2).createVisibleGraph(sortType, matchingHeads, matchingCommits, (BiConsumer)new BiConsumer<LinearGraphController, PermanentGraphInfo<Integer>>(fileNamesData){
                final /* synthetic */ FileNamesData $fileNamesData;

                public final void accept(LinearGraphController controller, PermanentGraphInfo<Integer> permanentGraphInfo) {
                    LinearGraphController linearGraphController = controller;
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearGraphController, (String)"controller");
                    PermanentGraphInfo<Integer> permanentGraphInfo2 = permanentGraphInfo;
                    Intrinsics.checkExpressionValueIsNotNull(permanentGraphInfo2, (String)"permanentGraphInfo");
                    FileHistoryKt.removeTrivialMerges(linearGraphController, permanentGraphInfo2, this.$fileNamesData, (Function1<? super Set<Integer>, Unit>)((Function1)createVisibleGraph.1.INSTANCE));
                }
                {
                    this.$fileNamesData = fileNamesData;
                }
            });
            visibleGraph = visibleGraph3;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibleGraph3, (String)"if (permanentGraph !is P\u2026      }\n        }\n      }");
        }
        return visibleGraph;
    }

    @NotNull
    public static /* synthetic */ VisibleGraph createVisibleGraph$default(VcsLogFiltererImpl vcsLogFiltererImpl, DataPack dataPack, PermanentGraph.SortType sortType, Set set2, Set set3, FileNamesData fileNamesData, int n, Object object) {
        if ((n & 0x10) != 0) {
            fileNamesData = null;
        }
        return vcsLogFiltererImpl.createVisibleGraph(dataPack, sortType, set2, set3, fileNamesData);
    }

    /*
     * WARNING - void declaration
     */
    private final FilterByDetailsResult filterByDetails(DataPack dataPack, VcsLogFilterCollection filters, CommitCountStage commitCount, Collection<? extends VirtualFile> visibleRoots, Set<Integer> matchingHeads) {
        Set<Integer> set2;
        VcsLogFilterCollection filtersForVcs;
        void filteredWithIndex;
        Pair<Set<Integer>, FileNamesData> pair;
        void rootsForIndex;
        Pair pair2;
        Collection second$iv;
        ArrayList first$iv;
        List list2 = filters.getDetailsFilters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"filters.detailsFilters");
        List detailsFilters = list2;
        if (detailsFilters.isEmpty()) {
            return new FilterByDetailsResult(null, false, commitCount, null, 8, null);
        }
        IndexDataGetter dataGetter = this.index.getDataGetter();
        if (dataGetter != null && dataGetter.canFilter(detailsFilters)) {
            Iterable $receiver$iv = visibleRoots;
            first$iv = new ArrayList();
            second$iv = new ArrayList();
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (this.index.isIndexed(it)) {
                    first$iv.add(element$iv);
                    continue;
                }
                ((ArrayList)second$iv).add(element$iv);
            }
            pair2 = new Pair(first$iv, second$iv);
        } else {
            pair2 = new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.toList((Iterable)visibleRoots));
        }
        Object object = pair2;
        List list3 = (List)object.component1();
        List rootsForVcs = (List)object.component2();
        second$iv = (Collection)rootsForIndex;
        if (!second$iv.isEmpty()) {
            IndexDataGetter indexDataGetter = dataGetter;
            if (indexDataGetter == null) {
                Intrinsics.throwNpe();
            }
            pair = this.filterWithIndex(indexDataGetter, detailsFilters);
        } else {
            pair = new Pair<Set<Integer>, FileNamesData>(null, null);
        }
        first$iv = pair;
        object = (Set)first$iv.component1();
        FileNamesData namesData = (FileNamesData)first$iv.component2();
        if (rootsForVcs.isEmpty()) {
            return new FilterByDetailsResult((Set<Integer>)filteredWithIndex, false, commitCount, namesData);
        }
        boolean filterAllWithVcs = rootsForVcs.containsAll(visibleRoots);
        VcsLogFilterCollection vcsLogFilterCollection = filtersForVcs = filterAllWithVcs ? filters : VcsLogFiltersKt.with(filters, (VcsLogFilter)VcsLogFilterObject.fromRoots(rootsForVcs));
        if (filterAllWithVcs) {
            set2 = matchingHeads;
        } else {
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)refsModel, (String)"dataPack.refsModel");
            set2 = this.getMatchingHeads(refsModel, (Collection<? extends VirtualFile>)rootsForVcs, filtersForVcs);
        }
        Set<Integer> headsForVcs = set2;
        PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
        Intrinsics.checkExpressionValueIsNotNull(permanentGraph, (String)"dataPack.permanentGraph");
        FilterByDetailsResult filteredWithVcs = this.filterWithVcs(permanentGraph, filtersForVcs, detailsFilters, headsForVcs, commitCount);
        Set<Integer> filteredCommits = VcsLogFiltererImplKt.union(filteredWithIndex, filteredWithVcs.getMatchingCommits());
        return new FilterByDetailsResult(filteredCommits, filteredWithVcs.getCanRequestMore(), filteredWithVcs.getCommitCount(), namesData);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Set<Integer>, FileNamesData> filterWithIndex(IndexDataGetter dataGetter, List<? extends VcsLogDetailsFilter> detailsFilters) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        VcsLogStructureFilter vcsLogStructureFilter = (VcsLogStructureFilter)CollectionsKt.singleOrNull((List)CollectionsKt.filterIsInstance((Iterable)detailsFilters, VcsLogStructureFilter.class));
        if (vcsLogStructureFilter == null) {
            return new Pair(dataGetter.filter(detailsFilters), null);
        }
        VcsLogStructureFilter structureFilter = vcsLogStructureFilter;
        FileNamesData fileNamesData = dataGetter.createFileNamesData(structureFilter.getFiles());
        Intrinsics.checkExpressionValueIsNotNull((Object)fileNamesData, (String)"dataGetter.createFileNam\u2026ta(structureFilter.files)");
        FileNamesData namesData = fileNamesData;
        Iterable iterable = $receiver$iv = (Iterable)detailsFilters;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VcsLogDetailsFilter it = (VcsLogDetailsFilter)element$iv$iv;
            boolean bl = false;
            if (it instanceof VcsLogStructureFilter) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtersWithoutStructure = (List)destination$iv$iv;
        if (filtersWithoutStructure.isEmpty()) {
            return new Pair(namesData.getCommits(), (Object)namesData);
        }
        Set<Integer> set2 = dataGetter.filter(filtersWithoutStructure);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"dataGetter.filter(filtersWithoutStructure)");
        Set<Integer> filteredWithoutStructure = set2;
        return new Pair((Object)CollectionsKt.intersect((Iterable)filteredWithoutStructure, (Iterable)namesData.getCommits()), (Object)namesData);
    }

    private final FilterByDetailsResult filterWithVcs(PermanentGraph<Integer> graph2, VcsLogFilterCollection filters, List<? extends VcsLogDetailsFilter> detailsFilters, Set<Integer> matchingHeads, CommitCountStage commitCount) {
        CommitCountStage commitCountToTry = commitCount;
        if (commitCountToTry == CommitCountStage.INITIAL) {
            Set<Integer> commitsFromMemory = this.toCommitIndexes(this.filterDetailsInMemory(graph2, detailsFilters, matchingHeads));
            if (commitsFromMemory.size() >= commitCountToTry.getCount()) {
                return new FilterByDetailsResult(commitsFromMemory, true, commitCountToTry, null, 8, null);
            }
            CommitCountStage commitCountStage = commitCountToTry.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)commitCountStage), (String)"commitCountToTry.next()");
            commitCountToTry = commitCountStage;
        }
        try {
            Set<Integer> commitsFromVcs = this.toCommitIndexes(this.filteredDetailsInVcs(this.logProviders, filters, commitCountToTry.getCount()));
            return new FilterByDetailsResult(commitsFromVcs, commitsFromVcs.size() >= commitCountToTry.getCount(), commitCountToTry, null, 8, null);
        }
        catch (VcsException e) {
            VcsLogFiltererImplKt.access$getLOG$p().error((Throwable)e);
            return new FilterByDetailsResult(SetsKt.emptySet(), true, commitCountToTry, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CommitId> filteredDetailsInVcs(Map<VirtualFile, ? extends VcsLogProvider> providers, VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        ArrayList arrayList = ContainerUtil.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayList<CommitId>()");
        ArrayList commits = arrayList;
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots((Collection<VirtualFile>)providers.keySet(), filterCollection);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"VcsLogUtil.getAllVisible\u2026s.keys, filterCollection)");
        Set<VirtualFile> visibleRoots = set2;
        for (VirtualFile root : visibleRoots) {
            Collection<CommitId> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            List matchingCommits;
            VcsLogFilterCollection vcsLogFilterCollection;
            Set<FilePath> filesForRoot;
            VcsLogUserFilter userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER);
            if (userFilter != null && userFilter.getUsers(root).isEmpty()) continue;
            Intrinsics.checkExpressionValueIsNotNull(VcsLogUtil.getFilteredFilesForRoot(root, filterCollection), (String)"VcsLogUtil.getFilteredFi\u2026t(root, filterCollection)");
            if (filesForRoot.isEmpty()) {
                VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.STRUCTURE_FILTER;
                Intrinsics.checkExpressionValueIsNotNull((Object)filterKey, (String)"VcsLogFilterCollection.STRUCTURE_FILTER");
                vcsLogFilterCollection = VcsLogFiltersKt.without(filterCollection, filterKey);
            } else {
                vcsLogFilterCollection = VcsLogFiltersKt.with(filterCollection, (VcsLogFilter)VcsLogFilterObject.fromPaths((Collection<? extends FilePath>)filesForRoot));
            }
            VcsLogFilterCollection rootSpecificCollection = vcsLogFilterCollection;
            VcsLogProvider vcsLogProvider = providers.get(root);
            if (vcsLogProvider == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogProvider.getCommitsMatchingFilter(root, rootSpecificCollection, maxCount), (String)"providers[root]!!.getCom\u2026ificCollection, maxCount)");
            Iterable iterable = matchingCommits;
            ArrayList arrayList2 = commits;
            void var13_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void commit2;
                TimedVcsCommit timedVcsCommit = (TimedVcsCommit)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v5 = commit2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"commit");
                CommitId commitId = new CommitId((Hash)v5.getId(), root);
                collection.add(commitId);
            }
            collection = (List)destination$iv$iv;
            arrayList2.addAll((Collection)collection);
        }
        return commits;
    }

    private final Pair<VisiblePack, CommitCountStage> applyHashFilter(DataPack dataPack, Collection<String> hashes, PermanentGraph.SortType sortType, CommitCountStage commitCount) {
        HashSet hashSet = ContainerUtil.newHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"ContainerUtil.newHashSet<Int>()");
        HashSet hashFilterResult = hashSet;
        for (String partOfHash : hashes) {
            if (partOfHash.length() == 40) {
                Intrinsics.checkExpressionValueIsNotNull((Object)HashImpl.build(partOfHash), (String)"HashImpl.build(partOfHash)");
                for (VirtualFile root : dataPack.getLogProviders().keySet()) {
                    Hash hash;
                    if (!this.storage.containsCommit(new CommitId(hash, root))) continue;
                    hashFilterResult.add(this.storage.getCommitIndex(hash, root));
                }
                continue;
            }
            CommitId commitId = this.storage.findCommitId((Condition<? super CommitId>)((Condition)new CommitIdByStringCondition(partOfHash)));
            if (commitId == null) continue;
            hashFilterResult.add(this.storage.getCommitIndex(commitId.getHash(), commitId.getRoot()));
        }
        if (!Registry.is((String)"vcs.log.filter.messages.by.hash")) {
            if (hashFilterResult.isEmpty()) {
                return null;
            }
            VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, (Set)hashFilterResult);
            Intrinsics.checkExpressionValueIsNotNull((Object)visibleGraph, (String)"dataPack.permanentGraph.\u2026, null, hashFilterResult)");
            VisibleGraph visibleGraph2 = visibleGraph;
            VisiblePack visiblePack = new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph2, false, VcsLogFilterObject.collection((VcsLogFilter)VcsLogFilterObject.fromHashes(hashes)));
            return new Pair((Object)visiblePack, (Object)CommitCountStage.ALL);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)hashes);
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayList(hashes)");
        VcsLogTextFilter textFilter = VcsLogFilterObject.fromPatternsList(arrayList, false);
        FilterByDetailsResult textFilterResult = this.filterByDetails(dataPack, VcsLogFilterObject.collection((VcsLogFilter)textFilter), commitCount, (Collection<? extends VirtualFile>)dataPack.getLogProviders().keySet(), null);
        if (hashFilterResult.isEmpty() && VcsLogFiltererImplKt.matchesNothing((Collection)textFilterResult.getMatchingCommits())) {
            return null;
        }
        Set<Integer> filterResult = VcsLogFiltererImplKt.union(textFilterResult.getMatchingCommits(), hashFilterResult);
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, filterResult);
        Intrinsics.checkExpressionValueIsNotNull((Object)visibleGraph, (String)"dataPack.permanentGraph.\u2026Type, null, filterResult)");
        VisibleGraph visibleGraph3 = visibleGraph;
        VisiblePack visiblePack = new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph3, textFilterResult.getCanRequestMore(), VcsLogFilterObject.collection((VcsLogFilter)VcsLogFilterObject.fromHashes(hashes), (VcsLogFilter)textFilter));
        return new Pair((Object)visiblePack, (Object)textFilterResult.getCommitCount());
    }

    @Nullable
    public final Set<Integer> getMatchingHeads(@NotNull RefsModel refs, @NotNull Collection<? extends VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER);
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
        if (branchFilter == null && revisionFilter == null && filters.get(VcsLogFilterCollection.ROOT_FILTER) == null && filters.get(VcsLogFilterCollection.STRUCTURE_FILTER) == null) {
            return null;
        }
        if (revisionFilter != null) {
            if (branchFilter == null) {
                return this.getMatchingHeads(roots, revisionFilter);
            }
            return ContainerUtil.union(this.getMatchingHeads(refs, roots, branchFilter), this.getMatchingHeads(roots, revisionFilter));
        }
        if (branchFilter == null) {
            return this.getMatchingHeads(refs, roots);
        }
        return this.getMatchingHeads(refs, roots, branchFilter);
    }

    private final Set<Integer> getMatchingHeads(RefsModel refsModel, Collection<? extends VirtualFile> roots, VcsLogBranchFilter filter) {
        return this.toReferencedCommitIndexes(this.mapRefsForRoots(refsModel, roots, (Function1)new Function1<CompressedRefs, List<VcsRef>>(filter){
            final /* synthetic */ VcsLogBranchFilter $filter;

            public final List<VcsRef> invoke(@NotNull CompressedRefs refs) {
                Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
                return refs.streamBranches().filter(new Predicate<VcsRef>(this){
                    final /* synthetic */ getMatchingHeads.1 this$0;

                    public final boolean test(VcsRef it) {
                        VcsLogBranchFilter vcsLogBranchFilter = this.this$0.$filter;
                        VcsRef vcsRef = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)vcsRef, (String)"it");
                        return vcsLogBranchFilter.matches(vcsRef.getName());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).collect(Collectors.toList());
            }
            {
                this.$filter = vcsLogBranchFilter;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getMatchingHeads(Collection<? extends VirtualFile> roots, VcsLogRevisionFilter filter) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Collection collection = filter.getHeads();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filter.heads");
        Iterable iterable = collection;
        VcsLogFiltererImpl vcsLogFiltererImpl = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CommitId it = (CommitId)element$iv$iv;
            boolean bl = false;
            CommitId commitId = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)commitId, (String)"it");
            if (!roots.contains(commitId.getRoot())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return vcsLogFiltererImpl.toCommitIndexes(list2);
    }

    private final Set<Integer> getMatchingHeads(RefsModel refsModel, Collection<? extends VirtualFile> roots) {
        return this.mapRefsForRoots(refsModel, roots, getMatchingHeads.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Set<T> mapRefsForRoots(RefsModel refsModel, Collection<? extends VirtualFile> roots, Function1<? super CompressedRefs, ? extends Iterable<? extends T>> mapping) {
        void destination$iv;
        Map<VirtualFile, CompressedRefs> map2 = refsModel.getAllRefsByRoot();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"refsModel.allRefsByRoot");
        Object $receiver$iv = map2;
        Object result$iv = new LinkedHashMap();
        Object object = $receiver$iv;
        for (Map.Entry<VirtualFile, CompressedRefs> entry$iv : object.entrySet()) {
            VirtualFile it = entry$iv.getKey();
            boolean bl = false;
            if (!roots.contains(it)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        $receiver$iv = ((Map)result$iv).values();
        result$iv = new LinkedHashSet();
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            Iterable list$iv = (Iterable)mapping.invoke(element$iv);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    private final Collection<CommitId> filterDetailsInMemory(PermanentGraph<Integer> permanentGraph, List<? extends VcsLogDetailsFilter> detailsFilters, Set<Integer> matchingHeads) {
        ArrayList arrayList = ContainerUtil.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayList<CommitId>()");
        ArrayList result2 = arrayList;
        Iterator iterator = permanentGraph.getAllCommits().iterator();
        while (iterator.hasNext()) {
            VcsCommitMetadata data;
            GraphCommit commit2;
            GraphCommit graphCommit = commit2 = (GraphCommit)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)graphCommit, (String)"commit");
            Object object = graphCommit.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"commit.id");
            if (this.getDetailsFromCache(((Number)object).intValue()) == null) {
                break;
            }
            if (!this.matchesAllFilters(data, permanentGraph, detailsFilters, matchingHeads)) continue;
            result2.add(new CommitId((Hash)data.getId(), data.getRoot()));
        }
        return result2;
    }

    private final boolean matchesAllFilters(VcsCommitMetadata commit2, PermanentGraph<Integer> permanentGraph, List<? extends VcsLogDetailsFilter> detailsFilters, Set<Integer> matchingHeads) {
        boolean matchesAllDetails2 = ContainerUtil.and((Iterable)detailsFilters, (Condition)new Condition<T>(commit2){
            final /* synthetic */ VcsCommitMetadata $commit;

            public final boolean value(VcsLogDetailsFilter filter) {
                return filter.matches(this.$commit);
            }
            {
                this.$commit = vcsCommitMetadata;
            }
        });
        return matchesAllDetails2 && this.matchesAnyHead(permanentGraph, commit2, matchingHeads);
    }

    private final boolean matchesAnyHead(PermanentGraph<Integer> permanentGraph, VcsCommitMetadata commit2, Set<Integer> matchingHeads) {
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.storage.getCommitIndex((Hash)commit2.getId(), commit2.getRoot());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), (Collection)matchingHeads);
    }

    private final VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        VcsCommitMetadata vcsCommitMetadata = this.topCommitsDetailsCache.get(commitIndex);
        if (vcsCommitMetadata == null) {
            vcsCommitMetadata = (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded((Computable)((Computable)new Computable<VcsCommitMetadata>(this, commitIndex){
                final /* synthetic */ VcsLogFiltererImpl this$0;
                final /* synthetic */ int $commitIndex;

                @Nullable
                public final VcsFullCommitDetails compute() {
                    return (VcsFullCommitDetails)VcsLogFiltererImpl.access$getCommitDetailsGetter$p(this.this$0).getCommitDataIfAvailable(this.$commitIndex);
                }
                {
                    this.this$0 = vcsLogFiltererImpl;
                    this.$commitIndex = n;
                }
            }));
        }
        return vcsCommitMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> toCommitIndexes(@NotNull Collection<? extends CommitId> $receiver) {
        void var3_3;
        void $receiver$iv;
        Iterable iterable = $receiver;
        Collection destination$iv = new LinkedHashSet();
        for (Object item$iv : $receiver$iv) {
            void commitId;
            CommitId commitId2 = (CommitId)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Integer n = this.storage.getCommitIndex(commitId.getHash(), commitId.getRoot());
            collection.add(n);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> toReferencedCommitIndexes(@NotNull Collection<? extends VcsRef> $receiver) {
        void var3_3;
        void $receiver$iv;
        Iterable iterable = $receiver;
        Collection destination$iv = new LinkedHashSet();
        for (Object item$iv : $receiver$iv) {
            void ref;
            VcsRef vcsRef = (VcsRef)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Integer n = this.storage.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            collection.add(n);
        }
        return (Set)var3_3;
    }

    public VcsLogFiltererImpl(@NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull VcsLogStorage storage2, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull DataGetter<? extends VcsFullCommitDetails> commitDetailsGetter, @NotNull VcsLogIndex index) {
        Intrinsics.checkParameterIsNotNull(logProviders, (String)"logProviders");
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)topCommitsDetailsCache, (String)"topCommitsDetailsCache");
        Intrinsics.checkParameterIsNotNull(commitDetailsGetter, (String)"commitDetailsGetter");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        this.logProviders = logProviders;
        this.storage = storage2;
        this.topCommitsDetailsCache = topCommitsDetailsCache;
        this.commitDetailsGetter = commitDetailsGetter;
        this.index = index;
    }

    public static final /* synthetic */ DataGetter access$getCommitDetailsGetter$p(VcsLogFiltererImpl $this) {
        return $this.commitDetailsGetter;
    }
}

