/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.google.common.primitives.Ints;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileHistorySingleCommitAction<T extends VcsCommitMetadata>
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        FileHistoryUi ui = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        if (project == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        List<T> details = this.getSelection(ui);
        if (details.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VcsCommitMetadata detail = (VcsCommitMetadata)ContainerUtil.getFirstItem(details);
        if (detail instanceof LoadingDetails) {
            detail = null;
        }
        e.getPresentation().setEnabled(details.size() == 1 && this.isEnabled(ui, detail, e));
    }

    protected boolean isEnabled(@NotNull FileHistoryUi ui, @Nullable T detail, @NotNull AnActionEvent e) {
        if (ui == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(1);
        }
        if (e == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FileHistorySingleCommitAction.$$$reportNull$$$0(3);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileHistoryUi ui = (FileHistoryUi)e.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        List commits = ui.getVcsLog().getSelectedCommits();
        if (commits.size() != 1) {
            return;
        }
        CommitId commit2 = (CommitId)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)commits));
        List commitIndex = Ints.asList((int[])new int[]{ui.getLogData().getCommitIndex(commit2.getHash(), commit2.getRoot())});
        this.getDetailsGetter(ui).loadCommitsData(commitIndex, details -> {
            if (!details.isEmpty()) {
                this.performAction(project, ui, (VcsCommitMetadata)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)details)), e);
            }
        }, (Consumer<Throwable>)((Consumer)t -> VcsBalloonProblemNotifier.showOverChangesView(project, "Could not load selected commits: " + t.getMessage(), MessageType.ERROR, new NamedRunnable[0])), null);
    }

    @NotNull
    protected abstract List<T> getSelection(@NotNull FileHistoryUi var1);

    @NotNull
    protected abstract DataGetter<T> getDetailsGetter(@NotNull FileHistoryUi var1);

    protected abstract void performAction(@NotNull Project var1, @NotNull FileHistoryUi var2, @NotNull T var3, @NotNull AnActionEvent var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/FileHistorySingleCommitAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

