/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.navigation.History;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.FileHistoryDiffPreview;
import com.intellij.vcs.log.history.FileHistoryFilterUi;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.history.VcsLogFileRevision;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionListener;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    private static final String HELP_ID = "reference.versionControl.toolwindow.history";
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private final Hash myRevision;
    @NotNull
    private final VcsLogDiffHandler myDiffHandler;
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;
    @Nullable
    private final FileHistoryDiffPreview myDiffPreview;
    @Nullable
    private final OnePixelSplitter myDiffPreviewSplitter;
    @NotNull
    private final JComponent myMainComponent;
    @NotNull
    private final Set<String> myHighlighterIds;
    @NotNull
    private final MyPropertiesChangeListener myPropertiesChangeListener;
    @NotNull
    private final History myHistory;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path, @Nullable Hash revision, @NotNull VirtualFile root) {
        if (logData == null) {
            FileHistoryUi.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FileHistoryUi.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            FileHistoryUi.$$$reportNull$$$0(3);
        }
        if (path == null) {
            FileHistoryUi.$$$reportNull$$$0(4);
        }
        if (root == null) {
            FileHistoryUi.$$$reportNull$$$0(5);
        }
        super(FileHistoryUi.getFileHistoryLogId(path, revision), logData, manager, refresher);
        this.myPath = path;
        this.myRoot = root;
        this.myRevision = revision;
        this.myUiProperties = uiProperties;
        this.myDiffHandler = (VcsLogDiffHandler)ObjectUtils.notNull((Object)logData.getLogProvider(root).getDiffHandler());
        this.myFilterUi = new FileHistoryFilterUi(path, revision, root, uiProperties);
        this.myFileHistoryPanel = new FileHistoryPanel(this, logData, this.myVisiblePack, path);
        if (!this.myPath.isDirectory()) {
            this.myDiffPreview = new FileHistoryDiffPreview(this.myProject, (Function0<? extends Change>)((Function0)() -> this.getSelectedChange()), this);
            ListSelectionListener selectionListener = e -> {
                int[] selection = this.getTable().getSelectedRows();
                ApplicationManager.getApplication().invokeLater(() -> this.myDiffPreview.updatePreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW)), o -> !Arrays.equals(selection, this.getTable().getSelectedRows()));
            };
            this.getTable().getSelectionModel().addListSelectionListener(selectionListener);
            this.myDiffPreviewSplitter = new OnePixelSplitter(false, "vcs.history.diff.splitter.proportion", 0.7f);
            this.myDiffPreviewSplitter.setHonorComponentsMinimumSize(false);
            this.myDiffPreviewSplitter.setFirstComponent((JComponent)this.myFileHistoryPanel);
            this.showDiffPreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
            this.myMainComponent = this.myDiffPreviewSplitter;
        } else {
            this.myDiffPreview = null;
            this.myDiffPreviewSplitter = null;
            this.myMainComponent = this.myFileHistoryPanel;
        }
        this.myHighlighterIds = this.myRevision == null ? ContainerUtil.newHashSet((Object[])new String[]{"MY_COMMITS", "CURRENT_BRANCH"}) : Collections.singleton("MY_COMMITS");
        for (VcsLogHighlighterFactory factory : ContainerUtil.filter((Object[])LOG_HIGHLIGHTER_FACTORY_EP.getExtensions((AreaInstance)this.myProject), f -> this.isHighlighterEnabled(f.getId()))) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        if (this.myRevision != null) {
            this.getTable().addHighlighter(new RevisionHistoryHighlighter(this.myLogData.getStorage(), this.myRevision, this.myRoot));
        }
        this.myPropertiesChangeListener = new MyPropertiesChangeListener();
        this.myUiProperties.addChangeListener(this.myPropertiesChangeListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
    }

    @NotNull
    public static String getFileHistoryLogId(@NotNull FilePath path, @Nullable Hash revision) {
        if (path == null) {
            FileHistoryUi.$$$reportNull$$$0(6);
        }
        String string = path.getPath() + (revision == null ? "" : revision.asString());
        if (string == null) {
            FileHistoryUi.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean hasDiffPreview() {
        return this.myDiffPreview != null;
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsCommitMetadata commit2) {
        if (commit2 == null) {
            return null;
        }
        if (this.isFileDeletedInCommit((Hash)commit2.getId())) {
            return VcsFileRevision.NULL;
        }
        FilePath path = this.getPathInCommit((Hash)commit2.getId());
        if (path == null) {
            return null;
        }
        return new VcsLogFileRevision(commit2, this.myDiffHandler.createContentRevision(path, (Hash)commit2.getId()), path, false);
    }

    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryUi.$$$reportNull$$$0(8);
        }
        if (this.myPath.isDirectory()) {
            return this.myPath;
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryVisiblePack.filePath(this.myVisiblePack, commitIndex);
    }

    private boolean isFileDeletedInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryUi.$$$reportNull$$$0(9);
        }
        if (this.myPath.isDirectory()) {
            return false;
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryVisiblePack.isDeletedInCommit(this.myVisiblePack, commitIndex);
    }

    @NotNull
    List<Change> collectRelevantChanges(@NotNull VcsFullCommitDetails details) {
        FilePath filePath;
        if (details == null) {
            FileHistoryUi.$$$reportNull$$$0(10);
        }
        if ((filePath = this.getPathInCommit((Hash)details.getId())) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                FileHistoryUi.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<Change> list3 = FileHistoryUtil.collectRelevantChanges(details, (Condition<? super Change>)((Condition)change -> filePath.isDirectory() ? FileHistoryUtil.affectsDirectory(change, filePath) : FileHistoryUtil.affectsFile(change, filePath, this.isFileDeletedInCommit((Hash)details.getId()))));
        if (list3 == null) {
            FileHistoryUi.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @Nullable
    public Change getSelectedChange() {
        if (this.myPath.isDirectory()) {
            return null;
        }
        int[] rows = this.getTable().getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        int row2 = rows[0];
        List<Integer> parentRows = rows.length == 1 ? this.myVisiblePack.getVisibleGraph().getRowInfo(row2).getAdjacentRows(true) : Collections.singletonList(rows[rows.length - 1]);
        return FileHistoryUtil.createChangeToParents(row2, parentRows, this.myVisiblePack, this.myDiffHandler, this.myLogData);
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            FileHistoryUi.$$$reportNull$$$0(13);
        }
        if (rowGetter == null) {
            FileHistoryUi.$$$reportNull$$$0(14);
        }
        if (!commitExists) {
            super.handleCommitNotFound(commitId, false, rowGetter);
            return;
        }
        String mainText = "Commit " + FileHistoryUi.getCommitPresentation(commitId) + " does not exist in history for " + this.myPath.getName();
        if (this.getFilterUi().getFilters().get(VcsLogFilterCollection.BRANCH_FILTER) != null) {
            this.showWarningWithLink(mainText + " in current branch", "View and Show All Branches", () -> {
                this.myUiProperties.set(FileHistoryUiProperties.SHOW_ALL_BRANCHES, true);
                this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create()));
            });
        } else {
            VcsLogUiImpl mainLogUi = VcsProjectLog.getInstance(this.myProject).getMainLogUi();
            if (mainLogUi != null) {
                this.showWarningWithLink(mainText, "View in Log", () -> {
                    if (VcsLogContentUtil.selectLogUi(this.myProject, mainLogUi)) {
                        if (commitId instanceof Hash) {
                            mainLogUi.jumpToCommit((Hash)commitId, this.myRoot, (SettableFuture<? super Boolean>)SettableFuture.create());
                        } else if (commitId instanceof String) {
                            mainLogUi.jumpToCommitByPartOfHash((String)commitId, (SettableFuture<? super Boolean>)SettableFuture.create());
                        }
                    }
                });
            }
        }
    }

    public boolean matches(@NotNull FilePath targetPath, @Nullable Hash targetRevision) {
        if (targetPath == null) {
            FileHistoryUi.$$$reportNull$$$0(15);
        }
        return this.myPath.equals(targetPath) && Objects.equals(this.myRevision, targetRevision);
    }

    private void showDiffPreview(boolean state) {
        if (this.myDiffPreview != null) {
            this.myDiffPreview.updatePreview(state);
            this.myDiffPreviewSplitter.setSecondComponent(state ? this.myDiffPreview.getComponent() : null);
        }
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        FileHistoryFilterUi fileHistoryFilterUi = this.myFilterUi;
        if (fileHistoryFilterUi == null) {
            FileHistoryUi.$$$reportNull$$$0(16);
        }
        return fileHistoryFilterUi;
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        if (id == null) {
            FileHistoryUi.$$$reportNull$$$0(17);
        }
        return this.myHighlighterIds.contains(id);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
        if (this.myDiffPreview != null) {
            this.myDiffPreview.updatePreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
        }
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myFileHistoryPanel.getGraphTable();
        if (vcsLogGraphTable == null) {
            FileHistoryUi.$$$reportNull$$$0(18);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        JComponent jComponent = this.myMainComponent;
        if (jComponent == null) {
            FileHistoryUi.$$$reportNull$$$0(19);
        }
        return jComponent;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    private void updateFilter() {
        this.myRefresher.onFiltersChange(this.myFilterUi.getFilters());
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        FileHistoryUiProperties fileHistoryUiProperties = this.myUiProperties;
        if (fileHistoryUiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(20);
        }
        return fileHistoryUiProperties;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesChangeListener);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileHistoryLogId";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRelevantChanges";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileHistoryLogId";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathInCommit";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFileDeletedInCommit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectRelevantChanges";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RevisionHistoryHighlighter
    implements VcsLogHighlighter {
        @NotNull
        private final JBColor myBgColor;
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Hash myRevision;
        @NotNull
        private final VirtualFile myRoot;
        @Nullable
        private Condition<Integer> myCondition;
        @NotNull
        private VcsLogDataPack myVisiblePack;

        RevisionHistoryHighlighter(@NotNull VcsLogStorage storage2, @NotNull Hash revision, @NotNull VirtualFile root) {
            if (storage2 == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(1);
            }
            if (root == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(2);
            }
            this.myBgColor = JBColor.namedColor((String)"VersionControl.FileHistory.Commit.selectedBranchBackground", (Color)new JBColor(new Color(0xFFFEE4), new Color(4802879)));
            this.myVisiblePack = VisiblePack.EMPTY;
            this.myStorage = storage2;
            this.myRevision = revision;
            this.myRoot = root;
        }

        @NotNull
        public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, boolean isSelected) {
            if (commitDetails == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(3);
            }
            if (isSelected) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
                if (vcsCommitStyle == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(4);
                }
                return vcsCommitStyle;
            }
            if (this.myCondition == null) {
                this.myCondition = this.getCondition();
            }
            if (this.myCondition.value((Object)commitId)) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)this.myBgColor);
                if (vcsCommitStyle == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(5);
                }
                return vcsCommitStyle;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(6);
            }
            return vcsCommitStyle;
        }

        @NotNull
        private Condition<Integer> getCondition() {
            if (!(this.myVisiblePack instanceof VisiblePack)) {
                Condition condition = Conditions.alwaysFalse();
                if (condition == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(7);
                }
                return condition;
            }
            DataPackBase dataPack = ((VisiblePack)this.myVisiblePack).getDataPack();
            if (!(dataPack instanceof DataPack)) {
                Condition condition = Conditions.alwaysFalse();
                if (condition == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(8);
                }
                return condition;
            }
            Set<Integer> heads = Collections.singleton(this.myStorage.getCommitIndex(this.myRevision, this.myRoot));
            Condition condition = ((DataPack)dataPack).getPermanentGraph().getContainedInBranchCondition(heads);
            if (condition == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(9);
            }
            return condition;
        }

        public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
            if (dataPack == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(10);
            }
            this.myVisiblePack = dataPack;
            this.myCondition = this.myVisiblePack.getFilters().get(VcsLogFilterCollection.REVISION_FILTER) != null ? Conditions.alwaysFalse() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitDetails";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUi$RevisionHistoryHighlighter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUi$RevisionHistoryHighlighter";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyle";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getStyle";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                MyPropertiesChangeListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (FileHistoryUiProperties.SHOW_ALL_BRANCHES.equals(property)) {
                FileHistoryUi.this.updateFilter();
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                FileHistoryUi.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                FileHistoryUi.this.getTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            } else if (CommonUiProperties.SHOW_DIFF_PREVIEW.equals(property)) {
                FileHistoryUi.this.showDiffPreview(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/history/FileHistoryUi$MyPropertiesChangeListener", "onPropertyChanged"));
        }
    }
}

