/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.GraphModificationUtilKt;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryRefiner;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001 B\u001f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J2\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J9\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\u0013\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder;", "Ljava/util/function/BiConsumer;", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "startCommit", "startPath", "Lcom/intellij/openapi/vcs/FilePath;", "fileNamesData", "Lcom/intellij/vcs/log/history/FileNamesData;", "(Ljava/lang/Integer;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/history/FileNamesData;)V", "pathsMap", "", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "getPathsMap", "()Ljava/util/Map;", "Ljava/lang/Integer;", "accept", "", "controller", "permanentGraphInfo", "findAncestorRowAffectingFile", "Lkotlin/Pair;", "commitId", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "refine", "", "(Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;Ljava/lang/Integer;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;)Ljava/util/Map;", "reportTrivialMerges", "trivialMerges", "", "Companion", "intellij.platform.vcs.log.impl"})
public final class FileHistoryBuilder
implements BiConsumer<LinearGraphController, PermanentGraphInfo<Integer>> {
    @NotNull
    private final Map<Integer, MaybeDeletedFilePath> pathsMap;
    private final Integer startCommit;
    private final FilePath startPath;
    private final FileNamesData fileNamesData;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Map<Integer, MaybeDeletedFilePath> getPathsMap() {
        return this.pathsMap;
    }

    @Override
    public void accept(@NotNull LinearGraphController controller, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        Intrinsics.checkParameterIsNotNull(permanentGraphInfo, (String)"permanentGraphInfo");
        boolean needToRepeat2 = FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileNamesData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>(this){

            public final void invoke(@NotNull Set<Integer> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(FileHistoryBuilder.class);
            }

            public final String getName() {
                return "reportTrivialMerges";
            }

            public final String getSignature() {
                return "reportTrivialMerges(Ljava/util/Set;)V";
            }
        }));
        this.pathsMap.putAll(this.refine(controller, this.startCommit, permanentGraphInfo));
        if (needToRepeat2) {
            LOG.info("Some merge commits were not excluded from file history for " + this.startPath.getPath());
            FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileNamesData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>(this){

                public final void invoke(@NotNull Set<Integer> p1) {
                    Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                    FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(FileHistoryBuilder.class);
                }

                public final String getName() {
                    return "reportTrivialMerges";
                }

                public final String getSignature() {
                    return "reportTrivialMerges(Ljava/util/Set;)V";
                }
            }));
        }
    }

    private final void reportTrivialMerges(Set<Integer> trivialMerges2) {
        LOG.debug("Excluding " + trivialMerges2.size() + " trivial merges from history for " + this.startPath.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, MaybeDeletedFilePath> refine(LinearGraphController controller, Integer startCommit, PermanentGraphInfo<Integer> permanentGraphInfo) {
        block6: {
            void row2;
            Object object;
            Pair<Integer, MaybeDeletedFilePath> pair;
            LinearGraph visibleLinearGraph;
            block8: {
                block7: {
                    if (!this.fileNamesData.getHasRenames() || !Registry.is((String)"vcs.history.refine")) break block6;
                    LinearGraph linearGraph = controller.getCompiledGraph();
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearGraph, (String)"controller.compiledGraph");
                    visibleLinearGraph = linearGraph;
                    pair = startCommit;
                    if (pair == null) break block7;
                    object = pair;
                    int it = ((Number)object).intValue();
                    boolean bl = false;
                    pair = this.findAncestorRowAffectingFile(startCommit.intValue(), visibleLinearGraph, permanentGraphInfo);
                    if (pair != null) break block8;
                }
                pair = new Pair((Object)0, (Object)new MaybeDeletedFilePath(this.startPath));
            }
            Pair<Integer, MaybeDeletedFilePath> pair2 = pair;
            int n = ((Number)pair2.component1()).intValue();
            MaybeDeletedFilePath path = (MaybeDeletedFilePath)pair2.component2();
            if (row2 >= 0) {
                void paths;
                FileHistoryRefiner refiner = new FileHistoryRefiner(visibleLinearGraph, permanentGraphInfo, this.fileNamesData);
                Pair<HashMap<Integer, MaybeDeletedFilePath>, HashSet<Integer>> bl = refiner.refine((int)row2, path);
                object = (HashMap)bl.component1();
                HashSet excluded = (HashSet)bl.component2();
                if (!excluded.isEmpty()) {
                    LOG.info("Excluding " + excluded.size() + " commits from history for " + this.startPath.getPath());
                    boolean hidden = GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, excluded);
                    if (!hidden) {
                        LOG.error("Could not hide excluded commits from history for " + this.startPath.getPath());
                    }
                }
                return (Map)paths;
            }
        }
        return this.fileNamesData.buildPathsMap();
    }

    private final Pair<Integer, MaybeDeletedFilePath> findAncestorRowAffectingFile(int commitId, LinearGraph visibleLinearGraph, PermanentGraphInfo<Integer> permanentGraphInfo) {
        MaybeDeletedFilePath existing = new MaybeDeletedFilePath(this.startPath);
        MaybeDeletedFilePath deleted = new MaybeDeletedFilePath(this.startPath, true);
        Ref ref = Ref.create((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"Ref.create(false)");
        Ref isDeleted = ref;
        Integer n = ReachableNodesUtilKt.findVisibleAncestorRow(commitId, visibleLinearGraph, permanentGraphInfo, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(this, permanentGraphInfo, existing, deleted, isDeleted){
            final /* synthetic */ FileHistoryBuilder this$0;
            final /* synthetic */ PermanentGraphInfo $permanentGraphInfo;
            final /* synthetic */ MaybeDeletedFilePath $existing;
            final /* synthetic */ MaybeDeletedFilePath $deleted;
            final /* synthetic */ Ref $isDeleted;

            public final boolean invoke(int nodeId) {
                boolean bl;
                CommitId CommitId2 = this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
                Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentGraphInfo.perma\u2026sInfo.getCommitId(nodeId)");
                int id = ((Number)CommitId2).intValue();
                if (FileNamesData.affects$default(FileHistoryBuilder.access$getFileNamesData$p(this.this$0), id, this.$existing, false, 4, null)) {
                    bl = true;
                } else if (FileNamesData.affects$default(FileHistoryBuilder.access$getFileNamesData$p(this.this$0), id, this.$deleted, false, 4, null)) {
                    this.$isDeleted.set((Object)true);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = fileHistoryBuilder;
                this.$permanentGraphInfo = permanentGraphInfo;
                this.$existing = maybeDeletedFilePath;
                this.$deleted = maybeDeletedFilePath2;
                this.$isDeleted = ref;
                super(1);
            }
        }));
        int row2 = n != null ? n : -1;
        Integer n2 = row2;
        Object object = isDeleted.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"isDeleted.get()");
        return new Pair((Object)n2, (Object)((Boolean)object != false ? deleted : existing));
    }

    public FileHistoryBuilder(@Nullable Integer startCommit, @NotNull FilePath startPath, @NotNull FileNamesData fileNamesData) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)startPath, (String)"startPath");
        Intrinsics.checkParameterIsNotNull((Object)fileNamesData, (String)"fileNamesData");
        this.startCommit = startCommit;
        this.startPath = startPath;
        this.fileNamesData = fileNamesData;
        FileHistoryBuilder fileHistoryBuilder = this;
        fileHistoryBuilder.pathsMap = map2 = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FileHistoryBuilder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(FileHistoryBuilder::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$reportTrivialMerges(FileHistoryBuilder $this, Set trivialMerges2) {
        $this.reportTrivialMerges(trivialMerges2);
    }

    public static final /* synthetic */ FileNamesData access$getFileNamesData$p(FileHistoryBuilder $this) {
        return $this.fileNamesData;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

