/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TouchBar;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemPopover
extends TBItem {
    private final Icon myIcon;
    private final String myText;
    private final int myWidthPix;
    private TouchBar myExpandTB;
    private TouchBar myTapAndHoldTB;

    TBItemPopover(@NotNull String uid, @Nullable ItemListener listener2, Icon icon, String text, int widthInPix, TouchBar expandTB, TouchBar tapAndHoldTB) {
        if (uid == null) {
            TBItemPopover.$$$reportNull$$$0(0);
        }
        super(uid, listener2);
        this.myIcon = icon != null ? IconLoader.getDarkIcon((Icon)icon, (boolean)true) : null;
        this.myText = text;
        this.myWidthPix = widthInPix;
        this.myExpandTB = expandTB;
        this.myTapAndHoldTB = tapAndHoldTB;
    }

    @Override
    void releaseNativePeer() {
        if (this.myExpandTB != null) {
            this.myExpandTB.release();
        }
        if (this.myTapAndHoldTB != null) {
            this.myTapAndHoldTB.release();
        }
        this.myExpandTB = null;
        this.myTapAndHoldTB = null;
        super.releaseNativePeer();
    }

    @Override
    protected void _updateNativePeer() {
        NST.updatePopover(this.myNativePeer, this.myWidthPix, this.myText, this.myIcon, TBItemPopover.getNativePeer(this.myExpandTB), TBItemPopover.getNativePeer(this.myTapAndHoldTB));
    }

    @Override
    protected ID _createNativePeer() {
        return NST.createPopover(this.myUid, this.myWidthPix, this.myText, this.myIcon, TBItemPopover.getNativePeer(this.myExpandTB), TBItemPopover.getNativePeer(this.myTapAndHoldTB));
    }

    private static ID getNativePeer(TouchBar tb) {
        return tb == null ? ID.NIL : tb.getNativePeer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uid", "com/intellij/ui/mac/touchbar/TBItemPopover", "<init>"));
    }
}

