/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItem;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemButton
extends TBItem {
    @Nullable
    protected Icon myOriginIcon;
    @Nullable
    protected Icon myIcon;
    @Nullable
    protected String myText;
    protected int myLayoutBits;
    protected int myFlags;
    protected boolean myHasArrowIcon;
    protected int myUpdateOptions;
    @Nullable
    private Runnable myAction;
    @Nullable
    private NSTLibrary.Action myNativeCallback;

    TBItemButton(@NotNull String uid, @Nullable ItemListener listener2) {
        if (uid == null) {
            TBItemButton.$$$reportNull$$$0(0);
        }
        super(uid, listener2);
        this.myLayoutBits = 0;
        this.myFlags = 0;
        this.myHasArrowIcon = false;
    }

    TBItemButton setIcon(Icon icon) {
        if (icon != null) {
            icon = IconLoader.getDarkIcon((Icon)icon, (boolean)true);
        }
        if (!TBItemButton._equals(icon, this.myIcon)) {
            this.myIcon = icon;
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 8;
                this._updateNativePeer();
            }
        }
        return this;
    }

    TBItemButton setHasArrowIcon(boolean hasArrowIcon) {
        if (hasArrowIcon != this.myHasArrowIcon) {
            this.myHasArrowIcon = hasArrowIcon;
            if (this.myNativePeer != ID.NIL) {
                Icon ic = this.myHasArrowIcon ? IconLoader.getIcon((String)"/mac/touchbar/popoverArrow_dark.svg") : null;
                NST.setArrowImage(this.myNativePeer, ic);
            }
        }
        return this;
    }

    TBItemButton setText(String text) {
        if (!Comparing.equal((String)text, (String)this.myText)) {
            this.myText = text;
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 4;
                this._updateNativePeer();
            }
        }
        return this;
    }

    TBItemButton setActionOnEDT(Runnable action) {
        return this.setAction(action, true, null);
    }

    TBItemButton setThreadSafeAction(Runnable action) {
        return this.setAction(action, false, null);
    }

    TBItemButton setAction(Runnable action, boolean executeOnEDT, ModalityState modality) {
        if (action != this.myAction) {
            this.myAction = action;
            this.myNativeCallback = this.myAction == null ? null : () -> {
                if (executeOnEDT) {
                    Application app = ApplicationManager.getApplication();
                    if (app != null) {
                        if (modality != null) {
                            app.invokeLater(this.myAction, modality);
                        } else {
                            app.invokeLater(this.myAction);
                        }
                    } else {
                        SwingUtilities.invokeLater(this.myAction);
                    }
                } else {
                    this.myAction.run();
                }
                if (this.myListener != null) {
                    this.myListener.onItemEvent(this, 0);
                }
            };
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 0x10;
                this._updateNativePeer();
            }
        }
        return this;
    }

    TBItemButton setWidth(int width) {
        return this.setLayout(width, 0, 2, 8);
    }

    TBItemButton setLayout(int width, int widthFlags, int margin, int border) {
        if (width < 0) {
            width = 0;
        }
        if (margin < 0) {
            margin = 0;
        }
        if (border < 0) {
            border = 0;
        }
        int newLayout = width & 0xFFF;
        newLayout |= widthFlags;
        newLayout |= NSTLibrary.margin2mask((byte)margin);
        if (this.myLayoutBits != (newLayout |= NSTLibrary.border2mask((byte)border))) {
            this.myLayoutBits = newLayout;
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 1;
                this._updateNativePeer();
            }
        }
        return this;
    }

    TBItemButton setPriority(byte prio) {
        int flags = this.myFlags | NSTLibrary.priority2mask(prio);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 2;
                this._updateNativePeer();
            }
        }
        return this;
    }

    TBItemButton setToggle(boolean toggle) {
        int flags = TBItemButton._applyFlag(this.myFlags, toggle, 8);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 2;
                this._updateNativePeer();
            }
        }
        return this;
    }

    TBItemButton setColored(boolean isColored) {
        int flags = TBItemButton._applyFlag(this.myFlags, isColored, 4);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 2;
                this._updateNativePeer();
            }
        }
        return this;
    }

    TBItemButton setTransparentBg(boolean isTransparentBg) {
        int flags = TBItemButton._applyFlag(this.myFlags, isTransparentBg, 16);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            if (this.myNativePeer != ID.NIL) {
                this.myUpdateOptions |= 2;
                this._updateNativePeer();
            }
        }
        return this;
    }

    synchronized void update(Icon icon, String text, boolean isSelected, boolean isDisabled) {
        boolean isIconChanged = false;
        if (!TBItemButton._equals(icon, this.myOriginIcon)) {
            this.myOriginIcon = icon;
            this.myIcon = this.myOriginIcon != null ? IconLoader.getDarkIcon((Icon)this.myOriginIcon, (boolean)true) : null;
            isIconChanged = true;
        }
        int flags = TBItemButton._applyFlag(this.myFlags, isSelected, 2);
        flags = TBItemButton._applyFlag(flags, isDisabled, 1);
        if (this.myNativePeer != ID.NIL) {
            if (isIconChanged) {
                this.myUpdateOptions |= 8;
            }
            if (!Comparing.equal((String)text, (String)this.myText)) {
                this.myUpdateOptions |= 4;
            }
            if (flags != this.myFlags) {
                this.myUpdateOptions |= 2;
            }
        }
        this.myText = text;
        this.myFlags = flags;
        if (this.myUpdateOptions != 0) {
            this.updateNativePeer();
        }
    }

    private static boolean _equals(Icon ic0, Icon ic1) {
        if (ic0 == ic1) {
            return true;
        }
        return ic0 != null ? ic0.equals(ic1) : ic1.equals(ic0);
    }

    private synchronized void _update(Icon icon, String text, Runnable action, int buttFlags) {
        if (this.myNativePeer != ID.NIL) {
            if (!TBItemButton._equals(icon, this.myIcon)) {
                this.myUpdateOptions |= 8;
            }
            if (!Comparing.equal((String)text, (String)this.myText)) {
                this.myUpdateOptions |= 4;
            }
            if (action != this.myAction) {
                this.myUpdateOptions |= 0x10;
            }
            if (buttFlags != this.myFlags) {
                this.myUpdateOptions |= 2;
            }
        }
        this.myIcon = icon;
        this.myText = text;
        this.myAction = action;
        this.myFlags = buttFlags;
        if (this.myUpdateOptions != 0) {
            this.updateNativePeer();
        }
    }

    @Override
    protected void _updateNativePeer() {
        Icon icon = (this.myUpdateOptions & 8) != 0 ? this.myIcon : null;
        String text = (this.myUpdateOptions & 4) != 0 ? this.myText : null;
        NSTLibrary.Action callback2 = (this.myUpdateOptions & 0x10) != 0 ? this.myNativeCallback : null;
        int validFlags = this._validateFlags();
        NST.updateButton(this.myNativePeer, this.myUpdateOptions, this.myLayoutBits, validFlags, text, icon, callback2);
        this.myUpdateOptions = 0;
    }

    @Override
    protected synchronized ID _createNativePeer() {
        ID result2 = NST.createButton(this.myUid, this.myLayoutBits, this._validateFlags(), this.myText, this.myIcon, this.myNativeCallback);
        if (this.myHasArrowIcon) {
            Icon ic = IconLoader.getIcon((String)"/mac/touchbar/popoverArrow_dark.svg");
            NST.setArrowImage(result2, ic);
        }
        return result2;
    }

    private int _validateFlags() {
        if ((this.myFlags & 4) != 0 && (this.myFlags & 1) != 0) {
            return this.myFlags & 0xFFFFFFFB;
        }
        return this.myFlags;
    }

    private static int _applyFlag(int src, boolean include, int flag) {
        return include ? src | flag : src & ~flag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uid", "com/intellij/ui/mac/touchbar/TBItemButton", "<init>"));
    }
}

