/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LeafElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.source.tree.LeafElement");
    private static final Key<SoftReference<String>> CACHED_TEXT = Key.create((String)"CACHED_TEXT");
    private static final int TEXT_MATCHES_THRESHOLD = 5;
    private final CharSequence myText;

    protected LeafElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            LeafElement.$$$reportNull$$$0(0);
        }
        super(type);
        this.myText = text;
    }

    @Override
    @NotNull
    public LeafElement clone() {
        LeafElement clone = (LeafElement)super.clone();
        clone.clearCaches();
        LeafElement leafElement = clone;
        if (leafElement == null) {
            LeafElement.$$$reportNull$$$0(1);
        }
        return leafElement;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            LeafElement.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    @NotNull
    public String getText() {
        CharSequence text = this.myText;
        if (text.length() > 1000 && !(text instanceof String)) {
            String cachedText = (String)SoftReference.dereference((Reference)((Reference)this.getUserData(CACHED_TEXT)));
            if (cachedText == null) {
                cachedText = text.toString();
                this.putUserData(CACHED_TEXT, new SoftReference((Object)cachedText));
            }
            String string = cachedText;
            if (string == null) {
                LeafElement.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text.toString();
        if (string == null) {
            LeafElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    public char charAt(int position) {
        return this.myText.charAt(position);
    }

    public int copyTo(@Nullable char[] buffer, int start2) {
        int length = this.myText.length();
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)start2, (int)length);
        }
        return start2 + length;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.myText.length()];
        CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)0);
        if (buffer == null) {
            LeafElement.$$$reportNull$$$0(5);
        }
        return buffer;
    }

    public boolean textContains(char c) {
        char[] chars;
        CharSequence text = this.myText;
        int len = text.length();
        if (len > 5 && (chars = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text)) != null) {
            for (char aChar : chars) {
                if (aChar != c) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (c != text.charAt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start2) {
        if (buffer == null) {
            LeafElement.$$$reportNull$$$0(6);
        }
        assert (start2 >= 0) : start2;
        return LeafElement.leafTextMatches(this.myText, buffer, start2);
    }

    static int leafTextMatches(@NotNull CharSequence text, @NotNull CharSequence buffer, int start2) {
        if (text == null) {
            LeafElement.$$$reportNull$$$0(7);
        }
        if (buffer == null) {
            LeafElement.$$$reportNull$$$0(8);
        }
        assert (start2 >= 0) : start2;
        int length = text.length();
        if (buffer.length() - start2 < length) {
            return start2 == 0 ? Integer.MIN_VALUE : -start2;
        }
        for (int i = 0; i < length; ++i) {
            int k = i + start2;
            if (text.charAt(i) == buffer.charAt(k)) continue;
            return k == 0 ? Integer.MIN_VALUE : -k;
        }
        return start2 + length;
    }

    @NotNull
    public LeafElement rawReplaceWithText(@NotNull String newText) {
        if (newText == null) {
            LeafElement.$$$reportNull$$$0(9);
        }
        LeafElement newLeaf = ASTFactory.leaf(this.getElementType(), newText);
        this.copyUserDataTo((UserDataHolderBase)newLeaf);
        this.rawReplaceWithList(newLeaf);
        newLeaf.clearCaches();
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            LeafElement.$$$reportNull$$$0(10);
        }
        return leafElement;
    }

    @NotNull
    public LeafElement replaceWithText(@NotNull String newText) {
        if (newText == null) {
            LeafElement.$$$reportNull$$$0(11);
        }
        LeafElement newLeaf = ChangeUtil.copyLeafWithText(this, newText);
        this.getTreeParent().replaceChild(this, newLeaf);
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            LeafElement.$$$reportNull$$$0(12);
        }
        return leafElement;
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        return this;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence buf, int start2, int end) {
        CharSequence text;
        int len;
        if (buf == null) {
            LeafElement.$$$reportNull$$$0(13);
        }
        if (end - start2 != (len = (text = this.getChars()).length())) {
            return false;
        }
        if (buf == text) {
            return true;
        }
        if (len > 5 && text instanceof String && buf instanceof String) {
            return ((String)text).regionMatches(0, (String)buf, start2, len);
        }
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) == buf.charAt(start2 + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptTree(@NotNull TreeElementVisitor visitor) {
        if (visitor == null) {
            LeafElement.$$$reportNull$$$0(14);
        }
        visitor.visitLeaf(this);
    }

    public ASTNode findChildByType(@NotNull IElementType type) {
        if (type == null) {
            LeafElement.$$$reportNull$$$0(15);
        }
        return null;
    }

    public ASTNode findChildByType(@NotNull IElementType type, @Nullable ASTNode anchor2) {
        if (type == null) {
            LeafElement.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            LeafElement.$$$reportNull$$$0(17);
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor2) {
        if (typesSet == null) {
            LeafElement.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Override
    public int hc() {
        return LeafElement.leafHC(this.getChars());
    }

    static int leafHC(CharSequence text) {
        int len = text.length();
        int hc = 0;
        for (int i = 0; i < len; ++i) {
            hc += text.charAt(i);
        }
        return hc;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return null;
    }

    @Override
    public TreeElement getLastChildNode() {
        return null;
    }

    @Override
    public int getNotCachedLength() {
        return this.myText.length();
    }

    @Override
    public int getCachedLength() {
        return this.getNotCachedLength();
    }

    @NotNull
    public ASTNode[] getChildren(TokenSet filter) {
        if (EMPTY_ARRAY == null) {
            LeafElement.$$$reportNull$$$0(19);
        }
        return EMPTY_ARRAY;
    }

    public void addChild(@NotNull ASTNode child2, ASTNode anchorBefore) {
        if (child2 == null) {
            LeafElement.$$$reportNull$$$0(20);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addLeaf(@NotNull IElementType leafType, @NotNull CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            LeafElement.$$$reportNull$$$0(21);
        }
        if (leafText == null) {
            LeafElement.$$$reportNull$$$0(22);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChild(@NotNull ASTNode child2) {
        if (child2 == null) {
            LeafElement.$$$reportNull$$$0(23);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void removeChild(@NotNull ASTNode child2) {
        if (child2 == null) {
            LeafElement.$$$reportNull$$$0(24);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            LeafElement.$$$reportNull$$$0(25);
        }
        if (newChild == null) {
            LeafElement.$$$reportNull$$$0(26);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void replaceAllChildrenToChildrenOf(@NotNull ASTNode anotherParent) {
        if (anotherParent == null) {
            LeafElement.$$$reportNull$$$0(27);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            LeafElement.$$$reportNull$$$0(28);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChildren(@NotNull ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        if (firstChild == null) {
            LeafElement.$$$reportNull$$$0(29);
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public PsiElement getPsi() {
        return null;
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            LeafElement.$$$reportNull$$$0(30);
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    static <T extends PsiElement> T getPsi(@NotNull Class<T> clazz, PsiElement element, @NotNull Logger log2) {
        if (clazz == null) {
            LeafElement.$$$reportNull$$$0(31);
        }
        if (log2 == null) {
            LeafElement.$$$reportNull$$$0(32);
        }
        log2.assertTrue(clazz.isInstance(element), (Object)("unexpected psi class. expected: " + clazz + " got: " + (element == null ? null : element.getClass())));
        return (T)element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/LeafElement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafText";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherParent";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/LeafElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "rawReplaceWithText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 19: {
                break;
            }
            case 6: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "leafTextMatches";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rawReplaceWithText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "acceptTree";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceAllChildrenToChildrenOf";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

