/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedObjectProviderBinding
implements ProviderBinding {
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> myNamesToProvidersMap = new THashMap(5);
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> myNamesToProvidersMapInsensitive = new THashMap(5);

    public void registerProvider(@NonNls @NotNull String[] names, @NotNull ElementPattern filter, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority) {
        if (names == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(2);
        }
        Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> map2 = caseSensitive ? this.myNamesToProvidersMap : this.myNamesToProvidersMapInsensitive;
        for (String attributeName : names) {
            String key = caseSensitive ? attributeName : attributeName.toLowerCase();
            SmartList psiReferenceProviders = map2.get(key);
            if (psiReferenceProviders == null) {
                psiReferenceProviders = new SmartList();
                map2.put(key, (List<ProviderBinding.ProviderInfo<ElementPattern>>)psiReferenceProviders);
            }
            psiReferenceProviders.add(new ProviderBinding.ProviderInfo<ElementPattern>(provider, filter, priority));
        }
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<? super ProviderBinding.ProviderInfo<ProcessingContext>> list2, @NotNull PsiReferenceService.Hints hints) {
        String name;
        if (position == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(3);
        }
        if (list2 == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(4);
        }
        if (hints == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(5);
        }
        if ((name = this.getName(position)) != null) {
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMap.get(name), list2, hints);
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMapInsensitive.get(name.toLowerCase()), list2, hints);
        }
    }

    @Override
    public void unregisterProvider(@NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(6);
        }
        for (List<ProviderBinding.ProviderInfo<ElementPattern>> list2 : this.myNamesToProvidersMap.values()) {
            for (ProviderBinding.ProviderInfo<ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<ElementPattern>>(list2)) {
                if (!trinity.provider.equals(provider)) continue;
                list2.remove(trinity);
            }
        }
        for (List<ProviderBinding.ProviderInfo<ElementPattern>> list2 : this.myNamesToProvidersMapInsensitive.values()) {
            for (ProviderBinding.ProviderInfo<ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<ElementPattern>>(list2)) {
                if (!trinity.provider.equals(provider)) continue;
                list2.remove(trinity);
            }
        }
    }

    @Nullable
    protected abstract String getName(@NotNull PsiElement var1);

    static void addMatchingProviders(@NotNull PsiElement position, @Nullable List<? extends ProviderBinding.ProviderInfo<ElementPattern>> providerList, @NotNull Collection<? super ProviderBinding.ProviderInfo<ProcessingContext>> output, @NotNull PsiReferenceService.Hints hints) {
        if (position == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(7);
        }
        if (output == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(8);
        }
        if (hints == null) {
            NamedObjectProviderBinding.$$$reportNull$$$0(9);
        }
        if (providerList == null) {
            return;
        }
        for (int i = 0; i < providerList.size(); ++i) {
            ProviderBinding.ProviderInfo<ElementPattern> info = providerList.get(i);
            if (hints != PsiReferenceService.Hints.NO_HINTS && !info.provider.acceptsHints(position, hints)) continue;
            ProcessingContext context = new ProcessingContext();
            if (hints != PsiReferenceService.Hints.NO_HINTS) {
                context.put(PsiReferenceService.HINTS, (Object)hints);
            }
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)info.processingContext).accepts((Object)position, context);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!suitable) continue;
            output.add(new ProviderBinding.ProviderInfo<ProcessingContext>(info.provider, context, info.priority));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAcceptableReferenceProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addMatchingProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

