/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.VcsRootErrorImpl;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsRootErrorsFinder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsRootDetector myRootDetector;

    public VcsRootErrorsFinder(@NotNull Project project) {
        if (project == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myRootDetector = (VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class);
    }

    @NotNull
    public Collection<VcsRootError> getOrFind() {
        Collection vcsRoots = this.myRootDetector.getOrDetect();
        Collection<VcsRootError> collection = this.calcErrors(vcsRoots);
        if (collection == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRootError> find() {
        Collection vcsRoots = this.myRootDetector.detect();
        Collection<VcsRootError> collection = this.calcErrors(vcsRoots);
        if (collection == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    private Collection<VcsRootError> calcErrors(@NotNull Collection<? extends VcsRoot> detectedRoots) {
        if (detectedRoots == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(3);
        }
        List mappings = this.myVcsManager.getDirectoryMappings();
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        errors.addAll(this.findExtraMappings(mappings));
        errors.addAll(this.findUnregisteredRoots(mappings, detectedRoots));
        ArrayList<VcsRootError> arrayList = errors;
        if (arrayList == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private Collection<VcsRootError> findUnregisteredRoots(@NotNull List<? extends VcsDirectoryMapping> mappings, @NotNull Collection<? extends VcsRoot> vcsRoots) {
        if (mappings == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(5);
        }
        if (vcsRoots == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(6);
        }
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        List<String> mappedPaths = this.mappingsToPathsWithSelectedVcs(mappings);
        for (VcsRoot vcsRoot : vcsRoots) {
            VirtualFile virtualFileFromRoot = vcsRoot.getPath();
            if (virtualFileFromRoot == null) continue;
            String vcsPath = virtualFileFromRoot.getPath();
            if (vcsRoot.getVcs() == null || mappedPaths.contains(vcsPath)) continue;
            errors.add(new VcsRootErrorImpl(VcsRootError.Type.UNREGISTERED_ROOT, vcsPath, vcsRoot.getVcs().getName()));
        }
        ArrayList<VcsRootError> arrayList = errors;
        if (arrayList == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private Collection<VcsRootError> findExtraMappings(@NotNull List<? extends VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(8);
        }
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        for (VcsDirectoryMapping vcsDirectoryMapping : mappings) {
            if (!VcsRootErrorsFinder.hasVcsChecker(vcsDirectoryMapping.getVcs())) continue;
            if (vcsDirectoryMapping.isDefaultMapping()) {
                if (this.isRoot(vcsDirectoryMapping)) continue;
                errors.add(new VcsRootErrorImpl(VcsRootError.Type.EXTRA_MAPPING, "<Project>", vcsDirectoryMapping.getVcs()));
                continue;
            }
            String mappedPath = vcsDirectoryMapping.systemIndependentPath();
            if (this.isRoot(vcsDirectoryMapping)) continue;
            errors.add(new VcsRootErrorImpl(VcsRootError.Type.EXTRA_MAPPING, mappedPath, vcsDirectoryMapping.getVcs()));
        }
        ArrayList<VcsRootError> arrayList = errors;
        if (arrayList == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static boolean hasVcsChecker(String vcs) {
        if (StringUtil.isEmptyOrSpaces((String)vcs)) {
            return false;
        }
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!vcs.equalsIgnoreCase(checker.getSupportedVcs().getName())) continue;
            return true;
        }
        return false;
    }

    private List<String> mappingsToPathsWithSelectedVcs(@NotNull List<? extends VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(10);
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (VcsDirectoryMapping vcsDirectoryMapping : mappings) {
            if (StringUtil.isEmptyOrSpaces((String)vcsDirectoryMapping.getVcs())) continue;
            if (!vcsDirectoryMapping.isDefaultMapping()) {
                paths.add(vcsDirectoryMapping.systemIndependentPath());
                continue;
            }
            String basePath = this.myProject.getBasePath();
            if (basePath == null) continue;
            paths.add(FileUtil.toSystemIndependentName((String)basePath));
        }
        return paths;
    }

    public static VcsRootErrorsFinder getInstance(Project project) {
        return new VcsRootErrorsFinder(project);
    }

    private boolean isRoot(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(11);
        }
        List checkers = VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList();
        String pathToCheck = mapping.isDefaultMapping() ? this.myProject.getBasePath() : mapping.getDirectory();
        return ContainerUtil.find((Iterable)checkers, checker -> checker.getSupportedVcs().getName().equalsIgnoreCase(mapping.getVcs()) && checker.isRoot(pathToCheck)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootErrorsFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoots";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootErrorsFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrFind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcErrors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnregisteredRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtraMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcErrors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUnregisteredRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findExtraMappings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mappingsToPathsWithSelectedVcs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

