/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.AbstractCommitter;
import com.intellij.openapi.vcs.changes.ui.ChangelistMoveOfferDialog;
import com.intellij.openapi.vcs.changes.ui.SingleChangeListCommitter$sam$com_intellij_openapi_vcs_changes_ChangesUtil_PerVcsProcessor$0;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.NullableFunction;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.ui.ConfirmationDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 #2\u00020\u0001:\u0001#Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0014J\b\u0010\u001f\u001a\u00020\u001bH\u0014J\b\u0010 \u001a\u00020\u001bH\u0014J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SingleChangeListCommitter;", "Lcom/intellij/openapi/vcs/changes/ui/AbstractCommitter;", "project", "Lcom/intellij/openapi/project/Project;", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "", "handlers", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "additionalData", "Lcom/intellij/util/NullableFunction;", "", "vcsToCommit", "Lcom/intellij/openapi/vcs/AbstractVcs;", "localHistoryActionName", "isDefaultChangeListFullyIncluded", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/LocalChangeList;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Lcom/intellij/util/NullableFunction;Lcom/intellij/openapi/vcs/AbstractVcs;Ljava/lang/String;Z)V", "isSuccess", "myAction", "Lcom/intellij/history/LocalHistoryAction;", "kotlin.jvm.PlatformType", "afterCommit", "", "commit", "doPostRefresh", "onFailure", "onFinish", "onSuccess", "refreshChanges", "updateChangeListAfterRefresh", "Companion", "intellij.platform.vcs.impl"})
public final class SingleChangeListCommitter
extends AbstractCommitter {
    private LocalHistoryAction myAction;
    private boolean isSuccess;
    private final LocalChangeList changeList;
    private final AbstractVcs<?> vcsToCommit;
    private final String localHistoryActionName;
    private final boolean isDefaultChangeListFullyIncluded;
    public static final Companion Companion = new Companion(null);

    @Override
    protected void commit() {
        if (this.vcsToCommit != null && this.getChanges().isEmpty()) {
            this.commit(this.vcsToCommit, this.getChanges());
        }
        Function2 function2 = new Function2<AbstractVcs<?>, List<? extends Change>, Unit>(this){

            public final void invoke(@NotNull AbstractVcs<?> p1, @NotNull List<? extends Change> p2) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull(p2, (String)"p2");
                ((SingleChangeListCommitter)this.receiver).commit(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SingleChangeListCommitter.class);
            }

            public final String getName() {
                return "commit";
            }

            public final String getSignature() {
                return "commit(Lcom/intellij/openapi/vcs/AbstractVcs;Ljava/util/List;)V";
            }
        };
        ChangesUtil.processChangesByVcs((Project)this.getProject(), (Collection)this.getChanges(), (ChangesUtil.PerVcsProcessor)new SingleChangeListCommitter$sam$com_intellij_openapi_vcs_changes_ChangesUtil_PerVcsProcessor$0(function2));
    }

    @Override
    protected void afterCommit() {
        ChangeListManagerImpl.getInstanceImpl(this.getProject()).showLocalChangesInvalidated();
        SingleChangeListCommitter singleChangeListCommitter = this;
        boolean $i$f$runReadAction = false;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
            final /* synthetic */ SingleChangeListCommitter this$0;
            {
                this.this$0 = singleChangeListCommitter;
            }

            public final T compute() {
                boolean bl = false;
                return (T)LocalHistory.getInstance().startAction(SingleChangeListCommitter.access$getLocalHistoryActionName$p(this.this$0));
            }
        });
        singleChangeListCommitter.myAction = (LocalHistoryAction)object;
    }

    @Override
    protected void onSuccess() {
        this.isSuccess = true;
    }

    @Override
    protected void onFailure() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ SingleChangeListCommitter this$0;

            public final void run() {
                Project project = this.this$0.getProject();
                ChangeList changeList = (ChangeList)SingleChangeListCommitter.access$getChangeList$p(this.this$0);
                String string = this.this$0.getCommitMessage();
                List<Change> list2 = this.this$0.getFailedToCommitChanges();
                String string2 = VcsBundle.message((String)"commit.dialog.failed.commit.template", (Object[])new Object[]{SingleChangeListCommitter.access$getChangeList$p(this.this$0).getName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message(\"commit.dialog.f\u2026mplate\", changeList.name)");
                SingleChangeListCommitter.Companion.moveToFailedList(project, changeList, string, list2, string2);
            }
            {
                this.this$0 = singleChangeListCommitter;
            }
        }, ModalityState.defaultModalityState(), this.getProject().getDisposed());
    }

    @Override
    protected void onFinish() {
        this.refreshChanges();
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(this){
            final /* synthetic */ SingleChangeListCommitter this$0;

            public final void run() {
                SingleChangeListCommitter.access$doPostRefresh(this.this$0);
            }
            {
                this.this$0 = singleChangeListCommitter;
            }
        }, null, (Project)this.getProject());
    }

    private final void refreshChanges() {
        List toRefresh = new ArrayList();
        ChangesUtil.processChangesByVcs((Project)this.getProject(), (Collection)this.getChanges(), (ChangesUtil.PerVcsProcessor)((ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(toRefresh){
            final /* synthetic */ List $toRefresh;

            public final void process(@NotNull AbstractVcs<CommittedChangeList> vcs, @NotNull List<Change> changes2) {
                Intrinsics.checkParameterIsNotNull(vcs, (String)"vcs");
                Intrinsics.checkParameterIsNotNull(changes2, (String)"changes");
                CheckinEnvironment environment = vcs.getCheckinEnvironment();
                if (environment != null && environment.isRefreshAfterCommitNeeded()) {
                    this.$toRefresh.addAll((Collection)changes2);
                }
            }
            {
                this.$toRefresh = list2;
            }
        }));
        if (!toRefresh.isEmpty()) {
            ProgressManager.progress((String)VcsBundle.message((String)"commit.dialog.refresh.files", (Object[])new Object[0]));
            RefreshVFsSynchronously.updateChanges(toRefresh);
        }
    }

    private final void doPostRefresh() {
        this.myAction.finish();
        if (!this.getProject().isDisposed()) {
            VcsDirtyScopeManager.getInstance((Project)this.getProject()).filePathsDirty((Collection)this.getPathsToRefresh(), null);
            ChangeListManager.getInstance((Project)this.getProject()).invokeAfterUpdate(new Runnable(this){
                final /* synthetic */ SingleChangeListCommitter this$0;

                public final void run() {
                    if (SingleChangeListCommitter.access$isSuccess$p(this.this$0)) {
                        SingleChangeListCommitter.access$updateChangeListAfterRefresh(this.this$0);
                    }
                    CommittedChangesCache cache = CommittedChangesCache.getInstance(this.this$0.getProject());
                    cache.refreshAllCachesAsync(false, true);
                    cache.refreshIncomingChangesAsync();
                }
                {
                    this.this$0 = singleChangeListCommitter;
                }
            }, InvokeAfterUpdateMode.SILENT, null, null);
            LocalHistory.getInstance().putSystemLabel(this.getProject(), this.localHistoryActionName + ": " + this.getCommitMessage());
        }
    }

    private final void updateChangeListAfterRefresh() {
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.getProject());
        String string = this.changeList.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"changeList.name");
        String listName = string;
        LocalChangeList localChangeList = changeListManager.findChangeList(listName);
        if (localChangeList == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"changeListManager.findCh\u2026eList(listName) ?: return");
        LocalChangeList localList = localChangeList;
        changeListManager.editChangeListData(listName, null);
        if (!localList.isDefault()) {
            changeListManager.scheduleAutomaticEmptyChangeListDeletion(localList);
        } else {
            ChangelistMoveOfferDialog dialog2;
            Collection changes2 = localList.getChanges();
            if (this.getConfiguration().OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT && !changes2.isEmpty() && this.isDefaultChangeListFullyIncluded && (dialog2 = new ChangelistMoveOfferDialog(this.getConfiguration())).showAndGet()) {
                MoveChangesToAnotherListAction.askAndMove(this.getProject(), changes2, CollectionsKt.emptyList());
            }
        }
    }

    public SingleChangeListCommitter(@NotNull Project project, @NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes2, @NotNull String commitMessage2, @NotNull List<? extends CheckinHandler> handlers, @NotNull NullableFunction<Object, Object> additionalData, @Nullable AbstractVcs<?> vcsToCommit, @NotNull String localHistoryActionName, boolean isDefaultChangeListFullyIncluded) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)changeList, (String)"changeList");
        Intrinsics.checkParameterIsNotNull(changes2, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)commitMessage2, (String)"commitMessage");
        Intrinsics.checkParameterIsNotNull(handlers, (String)"handlers");
        Intrinsics.checkParameterIsNotNull(additionalData, (String)"additionalData");
        Intrinsics.checkParameterIsNotNull((Object)localHistoryActionName, (String)"localHistoryActionName");
        super(project, changes2, commitMessage2, handlers, additionalData);
        this.changeList = changeList;
        this.vcsToCommit = vcsToCommit;
        this.localHistoryActionName = localHistoryActionName;
        this.isDefaultChangeListFullyIncluded = isDefaultChangeListFullyIncluded;
        this.myAction = LocalHistoryAction.NULL;
    }

    public static final /* synthetic */ String access$getLocalHistoryActionName$p(SingleChangeListCommitter $this) {
        return $this.localHistoryActionName;
    }

    public static final /* synthetic */ LocalChangeList access$getChangeList$p(SingleChangeListCommitter $this) {
        return $this.changeList;
    }

    public static final /* synthetic */ void access$doPostRefresh(SingleChangeListCommitter $this) {
        $this.doPostRefresh();
    }

    public static final /* synthetic */ boolean access$isSuccess$p(SingleChangeListCommitter $this) {
        return $this.isSuccess;
    }

    public static final /* synthetic */ void access$setSuccess$p(SingleChangeListCommitter $this, boolean bl) {
        $this.isSuccess = bl;
    }

    public static final /* synthetic */ void access$updateChangeListAfterRefresh(SingleChangeListCommitter $this) {
        $this.updateChangeListAfterRefresh();
    }

    @JvmStatic
    public static final void moveToFailedList(@NotNull Project project, @NotNull ChangeList changeList, @NotNull String commitMessage2, @NotNull List<? extends Change> failedChanges, @NotNull String newChangeListName) {
        Companion.moveToFailedList(project, changeList, commitMessage2, failedChanges, newChangeListName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SingleChangeListCommitter$Companion;", "", "()V", "moveToFailedList", "", "project", "Lcom/intellij/openapi/project/Project;", "changeList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "commitMessage", "", "failedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "newChangeListName", "intellij.platform.vcs.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void moveToFailedList(@NotNull Project project, @NotNull ChangeList changeList, @NotNull String commitMessage2, @NotNull List<? extends Change> failedChanges, @NotNull String newChangeListName) {
            Change[] changeArray;
            void $receiver$iv;
            VcsShowConfirmationOption option2;
            boolean result2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)changeList, (String)"changeList");
            Intrinsics.checkParameterIsNotNull((Object)commitMessage2, (String)"commitMessage");
            Intrinsics.checkParameterIsNotNull(failedChanges, (String)"failedChanges");
            Intrinsics.checkParameterIsNotNull((Object)newChangeListName, (String)"newChangeListName");
            Collection collection = changeList.getChanges();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"changeList.changes");
            if (failedChanges.containsAll(collection)) {
                return;
            }
            VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
            if (configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && !(result2 = ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)(option2 = new VcsShowConfirmationOption(configuration){
                final /* synthetic */ VcsConfiguration $configuration;

                @NotNull
                public VcsShowConfirmationOption.Value getValue() {
                    VcsShowConfirmationOption.Value value = this.$configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST;
                    Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST");
                    return value;
                }

                public void setValue(@NotNull VcsShowConfirmationOption.Value value) {
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    this.$configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST = value;
                }

                public boolean isPersistent() {
                    return true;
                }
                {
                    this.$configuration = $captured_local_variable$0;
                }
            }), (Project)project, (String)VcsBundle.message((String)"commit.failed.confirm.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.failed.confirm.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
                return;
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
            ChangeListManager changeListManager2 = changeListManager;
            int index = 1;
            String failedListName = newChangeListName;
            while (changeListManager2.findChangeList(failedListName) != null) {
                failedListName = newChangeListName + " (" + ++index + ')';
            }
            LocalChangeList failedList = changeListManager2.addChangeList(failedListName, commitMessage2);
            Collection collection2 = failedChanges;
            LocalChangeList localChangeList = failedList;
            ChangeListManager changeListManager3 = changeListManager2;
            void thisCollection$iv = $receiver$iv;
            Change[] changeArray2 = thisCollection$iv.toArray(new Change[0]);
            if (changeArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Change[] changeArray3 = changeArray = changeArray2;
            changeListManager3.moveChangesTo(localChangeList, Arrays.copyOf(changeArray3, changeArray3.length));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

