/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchDiffRequest;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchMergeRequest;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchDiffRequestFactory {
    @NotNull
    public static DiffRequest createDiffRequest(@Nullable Project project, @NotNull Change change, @NotNull String name, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        ChangeDiffRequestProducer proxyProducer;
        if (change == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(3);
        }
        if ((proxyProducer = ChangeDiffRequestProducer.create(project, change)) == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name + "'");
        }
        DiffRequest diffRequest = proxyProducer.process(context, indicator);
        if (diffRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(4);
        }
        return diffRequest;
    }

    @NotNull
    public static DiffRequest createConflictDiffRequest(@Nullable Project project, @Nullable VirtualFile file2, @NotNull TextFilePatch patch, @NotNull String afterTitle, @NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull String name) throws DiffRequestProducerException {
        if (patch == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(5);
        }
        if (afterTitle == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(6);
        }
        if (texts == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(7);
        }
        if (name == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name + "'");
        }
        if (file2.getFileType().isBinary()) {
            throw new DiffRequestProducerException("Can't show diff for binary file '" + name + "'");
        }
        if (texts.getBase() == null) {
            String localContent = texts.getLocal();
            GenericPatchApplier applier = new GenericPatchApplier(localContent, patch.getHunks());
            applier.execute();
            AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
            DiffRequest diffRequest = PatchDiffRequestFactory.createBadDiffRequest(project, file2, localContent, appliedTextPatch, null, null, "Current Version", null);
            if (diffRequest == null) {
                PatchDiffRequestFactory.$$$reportNull$$$0(9);
            }
            return diffRequest;
        }
        String localContent = texts.getLocal();
        String baseContent = texts.getBase();
        String patchedContent = texts.getPatched();
        DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, file2, ContainerUtil.list((Object[])new String[]{localContent, baseContent, patchedContent}), null, ContainerUtil.list((Object[])new String[]{"Current Version", "Base Version", afterTitle}));
        if (diffRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(10);
        }
        return diffRequest;
    }

    @NotNull
    public static DiffRequest createDiffRequest(@Nullable Project project, @Nullable VirtualFile file2, @NotNull List<String> contents, @Nullable String windowTitle, @NotNull List<String> titles) {
        DocumentContent localContent;
        if (contents == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(11);
        }
        if (titles == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(12);
        }
        assert (contents.size() == 3);
        assert (titles.size() == 3);
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getPatchTitle(file2);
        }
        String localTitle = StringUtil.notNullize((String)titles.get(0), (String)VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]));
        String baseTitle = StringUtil.notNullize((String)titles.get(1), (String)"Base Version");
        String patchedTitle = StringUtil.notNullize((String)titles.get(2), (String)VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]));
        FileType fileType = file2 != null ? file2.getFileType() : null;
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DocumentContent documentContent = localContent = file2 != null ? contentFactory.createDocument(project, file2) : null;
        if (localContent == null) {
            localContent = contentFactory.create(project, contents.get(0), fileType);
        }
        DocumentContent baseContent = contentFactory.create(project, contents.get(1), fileType);
        DocumentContent patchedContent = contentFactory.create(project, contents.get(2), fileType);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(windowTitle, (DiffContent)localContent, (DiffContent)baseContent, (DiffContent)patchedContent, localTitle, baseTitle, patchedTitle);
        if (simpleDiffRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(13);
        }
        return simpleDiffRequest;
    }

    @NotNull
    public static DiffRequest createBadDiffRequest(@Nullable Project project, @NotNull VirtualFile file2, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable String windowTitle, @Nullable String localTitle, @Nullable String resultTitle, @Nullable String patchTitle) {
        DocumentContent resultContent;
        if (file2 == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(14);
        }
        if (localContent == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(15);
        }
        if (textPatch == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(16);
        }
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getBadPatchTitle(file2);
        }
        if (localTitle == null) {
            localTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
        }
        if (resultTitle == null) {
            resultTitle = VcsBundle.message((String)"patch.apply.conflict.patched.somehow.version", (Object[])new Object[0]);
        }
        if (patchTitle == null) {
            patchTitle = VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]);
        }
        if ((resultContent = DiffContentFactory.getInstance().createDocument(project, file2)) == null) {
            resultContent = DiffContentFactory.getInstance().create(project, localContent, file2);
        }
        ApplyPatchDiffRequest applyPatchDiffRequest = new ApplyPatchDiffRequest(resultContent, textPatch, localContent, windowTitle, localTitle, resultTitle, patchTitle);
        if (applyPatchDiffRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(17);
        }
        return applyPatchDiffRequest;
    }

    @NotNull
    public static MergeRequest createMergeRequest(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2, @NotNull String baseContent, @NotNull String localContent, @NotNull String patchedContent, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        if (document == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(19);
        }
        if (baseContent == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(20);
        }
        if (localContent == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(21);
        }
        if (patchedContent == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(22);
        }
        List titles = ContainerUtil.list((Object[])new String[]{null, null, null});
        List contents = ContainerUtil.list((Object[])new String[]{localContent, baseContent, patchedContent});
        MergeRequest mergeRequest = PatchDiffRequestFactory.createMergeRequest(project, document, file2, contents, null, titles, callback2);
        if (mergeRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(23);
        }
        return mergeRequest;
    }

    @NotNull
    public static MergeRequest createBadMergeRequest(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        if (document == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(25);
        }
        if (localContent == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(26);
        }
        if (textPatch == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(27);
        }
        MergeRequest mergeRequest = PatchDiffRequestFactory.createBadMergeRequest(project, document, file2, localContent, textPatch, null, null, null, null, callback2);
        if (mergeRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(28);
        }
        return mergeRequest;
    }

    @NotNull
    public static MergeRequest createMergeRequest(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile file2, @NotNull List<String> contents, @Nullable String windowTitle, @NotNull List<String> titles, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        if (document == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(29);
        }
        if (contents == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(30);
        }
        if (titles == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(31);
        }
        assert (contents.size() == 3);
        assert (titles.size() == 3);
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getPatchTitle(file2);
        }
        String localTitle = StringUtil.notNullize((String)titles.get(0), (String)VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]));
        String baseTitle = StringUtil.notNullize((String)titles.get(1), (String)VcsBundle.message((String)"patch.apply.conflict.merged.version", (Object[])new Object[0]));
        String patchedTitle = StringUtil.notNullize((String)titles.get(2), (String)VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]));
        List actualTitles = ContainerUtil.list((Object[])new String[]{localTitle, baseTitle, patchedTitle});
        FileType fileType = file2 != null ? file2.getFileType() : null;
        MergeRequest mergeRequest = DiffRequestFactory.getInstance().createMergeRequest(project, fileType, document, contents, windowTitle, actualTitles, callback2);
        if (mergeRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(32);
        }
        return mergeRequest;
    }

    @NotNull
    public static MergeRequest createBadMergeRequest(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile file2, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable String windowTitle, @Nullable String localTitle, @Nullable String resultTitle, @Nullable String patchTitle, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        if (document == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(33);
        }
        if (localContent == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(34);
        }
        if (textPatch == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(35);
        }
        if (!DiffUtil.canMakeWritable(document)) {
            throw new InvalidDiffRequestException("Output is read only" + (file2 != null ? " : '" + file2.getPresentableUrl() + "'" : ""));
        }
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getBadPatchTitle(file2);
        }
        if (localTitle == null) {
            localTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
        }
        if (resultTitle == null) {
            resultTitle = VcsBundle.message((String)"patch.apply.conflict.patched.somehow.version", (Object[])new Object[0]);
        }
        if (patchTitle == null) {
            patchTitle = VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]);
        }
        DocumentContent resultContent = DiffContentFactory.getInstance().create(project, document, file2);
        ApplyPatchMergeRequest applyPatchMergeRequest = new ApplyPatchMergeRequest(project, resultContent, textPatch, localContent, windowTitle, localTitle, resultTitle, patchTitle, callback2);
        if (applyPatchMergeRequest == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(36);
        }
        return applyPatchMergeRequest;
    }

    @NotNull
    private static String getPatchTitle(@Nullable VirtualFile file2) {
        if (file2 != null) {
            String string = VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{PatchDiffRequestFactory.getPresentablePath(file2)});
            if (string == null) {
                PatchDiffRequestFactory.$$$reportNull$$$0(37);
            }
            return string;
        }
        if ("Patch Conflict" == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(38);
        }
        return "Patch Conflict";
    }

    @NotNull
    private static String getBadPatchTitle(@Nullable VirtualFile file2) {
        if (file2 != null) {
            String string = "Result of Patch Apply to " + PatchDiffRequestFactory.getPresentablePath(file2);
            if (string == null) {
                PatchDiffRequestFactory.$$$reportNull$$$0(39);
            }
            return string;
        }
        if ("Result of Patch Apply" == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(40);
        }
        return "Result of Patch Apply";
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(41);
        }
        String fullPath = file2.getParent() == null ? file2.getPath() : file2.getParent().getPath();
        String string = file2.getName() + " (" + fullPath + ")";
        if (string == null) {
            PatchDiffRequestFactory.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterTitle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 14: 
            case 19: 
            case 25: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 21: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localContent";
                break;
            }
            case 16: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPatch";
                break;
            }
            case 18: 
            case 24: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseContent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchedContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory";
                break;
            }
            case 4: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffRequest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createConflictDiffRequest";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createBadDiffRequest";
                break;
            }
            case 23: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequest";
                break;
            }
            case 28: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createBadMergeRequest";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchTitle";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getBadPatchTitle";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDiffRequest";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConflictDiffRequest";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createBadDiffRequest";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequest";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createBadMergeRequest";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

