/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.impl.AbstractDialog;
import com.intellij.openapi.ui.impl.HeadlessDialog;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.OwnerOptional;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogWrapperPeerImpl
extends DialogWrapperPeer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.DialogWrapper");
    private final DialogWrapper myWrapper;
    private final AbstractDialog myDialog;
    private final boolean myCanBeParent;
    private final WindowManagerEx myWindowManager;
    private final List<Runnable> myDisposeActions;
    private Project myProject;
    private ActionCallback myTypeAheadCallback;

    public static boolean isHeadlessEnv() {
        Application app = ApplicationManager.getApplication();
        return app == null ? GraphicsEnvironment.isHeadless() : app.isUnitTestMode() || app.isHeadlessEnvironment();
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @Nullable Project project, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(0);
        }
        if (ideModalityType == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(1);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        this.myTypeAheadCallback = this.myWrapper.isTypeAheadEnabled() ? new ActionCallback() : null;
        this.myWindowManager = DialogWrapperPeerImpl.getWindowManager();
        Window window = null;
        if (this.myWindowManager != null) {
            Window focusedWindow;
            if (project == null) {
                project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            }
            this.myProject = project;
            window = this.myWindowManager.suggestParentWindow(project);
            if (window == null && (focusedWindow = this.myWindowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
                window = focusedWindow;
            }
            if (window == null) {
                IdeFrame[] frames;
                for (IdeFrame frame : frames = this.myWindowManager.getAllProjectFrames()) {
                    if (!(frame instanceof IdeFrameImpl) || !((IdeFrameImpl)frame).isActive()) continue;
                    window = (IdeFrameImpl)frame;
                    break;
                }
            }
        }
        Window owner = window != null ? window : (!headless ? JOptionPane.getRootFrame() : null);
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, owner, wrapper2, this.myProject, this.myTypeAheadCallback, ideModalityType);
        this.myCanBeParent = headless || canBeParent;
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @Nullable Project project, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(2);
        }
        this(wrapper2, project, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(3);
        }
        this(wrapper2, (Project)null, canBeParent);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @NotNull Component parent, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(5);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        this.myWindowManager = DialogWrapperPeerImpl.getWindowManager();
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, OwnerOptional.fromComponent(parent).get(), wrapper2, null, null, DialogWrapper.IdeModalityType.IDE);
        this.myCanBeParent = headless || canBeParent;
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, Window owner, boolean canBeParent, DialogWrapper.IdeModalityType ideModalityType) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(6);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        this.myWindowManager = DialogWrapperPeerImpl.getWindowManager();
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, owner, wrapper2, null, null, DialogWrapper.IdeModalityType.IDE);
        boolean bl = this.myCanBeParent = headless || canBeParent;
        if (!headless) {
            Dialog.ModalityType modalityType = DialogWrapper.IdeModalityType.IDE.toAwtModality();
            if (Registry.is((String)"ide.perProjectModality")) {
                modalityType = ideModalityType.toAwtModality();
            }
            this.myDialog.setModalityType(modalityType);
        }
    }

    private static WindowManagerEx getWindowManager() {
        WindowManagerEx windowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            windowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        return windowManager;
    }

    private static AbstractDialog createDialog(boolean headless, Window owner, DialogWrapper wrapper2, Project project, ActionCallback typeAhead, DialogWrapper.IdeModalityType ideModalityType) {
        if (headless) {
            return new HeadlessDialog(wrapper2);
        }
        ActionCallback focused = new ActionCallback("DialogFocusedCallback");
        ActionCallback typeAheadDone = new ActionCallback("DialogTypeAheadDone");
        MyDialog dialog2 = new MyDialog(OwnerOptional.fromComponent(owner).get(), wrapper2, project, focused, typeAheadDone, typeAhead);
        dialog2.setModalityType(ideModalityType.toAwtModality());
        return dialog2;
    }

    public boolean isHeadless() {
        return this.myDialog instanceof HeadlessDialog;
    }

    public Object[] getCurrentModalEntities() {
        return LaterInvocator.getCurrentModalEntities();
    }

    public void setUndecorated(boolean undecorated) {
        this.myDialog.setUndecorated(undecorated);
    }

    public void addMouseListener(MouseListener listener2) {
        this.myDialog.addMouseListener(listener2);
    }

    public void addMouseListener(MouseMotionListener listener2) {
        this.myDialog.addMouseMotionListener(listener2);
    }

    public void addKeyListener(KeyListener listener2) {
        this.myDialog.addKeyListener(listener2);
    }

    public void toFront() {
        this.myDialog.toFront();
    }

    public void toBack() {
        this.myDialog.toBack();
    }

    protected void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        for (Runnable runnable2 : this.myDisposeActions) {
            runnable2.run();
        }
        this.myDisposeActions.clear();
        Runnable disposer = () -> {
            Disposer.dispose((Disposable)this.myDialog);
            this.myProject = null;
            SwingUtilities.invokeLater(() -> {
                if (this.myDialog.getRootPane() != null) {
                    this.myDialog.remove(this.myDialog.getRootPane());
                }
            });
        };
        UIUtil.invokeLaterIfNeeded((Runnable)disposer);
    }

    private boolean isProgressDialog() {
        return this.myWrapper.isModalProgress();
    }

    @Nullable
    public Container getContentPane() {
        return this.getRootPane() != null ? this.myDialog.getContentPane() : null;
    }

    public void validate() {
        this.myDialog.validate();
    }

    public void repaint() {
        this.myDialog.repaint();
    }

    public Window getOwner() {
        return this.myDialog.getOwner();
    }

    public Window getWindow() {
        return this.myDialog.getWindow();
    }

    public JRootPane getRootPane() {
        return this.myDialog.getRootPane();
    }

    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    public String getTitle() {
        return this.myDialog.getTitle();
    }

    public void pack() {
        this.myDialog.pack();
    }

    public void setAppIcons() {
        AppUIUtil.updateWindowIcon(this.getWindow());
    }

    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    public void setModal(boolean modal) {
        this.myDialog.setModal(modal);
    }

    public boolean isModal() {
        return this.myDialog.isModal();
    }

    public boolean isVisible() {
        return this.myDialog.isVisible();
    }

    public boolean isShowing() {
        return this.myDialog.isShowing();
    }

    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    public void setTitle(String title) {
        this.myDialog.setTitle(title);
    }

    public void isResizable() {
        this.myDialog.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myDialog.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myDialog.getLocation();
        if (point == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(7);
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(8);
        }
        this.myDialog.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myDialog.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionCallback show() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        if (this.myTypeAheadCallback != null) {
            IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myTypeAheadCallback);
        }
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        ActionCallback result2 = new ActionCallback();
        AnCancelAction anCancelAction = new AnCancelAction();
        JRootPane rootPane = this.getRootPane();
        UIUtil.decorateWindowHeader((JRootPane)rootPane);
        anCancelAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, rootPane);
        this.myDisposeActions.add(() -> anCancelAction.unregisterCustomShortcutSet(rootPane));
        if (!this.myCanBeParent && this.myWindowManager != null) {
            this.myWindowManager.doNotSuggestAsParent(this.myDialog.getWindow());
        }
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean appStarted = commandProcessor != null;
        boolean changeModalityState = appStarted && this.myDialog.isModal() && !this.isProgressDialog();
        Project project = this.myProject;
        boolean perProjectModality = Registry.is((String)"ide.perProjectModality");
        if (changeModalityState) {
            commandProcessor.enterModal();
            if (perProjectModality) {
                LaterInvocator.enterModal(project, this.myDialog.getWindow());
            } else {
                LaterInvocator.enterModal(this.myDialog);
            }
        }
        if (appStarted) {
            this.hidePopupsIfNeeded();
        }
        this.myDialog.getWindow().setAutoRequestFocus(true);
        Disposable tb = TouchBarsManager.showDialogWrapperButtons(this.myDialog.getContentPane());
        if (tb != null) {
            this.myDisposeActions.add(() -> Disposer.dispose((Disposable)tb));
        }
        try {
            this.myDialog.show();
        }
        finally {
            if (changeModalityState) {
                commandProcessor.leaveModal();
                if (perProjectModality) {
                    LaterInvocator.leaveModal(project, this.myDialog.getWindow());
                } else {
                    LaterInvocator.leaveModal(this.myDialog);
                }
            }
            this.myDialog.getFocusManager().doWhenFocusSettlesDown(result2.createSetDoneRunnable());
        }
        return result2;
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfo.isMac) {
            return;
        }
        StackingPopupDispatcher.getInstance().hidePersistentPopups();
        this.myDisposeActions.add(() -> StackingPopupDispatcher.getInstance().restorePersistentPopups());
    }

    private static void setupSelectionOnPreferredComponent(JComponent component) {
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            String text = field.getText();
            if (text != null && field.getClientProperty(HAVE_INITIAL_SELECTION) == null) {
                field.setSelectionStart(0);
                field.setSelectionEnd(text.length());
            }
        } else if (component instanceof JComboBox) {
            JComboBox combobox = (JComboBox)component;
            combobox.getEditor().selectAll();
        }
    }

    public void setContentPane(JComponent content) {
        this.myDialog.setContentPane(content);
    }

    public void centerInParent() {
        this.myDialog.centerInParent();
    }

    public void setAutoRequestFocus(boolean b) {
        UIUtil.setAutoRequestFocus((Window)((JDialog)((Object)this.myDialog)), (boolean)b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDialog
    extends JDialog
    implements DialogWrapperDialog,
    DataProvider,
    Queryable,
    AbstractDialog {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private Dimension myInitialSize;
        private String myDimensionServiceKey;
        private boolean myOpened;
        private boolean myActivated;
        private MyWindowListener myWindowListener;
        private final WeakReference<Project> myProject;
        private final ActionCallback myFocusedCallback;
        private final ActionCallback myTypeAheadDone;
        private final ActionCallback myTypeAheadCallback;

        MyDialog(Window owner, DialogWrapper dialogWrapper, Project project, @NotNull ActionCallback focused, @NotNull ActionCallback typeAheadDone, ActionCallback typeAheadCallback) {
            if (focused == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            if (typeAheadDone == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            super(owner);
            this.myOpened = false;
            this.myActivated = false;
            UIUtil.markAsTypeAheadAware((Window)this);
            this.myDialogWrapper = new WeakReference<DialogWrapper>(dialogWrapper);
            this.myProject = project != null ? new WeakReference<Project>(project) : null;
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

                @Override
                protected boolean accept(Component aComponent) {
                    if (UIUtil.isFocusProxy((Component)aComponent)) {
                        return false;
                    }
                    return super.accept(aComponent);
                }
            });
            this.myFocusedCallback = focused;
            this.myTypeAheadDone = typeAheadDone;
            this.myTypeAheadCallback = typeAheadCallback;
            long typeAhead = this.getDialogWrapper().getTypeAheadTimeoutMs();
            if (typeAhead <= 0L) {
                this.myTypeAheadDone.setDone();
            }
            this.setDefaultCloseOperation(0);
            this.myWindowListener = new MyWindowListener();
            this.addWindowListener(this.myWindowListener);
            UIUtil.setAutoRequestFocus((Window)this, (boolean)true);
        }

        @Override
        public JDialog getWindow() {
            return this;
        }

        public void putInfo(@NotNull Map<String, String> info) {
            if (info == null) {
                MyDialog.$$$reportNull$$$0(2);
            }
            info.put("dialog", this.getTitle());
        }

        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        @Override
        public void centerInParent() {
            this.setLocationRelativeTo(this.getOwner());
        }

        public Object getData(@NotNull String dataId) {
            DialogWrapper wrapper2;
            if (dataId == null) {
                MyDialog.$$$reportNull$$$0(3);
            }
            if ((wrapper2 = (DialogWrapper)this.myDialogWrapper.get()) instanceof DataProvider) {
                return ((DataProvider)wrapper2).getData(dataId);
            }
            if (wrapper2 instanceof TypeSafeDataProvider) {
                TypeSafeDataProviderAdapter adapter = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)wrapper2);
                return adapter.getData(dataId);
            }
            return null;
        }

        @Override
        public void setSize(int width, int height) {
            this._setSizeForLocation(width, height, null);
        }

        private void _setSizeForLocation(int width, int height, @Nullable Point initial) {
            Point location = initial != null ? initial : this.getLocation();
            Rectangle rect = new Rectangle(location.x, location.y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            if (initial != null || location.x != rect.x || location.y != rect.y) {
                this.setLocation(rect.x, rect.y);
            }
            super.setSize(rect.width, rect.height);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Rectangle rect = new Rectangle(x, y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            super.setBounds(rect.x, rect.y, rect.width, rect.height);
        }

        @Override
        public void setBounds(Rectangle r) {
            ScreenUtil.fitToScreen((Rectangle)r);
            super.setBounds(r);
        }

        @Override
        @NotNull
        protected JRootPane createRootPane() {
            DialogRootPane dialogRootPane = new DialogRootPane();
            if (dialogRootPane == null) {
                MyDialog.$$$reportNull$$$0(4);
            }
            return dialogRootPane;
        }

        @Override
        public void show() {
            IdeEventQueue queue2;
            DialogWrapper dialogWrapper = this.getDialogWrapper();
            boolean isAutoAdjustable = dialogWrapper.isAutoAdjustable();
            Point location = null;
            if (isAutoAdjustable) {
                this.pack();
                Dimension packedSize = this.getSize();
                Dimension minSize = this.getMinimumSize();
                this.setSize(Math.max(packedSize.width, minSize.width), Math.max(packedSize.height, minSize.height));
                this.setSize((int)((float)this.getWidth() * dialogWrapper.getHorizontalStretch()), (int)((float)this.getHeight() * dialogWrapper.getVerticalStretch()));
                this.myDimensionServiceKey = dialogWrapper.getDimensionKey();
                if (this.myDimensionServiceKey != null) {
                    Project projectGuess = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
                    location = DimensionService.getInstance().getLocation(this.myDimensionServiceKey, projectGuess);
                    Dimension size = DimensionService.getInstance().getSize(this.myDimensionServiceKey, projectGuess);
                    if (size != null) {
                        this.myInitialSize = new Dimension(size);
                        this._setSizeForLocation(this.myInitialSize.width, this.myInitialSize.height, location);
                    }
                }
                if (this.myInitialSize == null) {
                    this.myInitialSize = this.getSize();
                }
            }
            if (location == null) {
                location = dialogWrapper.getInitialLocation();
            }
            if (location != null) {
                this.setLocation(location);
            } else {
                this.setLocationRelativeTo(this.getOwner());
            }
            if (isAutoAdjustable) {
                Rectangle bounds2 = this.getBounds();
                ScreenUtil.fitToScreen((Rectangle)bounds2);
                this.setBounds(bounds2);
            }
            if (Registry.is((String)"actionSystem.fixLostTyping") && (queue2 = IdeEventQueue.getInstance()) != null) {
                queue2.getKeyEventDispatcher().resetState();
            }
            if (SystemInfo.isMac && this.myProject != null && Registry.is((String)"ide.mac.fix.dialog.showing") && !dialogWrapper.isModalProgress()) {
                IdeFrame frame = WindowManager.getInstance().getIdeFrame((Project)this.myProject.get());
                AppIcon.getInstance().requestFocus(frame);
            }
            this.setBackground(UIUtil.getPanelBackground());
            super.show();
        }

        @Nullable
        private Project getProject() {
            return (Project)SoftReference.dereference(this.myProject);
        }

        @Override
        @NotNull
        public IdeFocusManager getFocusManager() {
            Project project = this.getProject();
            if (project != null && !project.isDisposed()) {
                IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)project);
                if (ideFocusManager == null) {
                    MyDialog.$$$reportNull$$$0(5);
                }
                return ideFocusManager;
            }
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
            if (ideFocusManager == null) {
                MyDialog.$$$reportNull$$$0(6);
            }
            return ideFocusManager;
        }

        @Override
        public void hide() {
            super.hide();
        }

        @Override
        public void dispose() {
            if (this.isShowing()) {
                this.hide();
            }
            if (this.myWindowListener != null) {
                this.myWindowListener.saveSize();
                this.removeWindowListener(this.myWindowListener);
                this.myWindowListener = null;
            }
            DialogWrapper.cleanupWindowListeners((Window)this);
            BufferStrategy strategy = this.getBufferStrategy();
            if (strategy != null) {
                strategy.dispose();
            }
            super.dispose();
            this.removeAll();
            DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
            this.rootPane = null;
        }

        @Override
        public Component getMostRecentFocusOwner() {
            JComponent toFocus;
            DialogWrapper wrapper2;
            if (!this.myOpened && (wrapper2 = this.getDialogWrapper()) != null && (toFocus = wrapper2.getPreferredFocusedComponent()) != null) {
                return toFocus;
            }
            return super.getMostRecentFocusOwner();
        }

        @Override
        public void paint(Graphics g) {
            if (!SystemInfo.isMac || UIUtil.isUnderAquaLookAndFeel()) {
                UISettings.setupAntialiasing((Graphics)g);
            }
            super.paint(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focused";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeAheadDone";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRootPane";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFocusManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class DialogRootPane
        extends JRootPane
        implements DataProvider {
            private final boolean myGlassPaneIsSet;
            private Dimension myLastMinimumSize;

            private DialogRootPane() {
                this.setGlassPane(new IdeGlassPaneImpl(this));
                this.myGlassPaneIsSet = true;
                this.putClientProperty("DIALOG_ROOT_PANE", true);
                this.setBorder(UIManager.getBorder("Window.border"));
            }

            @Override
            @NotNull
            protected JLayeredPane createLayeredPane() {
                JBLayeredPane p = new JBLayeredPane();
                p.setName(this.getName() + ".layeredPane");
                JBLayeredPane jBLayeredPane = p;
                if (jBLayeredPane == null) {
                    DialogRootPane.$$$reportNull$$$0(0);
                }
                return jBLayeredPane;
            }

            @Override
            public void validate() {
                Dimension size;
                Window window;
                super.validate();
                DialogWrapper wrapper2 = (DialogWrapper)MyDialog.this.myDialogWrapper.get();
                if (wrapper2 != null && wrapper2.isAutoAdjustable() && (window = wrapper2.getWindow()) != null && !((size = this.getMinimumSize()) != null ? size.equals(this.myLastMinimumSize) : this.myLastMinimumSize == null)) {
                    if (size == null) {
                        this.myLastMinimumSize = null;
                    } else {
                        this.myLastMinimumSize = new Dimension(size);
                        JBInsets.addTo((Dimension)size, (Insets)window.getInsets());
                        Rectangle screen = ScreenUtil.getScreenRectangle((Component)window);
                        if (size.width > screen.width || size.height > screen.height) {
                            Application application = ApplicationManager.getApplication();
                            if (application != null && application.isInternal()) {
                                LOG.warn("minimum size " + size.width + "x" + size.height + " is bigger than screen " + screen.width + "x" + screen.height);
                            }
                            if (size.width > screen.width) {
                                size.width = screen.width;
                            }
                            if (size.height > screen.height) {
                                size.height = screen.height;
                            }
                        }
                    }
                    window.setMinimumSize(size);
                }
            }

            @Override
            public void setGlassPane(Component glass) {
                if (this.myGlassPaneIsSet) {
                    LOG.warn("Setting of glass pane for DialogWrapper is prohibited", (Throwable)new Exception());
                    return;
                }
                super.setGlassPane(glass);
            }

            @Override
            public void setContentPane(Container contentPane) {
                super.setContentPane(contentPane);
                if (contentPane != null) {
                    contentPane.addMouseMotionListener(new MouseMotionAdapter(){});
                }
            }

            public Object getData(@NotNull @NonNls String dataId) {
                DialogWrapper wrapper2;
                if (dataId == null) {
                    DialogRootPane.$$$reportNull$$$0(1);
                }
                return (wrapper2 = (DialogWrapper)MyDialog.this.myDialogWrapper.get()) != null && PlatformDataKeys.UI_DISPOSABLE.is(dataId) ? wrapper2.getDisposable() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog$DialogRootPane";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createLayeredPane";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog$DialogRootPane";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyWindowListener
        extends WindowAdapter {
            private MyWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DialogWrapper dialogWrapper = MyDialog.this.getDialogWrapper();
                if (dialogWrapper.shouldCloseOnCross()) {
                    dialogWrapper.doCancelAction((AWTEvent)e);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.saveSize();
            }

            public void saveSize() {
                if (MyDialog.this.myDimensionServiceKey != null && MyDialog.this.myInitialSize != null && MyDialog.this.myOpened) {
                    Project projectGuess = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)MyDialog.this));
                    Point location = MyDialog.this.getLocation();
                    DimensionService.getInstance().setLocation(MyDialog.this.myDimensionServiceKey, location, projectGuess);
                    Dimension size = MyDialog.this.getSize();
                    if (!MyDialog.this.myInitialSize.equals(size)) {
                        DimensionService.getInstance().setSize(MyDialog.this.myDimensionServiceKey, size, projectGuess);
                    }
                    MyDialog.this.myOpened = false;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(() -> {
                    MyDialog.this.myOpened = true;
                    DialogWrapper activeWrapper = this.getActiveWrapper();
                    for (JComponent c : UIUtil.uiTraverser((Component)e.getWindow()).filter(JComponent.class)) {
                        GraphicsUtil.setAntialiasingType((JComponent)c, (Object)AntialiasingType.getAAHintForSwingComponent());
                    }
                    if (activeWrapper == null) {
                        MyDialog.this.myFocusedCallback.setRejected();
                        MyDialog.this.myTypeAheadDone.setRejected();
                    }
                });
            }

            @Override
            public void windowActivated(WindowEvent e) {
                JComponent toFocus;
                DialogWrapper wrapper2 = this.getActiveWrapper();
                if (wrapper2 == null && !MyDialog.this.myFocusedCallback.isProcessed()) {
                    MyDialog.this.myFocusedCallback.setRejected();
                    MyDialog.this.myTypeAheadDone.setRejected();
                    return;
                }
                if (MyDialog.this.myActivated) {
                    return;
                }
                MyDialog.this.myActivated = true;
                JComponent jComponent = toFocus = wrapper2 == null ? null : wrapper2.getPreferredFocusedComponent();
                if (MyDialog.this.getRootPane() != null && toFocus == null) {
                    toFocus = MyDialog.this.getRootPane().getDefaultButton();
                }
                if (MyDialog.this.getRootPane() != null) {
                    IJSwingUtilities.moveMousePointerOn(MyDialog.this.getRootPane().getDefaultButton());
                }
                DialogWrapperPeerImpl.setupSelectionOnPreferredComponent(toFocus);
                if (toFocus != null) {
                    if (MyDialog.this.isShowing()) {
                        toFocus.requestFocus();
                        this.notifyFocused(wrapper2);
                    }
                } else if (MyDialog.this.isShowing()) {
                    this.notifyFocused(wrapper2);
                }
                if (MyDialog.this.myTypeAheadCallback != null) {
                    MyDialog.this.myTypeAheadCallback.setDone();
                }
            }

            private void notifyFocused(DialogWrapper wrapper2) {
                MyDialog.this.myFocusedCallback.setDone();
                long timeout = wrapper2.getTypeAheadTimeoutMs();
                if (timeout > 0L) {
                    SimpleTimer.getInstance().setUp((Runnable)new EdtRunnable(){

                        public void runEdt() {
                            MyDialog.this.myTypeAheadDone.setDone();
                        }
                    }, timeout);
                }
            }

            private DialogWrapper getActiveWrapper() {
                DialogWrapper activeWrapper = MyDialog.this.getDialogWrapper();
                if (activeWrapper == null || !activeWrapper.isShowing()) {
                    return null;
                }
                return activeWrapper;
            }
        }
    }

    private class AnCancelAction
    extends AnAction
    implements DumbAware {
        private AnCancelAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AnCancelAction.$$$reportNull$$$0(0);
            }
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            e.getPresentation().setEnabled(false);
            if (focusOwner instanceof JComponent && SpeedSearchBase.hasActiveSpeedSearch((JComponent)focusOwner)) {
                return;
            }
            if (StackingPopupDispatcher.getInstance().isPopupFocused()) {
                return;
            }
            JTree tree = (JTree)UIUtil.getParentOfType(JTree.class, (Component)focusOwner);
            JTable table = (JTable)UIUtil.getParentOfType(JTable.class, (Component)focusOwner);
            if ((tree != null || table != null) && this.hasNoEditingTreesOrTablesUpward(focusOwner)) {
                e.getPresentation().setEnabled(true);
            }
        }

        private boolean hasNoEditingTreesOrTablesUpward(Component comp) {
            while (comp != null) {
                if (this.isEditingTreeOrTable(comp)) {
                    return false;
                }
                comp = comp.getParent();
            }
            return true;
        }

        private boolean isEditingTreeOrTable(Component comp) {
            if (comp instanceof JTree) {
                return ((JTree)comp).isEditing();
            }
            if (comp instanceof JTable) {
                return ((JTable)comp).isEditing();
            }
            return false;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AnCancelAction.$$$reportNull$$$0(1);
            }
            DialogWrapperPeerImpl.this.myWrapper.doCancelAction((AWTEvent)e.getInputEvent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$AnCancelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

