/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushedFilePropertiesUpdaterImpl
extends PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater");
    private final Project myProject;
    private final FilePropertyPusher[] myPushers;
    private final FilePropertyPusher[] myFilePushers;
    private final Queue<Runnable> myTasks = new ConcurrentLinkedQueue<Runnable>();

    public PushedFilePropertiesUpdaterImpl(final Project project) {
        this.myProject = project;
        this.myPushers = (FilePropertyPusher[])FilePropertyPusher.EP_NAME.getExtensions();
        this.myFilePushers = (FilePropertyPusher[])ContainerUtil.findAllAsArray((Object[])this.myPushers, pusher -> !pusher.pushDirectoriesOnly());
        StartupManager.getInstance((Project)project).registerPreStartupActivity(() -> project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (FilePropertyPusher pusher : PushedFilePropertiesUpdaterImpl.this.myPushers) {
                    pusher.afterRootsChanged(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$1", "rootsChanged"));
            }
        }));
    }

    public void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(0);
        }
        boolean pushedSomething = false;
        ArrayList delayedTasks = ContainerUtil.newArrayList();
        for (VFileEvent vFileEvent : events) {
            FilePropertyPusher[] pushers;
            VirtualFile file2 = vFileEvent.getFile();
            if (vFileEvent instanceof VFileCopyEvent) {
                file2 = ((VFileCopyEvent)vFileEvent).getNewParent().findChild(((VFileCopyEvent)vFileEvent).getNewChildName());
            }
            if (file2 == null || (pushers = file2.isDirectory() ? this.myPushers : this.myFilePushers).length == 0) continue;
            if (vFileEvent instanceof VFileCreateEvent) {
                if (!vFileEvent.isFromRefresh() || !file2.isDirectory()) {
                    this.doPushRecursively(file2, pushers, ProjectRootManager.getInstance((Project)this.myProject).getFileIndex());
                    pushedSomething = true;
                    continue;
                }
                if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) continue;
                ContainerUtil.addIfNotNull((Collection)delayedTasks, (Object)this.createRecursivePushTask(file2, pushers));
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent)) continue;
            for (FilePropertyPusher pusher : pushers) {
                file2.putUserData(pusher.getFileDataKey(), null);
            }
            this.doPushRecursively(file2, pushers, ProjectRootManager.getInstance((Project)this.myProject).getFileIndex());
            pushedSomething = true;
        }
        if (!delayedTasks.isEmpty()) {
            this.queueTasks(delayedTasks);
        }
        if (pushedSomething) {
            GuiUtils.invokeLaterIfNeeded(() -> this.scheduleDumbModeReindexingIfNeeded(), (ModalityState)ModalityState.defaultModalityState());
        }
    }

    public void initializeProperties() {
        for (final FilePropertyPusher pusher : this.myPushers) {
            pusher.initExtra(this.myProject, this.myProject.getMessageBus(), new FilePropertyPusher.Engine(){

                public void pushAll() {
                    PushedFilePropertiesUpdaterImpl.this.pushAll(pusher);
                }

                public void pushRecursively(@NotNull VirtualFile file2, @NotNull Project project) {
                    if (file2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    PushedFilePropertiesUpdaterImpl.this.queueTasks(ContainerUtil.createMaybeSingletonList((Object)PushedFilePropertiesUpdaterImpl.this.createRecursivePushTask(file2, new FilePropertyPusher[]{pusher})));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$2";
                    objectArray[2] = "pushRecursively";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public void pushAllPropertiesNow() {
        this.performPushTasks();
        this.doPushAll(this.myPushers);
    }

    @Nullable
    private Runnable createRecursivePushTask(VirtualFile dir, FilePropertyPusher[] pushers) {
        if (pushers.length == 0) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (!fileIndex.isInContent(dir)) {
            return null;
        }
        return () -> this.doPushRecursively(dir, pushers, fileIndex);
    }

    private void doPushRecursively(VirtualFile dir, FilePropertyPusher[] pushers, ProjectFileIndex fileIndex) {
        fileIndex.iterateContentUnderDirectory(dir, fileOrDir -> {
            this.applyPushersToFile(fileOrDir, pushers, null);
            return true;
        });
    }

    private void queueTasks(List<? extends Runnable> actions) {
        for (Runnable runnable2 : actions) {
            this.myTasks.offer(runnable2);
        }
        final DumbModeTask task2 = new DumbModeTask((Object)this){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                PushedFilePropertiesUpdaterImpl.this.performPushTasks();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$3", "performInDumbMode"));
            }
        };
        this.myProject.getMessageBus().connect((Disposable)task2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                DumbService.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).cancelTask(task2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$4", "rootsChanged"));
            }
        });
        DumbService.getInstance((Project)this.myProject).queueTask(task2);
    }

    private void performPushTasks() {
        Runnable task2;
        boolean hadTasks = false;
        while ((task2 = this.myTasks.poll()) != null) {
            try {
                task2.run();
                hadTasks = true;
            }
            catch (ProcessCanceledException e) {
                this.queueTasks(Collections.singletonList(task2));
                throw e;
            }
        }
        if (hadTasks) {
            this.scheduleDumbModeReindexingIfNeeded();
        }
    }

    private void scheduleDumbModeReindexingIfNeeded() {
        if (this.myProject.isDisposed()) {
            return;
        }
        DumbModeTask task2 = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task2 != null) {
            DumbService.getInstance((Project)this.myProject).queueTask(task2);
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile fileOrDir, @NotNull Condition<? super VirtualFile> acceptFileCondition) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(1);
        }
        if (acceptFileCondition == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(2);
        }
        if (fileOrDir.isDirectory()) {
            for (VirtualFile child2 : fileOrDir.getChildren()) {
                if (child2.isDirectory() || !acceptFileCondition.value((Object)child2)) continue;
                this.filePropertiesChanged(child2);
            }
        } else if (acceptFileCondition.value((Object)fileOrDir)) {
            this.filePropertiesChanged(fileOrDir);
        }
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<? extends T> pusher, T moduleValue) {
        Object value = pusher.getImmediateValue(project, dir);
        if (value != null) {
            return (T)value;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        return PushedFilePropertiesUpdaterImpl.findPusherValuesFromParent(project, dir, pusher);
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<? extends T> pusher) {
        Object userValue = dir.getUserData(pusher.getFileDataKey());
        if (userValue != null) {
            return (T)userValue;
        }
        Object value = pusher.getImmediateValue(project, dir);
        if (value != null) {
            return (T)value;
        }
        return PushedFilePropertiesUpdaterImpl.findPusherValuesFromParent(project, dir, pusher);
    }

    private static <T> T findPusherValuesFromParent(Project project, VirtualFile dir, FilePropertyPusher<? extends T> pusher) {
        VirtualFile parent = dir.getParent();
        if (parent != null && ProjectFileIndex.getInstance((Project)project).isInContent(parent)) {
            return PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(project, parent, pusher);
        }
        Object projectValue = pusher.getImmediateValue(project, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    public void pushAll(FilePropertyPusher ... pushers) {
        this.queueTasks(Collections.singletonList(() -> this.doPushAll(pushers)));
    }

    private void doPushAll(FilePropertyPusher[] pushers) {
        Module[] modules = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).getModules());
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (Module module : modules) {
            Runnable iteration = (Runnable)ReadAction.compute(() -> {
                if (module.isDisposed()) {
                    return EmptyRunnable.INSTANCE;
                }
                ProgressManager.checkCanceled();
                Object[] moduleValues = new Object[pushers.length];
                for (int i = 0; i < moduleValues.length; ++i) {
                    moduleValues[i] = pushers[i].getImmediateValue(module);
                }
                ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                return () -> fileIndex.iterateContent(fileOrDir -> {
                    this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                    return true;
                });
            });
            tasks.add(iteration);
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public static void invokeConcurrentlyIfPossible(List<? extends Runnable> tasks) {
        Runnable runnable2;
        if (tasks.size() == 1 || ApplicationManager.getApplication().isWriteAccessAllowed()) {
            for (Runnable runnable3 : tasks) {
                runnable3.run();
            }
            return;
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        ConcurrentLinkedQueue<? extends Runnable> concurrentLinkedQueue = new ConcurrentLinkedQueue<Runnable>(tasks);
        ArrayList results = ContainerUtil.newArrayList();
        if (tasks.size() > 1) {
            int numThreads = Math.max(Math.min(CacheUpdateRunner.indexingThreadCount() - 1, tasks.size() - 1), 1);
            for (int i = 0; i < numThreads; ++i) {
                results.add(ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
                    Runnable runnable2;
                    while ((runnable2 = (Runnable)tasksQueue.poll()) != null) {
                        runnable2.run();
                    }
                }, (ProgressIndicator)ProgressWrapper.wrap(progress))));
            }
        }
        while ((runnable2 = concurrentLinkedQueue.poll()) != null) {
            runnable2.run();
        }
        for (Future result2 : results) {
            try {
                result2.get();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private void applyPushersToFile(VirtualFile fileOrDir, FilePropertyPusher[] pushers, Object[] moduleValues) {
        ApplicationManager.getApplication().runReadAction(() -> {
            ProgressManager.checkCanceled();
            if (!fileOrDir.isValid()) {
                return;
            }
            this.doApplyPushersToFile(fileOrDir, pushers, moduleValues);
        });
    }

    private void doApplyPushersToFile(VirtualFile fileOrDir, FilePropertyPusher[] pushers, Object[] moduleValues) {
        Object pusher = null;
        try {
            boolean isDir = fileOrDir.isDirectory();
            int pushersLength = pushers.length;
            for (int i = 0; i < pushersLength; ++i) {
                pusher = pushers[i];
                if (!isDir && (pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir, this.myProject)) || isDir && !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
                this.findAndUpdateValue(fileOrDir, (FilePropertyPusher)pusher, (Object)(moduleValues != null ? moduleValues[i] : null));
            }
        }
        catch (AbstractMethodError ame) {
            if (pusher != null) {
                throw PluginException.createByClass((String)("Failed to apply pusher " + pusher.getClass()), (Throwable)ame, pusher.getClass());
            }
            throw ame;
        }
    }

    public <T> void findAndUpdateValue(VirtualFile fileOrDir, FilePropertyPusher<T> pusher, T moduleValue) {
        T value = PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(this.myProject, fileOrDir, pusher, moduleValue);
        PushedFilePropertiesUpdaterImpl.updateValue(this.myProject, fileOrDir, value, pusher);
    }

    public static <T> void updateValue(Project project, VirtualFile fileOrDir, T value, FilePropertyPusher<T> pusher) {
        Object oldValue = fileOrDir.getUserData(pusher.getFileDataKey());
        if (value != oldValue) {
            fileOrDir.putUserData(pusher.getFileDataKey(), value);
            try {
                pusher.persistAttribute(project, fileOrDir, value);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileBasedIndex.getInstance().requestReindex(file2);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PushedFilePropertiesUpdaterImpl.reloadPsi(file2, project);
        }
    }

    private static void reloadPsi(VirtualFile file2, Project project) {
        FileManagerImpl fileManager = (FileManagerImpl)((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager();
        if (fileManager.findCachedViewProvider(file2) != null) {
            Runnable runnable2 = () -> WriteAction.run(() -> fileManager.forceReload(file2));
            if (ApplicationManager.getApplication().isDispatchThread()) {
                runnable2.run();
            } else {
                TransactionGuard.submitTransaction((Disposable)project, (Runnable)runnable2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptFileCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAfterVfsChanges";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filePropertiesChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

