/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;
    private final VirtualFileFilter myContentFilter;

    FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (directoryIndex == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        if (fileTypeManager == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        this.myContentFilter = file2 -> {
            assert (file2 != null);
            return (Boolean)ReadAction.compute(() -> !this.isScopeDisposed() && this.isInContent(file2));
        };
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    protected abstract boolean isScopeDisposed();

    public boolean iterateContent(@NotNull ContentIterator processor2) {
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        return this.iterateContent(processor2, null);
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2, @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        VirtualFileFilter filter = customFilter != null ? file2 -> this.myContentFilter.accept(file2) && customFilter.accept(file2) : this.myContentFilter;
        return FileIndexBase.iterateContentUnderDirectoryWithFilter(dir, processor2, filter);
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return this.iterateContentUnderDirectory(dir, processor2, null);
    }

    protected boolean isTestSourcesRoot(@NotNull DirectoryInfo info) {
        JpsModuleSourceRootType<?> rootType;
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        return (rootType = this.myDirectoryIndex.getSourceRootType(info)) != null && rootType.isForTests();
    }

    private static boolean iterateContentUnderDirectoryWithFilter(@NotNull VirtualFile dir, @NotNull ContentIterator iterator, @NotNull VirtualFileFilter filter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        if (iterator == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)filter, (ContentIterator)iterator);
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file2);
        if (directoryInfo == null) {
            FileIndexBase.$$$reportNull$$$0(12);
        }
        return directoryInfo;
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(13);
        }
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }

    @NotNull
    protected static VirtualFile[][] getModuleContentAndSourceRoots(@NotNull Module module) {
        if (module == null) {
            FileIndexBase.$$$reportNull$$$0(14);
        }
        VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{ModuleRootManager.getInstance((Module)module).getContentRoots(), ModuleRootManager.getInstance((Module)module).getSourceRoots()};
        if (virtualFileArrayArray == null) {
            FileIndexBase.$$$reportNull$$$0(15);
        }
        return virtualFileArrayArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFileOrDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentAndSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourcesRoot";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectoryWithFilter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFileOrDirectory";
                break;
            }
            case 12: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isContentSourceFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModuleContentAndSourceRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

