/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectFilesToAddTextsToPatchPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel");

    public static Set<Change> getBig(List<? extends Change> changes2) {
        HashSet<Change> exclude = new HashSet<Change>();
        for (Change change : changes2) {
            VirtualFile virtualFile = SelectFilesToAddTextsToPatchPanel.getVfFromChange(change);
            if (virtualFile != null) {
                if (!SelectFilesToAddTextsToPatchPanel.isBig(virtualFile)) continue;
                exclude.add(change);
                continue;
            }
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision == null) continue;
            try {
                String content = beforeRevision.getContent();
                if (content == null) {
                    FilePath file2 = beforeRevision.getFile();
                    LOG.info("null content for " + file2.getPath() + ", is dir: " + file2.isDirectory());
                    continue;
                }
                if ((long)content.length() <= 500000L) continue;
                exclude.add(change);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
        return exclude;
    }

    private static boolean isBig(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            SelectFilesToAddTextsToPatchPanel.$$$reportNull$$$0(0);
        }
        return virtualFile.getLength() > 500000L;
    }

    @Nullable
    private static VirtualFile getVfFromChange(@NotNull Change change) {
        ContentRevision after;
        if (change == null) {
            SelectFilesToAddTextsToPatchPanel.$$$reportNull$$$0(1);
        }
        return (after = change.getAfterRevision()) != null ? after.getFile().getVirtualFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/SelectFilesToAddTextsToPatchPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isBig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVfFromChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

